DELIMITER $$
DROP PROCEDURE IF EXISTS V20251208152312__Insert_EmailDeferredRetakeTrans $$
CREATE PROCEDURE V20251208152312__Insert_EmailDeferredRetakeTrans()
BEGIN

IF NOT EXISTS (
    SELECT * FROM `ui_translation` 
    WHERE objectName = 'MESSAGING_TRANSLATIONS' 
      AND keyName = 'EMAIL_MARKSHEET_FOR_DEFERRED_RETAKE_STATUS'
) THEN
INSERT INTO `ui_translation` (
    `objectName`, `keyName`, `defaultValue`, `customerDefineValue`, 
    `russLanguage`, `frenLanguage`, `afriLanguage`, `vietLanguage`, `spanLanguage`, 
    `lastUpdate`, `lastUpdatedBy`
)
VALUES (
    'MESSAGING_TRANSLATIONS', 'EMAIL_MARKSHEET_FOR_DEFERRED_RETAKE_STATUS',
    'Email Marksheet For Deferred Retake Status', 'Email Marksheet For Deferred Retake Status',
    NULL, NULL, 'E-pos puntelys vir uitgestelde herhalingstatus', 'Email bảng điểm cho trạng thái hoãn thi lại', NULL,
    NOW(), 1
);
END IF;


IF NOT EXISTS (
    SELECT * FROM `picklist_translation` 
    WHERE `key` = 'EMAIL_MARKSHEET_FOR_DEFERRED_RETAKE_STATUS'
) THEN
INSERT INTO `picklist_translation` (`key`, `en`)
VALUES ('EMAIL_MARKSHEET_FOR_DEFERRED_RETAKE_STATUS', 'Email Marksheet For Deferred Retake Status');
END IF;

IF NOT EXISTS (
    SELECT * FROM `ui_translation` 
    WHERE objectName = 'MESSAGING_TRANSLATIONS' 
      AND keyName = 'EMAIL_MARKSHEET_FOR_DEFERRED_RETAKE_STATUS_RECIPIENT'
) THEN
INSERT INTO `ui_translation` (
    `objectName`, `keyName`, `defaultValue`, `customerDefineValue`, 
    `russLanguage`, `frenLanguage`, `afriLanguage`, `vietLanguage`, `spanLanguage`, 
    `lastUpdate`, `lastUpdatedBy`
)
VALUES (
    'MESSAGING_TRANSLATIONS', 'EMAIL_MARKSHEET_FOR_DEFERRED_RETAKE_STATUS_RECIPIENT',
    'Email Marksheet For Deferred Retake Status Recipient', 'Email Marksheet For Deferred Retake Status Recipient',
    NULL, NULL, 'E-pospuntblad vir ontvanger van uitgestelde herhalingsstatus', 'Email về bảng điểm cho người nhận trạng thái hoãn thi lại', NULL,
    NOW(), 1
);
END IF;


IF NOT EXISTS (
    SELECT * FROM `picklist_translation` 
    WHERE `key` = 'EMAIL_MARKSHEET_FOR_DEFERRED_RETAKE_STATUS_RECIPIENT'
) THEN
INSERT INTO `picklist_translation` (`key`, `en`)
VALUES ('EMAIL_MARKSHEET_FOR_DEFERRED_RETAKE_STATUS_RECIPIENT', 'Email Marksheet For Deferred Retake Status Recipient');
END IF;


END $$
CALL V20251208152312__Insert_EmailDeferredRetakeTrans() $$
DROP PROCEDURE IF EXISTS V20251208152312__Insert_EmailDeferredRetakeTrans $$
DELIMITER ;