DELIMITER $$
DROP PROCEDURE IF EXISTS V20251222143759__Create_TermsAndCondition $$
CREATE PROCEDURE V20251222143759__Create_TermsAndCondition()
BEGIN

IF NOT EXISTS (SELECT * FROM information_schema.Tables WHERE table_schema = DATABASE() AND table_name = 'terms_and_condition') THEN
CREATE TABLE IF NOT EXISTS `terms_and_condition` (
    `id` BIGINT NOT NULL AUTO_INCREMENT,
    `isAdmin` BIT(1) DEFAULT 0,
    `isFaculty` BIT(1) DEFAULT 0,
    `isStudent` BIT(1) DEFAULT 0,
    `isParent` BIT(1) DEFAULT 0,
    `isApplicant` BIT(1) DEFAULT 0,
    `isAlumini` BIT(1) DEFAULT 0,
    `termsAndCondition` TEXT DEFAULT NULL,
    `numberOfDays` INT DEFAULT 0,
    `lastUpdatedBy` BIGINT DEFAULT NULL,
    `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
     PRIMARY KEY (`id`),
     KEY `terms_and_condition_CSM_lastUpdatedBy` (`lastUpdatedBy`),
     CONSTRAINT `terms_and_condition_CSM_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
    );
END IF;
IF NOT EXISTS ((SELECT * FROM standard_master WHERE tableName = 'terms_and_condition')) THEN 
SET @standardMasterId=(SELECT MAX(id) FROM standard_master);
INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, `droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterId+1, NULL,'terms_and_condition','TERMS_AND_CONDITION','Tools & Services','COMMON_MASTER',0,1,NULL,1,now());

SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master WHERE tableName = 'terms_and_condition') ;
SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'termsAndCondition', 'TERMSANDCONDITION', @standardMasterMaxId, 'TextArea', '1', 0, 0, 0, 0, '1', now());

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'isAdmin', 'IS_ADMIN_PORTAL', @standardMasterMaxId, 'Boolean', '2', 0, 0, 0, 0, '1', now());

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'isFaculty', 'IS_FACULTY_PORTAL', @standardMasterMaxId, 'Boolean', '3', 0, 0, 0, 0, '1', now());

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'isStudent', 'IS_STUDENT_PORTAL', @standardMasterMaxId, 'Boolean', '4', 0, 0, 0, 0, '1', now());

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'isParent', 'IS_PARENT_PORTAL', @standardMasterMaxId, 'Boolean', '5', 0, 0, 0, 0, '1', now());

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'isApplicant', 'IS_APPLICANT_PORTAL', @standardMasterMaxId, 'Boolean', '6', 0, 0, 0, 0, '1', now());

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'isAlumini', 'IS_ALUMINI_PORTAL', @standardMasterMaxId, 'Boolean', '7', 0, 0, 0, 0, '1', now());

INSERT INTO standard_master_items(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`,`maxLength`, `minLength`, `lastUpdatedBy`, `lastUpdate`) 
VALUES ('numberOfDays', 'NO_OF_DAYS', @standardMasterMaxId, 'Number', '8', 0, 0, 0, 0,'3','0', '1', now());

END IF;
END $$
CALL V20251222143759__Create_TermsAndCondition () $$ 
DROP PROCEDURE IF EXISTS V20251222143759__Create_TermsAndCondition $$ 
DELIMITER ;