DELIMITER $$
DROP PROCEDURE IF EXISTS V20251223122645__Alter_CourseCompoAddHours $$
CREATE PROCEDURE V20251223122645__Alter_CourseCompoAddHours()
BEGIN

IF NOT EXISTS (
    SELECT 1 
    FROM information_schema.COLUMNS
    WHERE table_name = 'course_components'
      AND column_name = 'componentHours'
      AND table_schema = DATABASE()
) THEN
    ALTER TABLE course_components
        ADD COLUMN componentHours int  DEFAULT NULL;
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='TRANSLATIONS' AND keyName='COURSE_COMPONENT_HOURS')) THEN
INSERT INTO ui_translation (objectName,keyName,defaultValue,customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
VALUES ('TRANSLATIONS','COURSE_COMPONENT_HOURS','Course Component Hours','Course Component Hours','','',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM form_field_info WHERE formAliasName='coursecomponentform' AND formFieldName='courseComponentHours')) THEN
INSERT INTO `form_field_info` 
(`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formScreenName`,`formScreenMode`)
VALUES
('coursecomponentform','courseComponentHours','courseComponentHoursId','numberfield',0,0,NULL,1,now(),'Course Component Hours','Course Components','Create, Edit, and View');
END IF;

END $$
CALL V20251223122645__Alter_CourseCompoAddHours() $$
DROP PROCEDURE IF EXISTS V20251223122645__Alter_CourseCompoAddHours $$
DELIMITER ;