DELIMITER $$
DROP PROCEDURE IF EXISTS V20251223143036__Insert_DisabilityDescriptionAPSetUp $$
CREATE PROCEDURE V20251223143036__Insert_DisabilityDescriptionAPSetUp()
BEGIN

IF NOT EXISTS ((SELECT * FROM form_field_info WHERE formAliasName = 'personalinformationform' and formFieldId = 'disabilityDescription')) THEN 
INSERT INTO form_field_info (formAliasName,formFieldName,formFieldId,formFieldInputType,isMandatory,isLocked,defaultValue,lastUpdatedBy,lastUpdate,formFieldDefaultLabel,formFieldDefaultHelpText,formScreenName,formScreenMode,fieldDisplayName,whetherForAllAcademyLocation)
VALUES ('personalinformationform','disabilityDescription','disabilityDescription','multiselectcombofield',0,0,NULL,1,now(),'Disability Description','1','Personal Details Info','Create, Edit, and View','Disability Description',0);
END IF; 

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='PORTAL_SETUP_NEW' AND keyName='DISABILITY_DESCRIPTION')) THEN
INSERT INTO ui_translation (objectName,keyName,defaultValue,customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
VALUES ('PORTAL_SETUP_NEW','DISABILITY_DESCRIPTION','Disability Description','Disability Description','Beskrywing van gestremdheid','Mô tả khuyết tật',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='PORTAL_SETUP_NEW' AND keyName='APPLICATION_ALREADY_SUBMITTED')) THEN
INSERT INTO ui_translation (objectName,keyName,defaultValue,customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
VALUES ('PORTAL_SETUP_NEW','APPLICATION_ALREADY_SUBMITTED','Your Application is already submitted.','Your Application is already submitted.','Jou aansoek is reeds ingedien.','Đơn đăng ký của bạn đã được gửi.',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='TRANSLATIONS' AND keyName='PROVISIONAL_ADMISSION_REPORT_LIST')) THEN
INSERT INTO ui_translation (objectName,keyName,defaultValue,customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
VALUES ('TRANSLATIONS','PROVISIONAL_ADMISSION_REPORT_LIST','Provisional Admission Report List','Provisional Admission Report List','Voorlopige Toelatingsverslaglys','Danh sách báo cáo nhập học tạm thời',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='TRANSLATIONS' AND keyName='BUZZ_CAMPAIGN_LIST')) THEN
INSERT INTO ui_translation (objectName,keyName,defaultValue,customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
VALUES ('TRANSLATIONS','BUZZ_CAMPAIGN_LIST','Buzz Campaign List','Buzz Campaign List','Buzz-veldtoglys','Danh sách chiến dịch gây chú ý',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='TRANSLATIONS' AND keyName='DTEF_ADMISSION_LIST')) THEN
INSERT INTO ui_translation (objectName,keyName,defaultValue,customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
VALUES ('TRANSLATIONS','DTEF_ADMISSION_LIST','DTEF Admission List','DTEF Admission List','DTEF Toelatingslys','Danh sách trúng tuyển DTEF',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='TRANSLATIONS' AND keyName='DTEF_COURSE_ENROLLMENT_LIST')) THEN
INSERT INTO ui_translation (objectName,keyName,defaultValue,customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
VALUES ('TRANSLATIONS','DTEF_COURSE_ENROLLMENT_LIST','DTEF Course Enrollment List','DTEF Course Enrollment List','DTEF Kursus Inskrywingslys','Danh sách đăng ký khóa học DTEF',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='TRANSLATIONS' AND keyName='DTEF_MODULE_RESULTS_LIST')) THEN
INSERT INTO ui_translation (objectName,keyName,defaultValue,customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
VALUES ('TRANSLATIONS','DTEF_MODULE_RESULTS_LIST','DTEF Module Results List','DTEF Module Results List','DTEF Module Resultate Lys','Danh sách kết quả mô-đun DTEF',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='TRANSLATIONS' AND keyName='DTEF_INVOICES_LIST')) THEN
INSERT INTO ui_translation (objectName,keyName,defaultValue,customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
VALUES ('TRANSLATIONS','DTEF_INVOICES_LIST','DTEF Invoice List','DTEF Invoice List','DTEF Faktuurlys','Danh sách hóa đơn DTEF',now(),1);
END IF;

END $$
CALL V20251223143036__Insert_DisabilityDescriptionAPSetUp() $$
DROP PROCEDURE IF EXISTS V20251223143036__Insert_DisabilityDescriptionAPSetUp $$
DELIMITER ;