DELIMITER $$
DROP PROCEDURE IF EXISTS V20251225132743__Create_amenities $$
CREATE PROCEDURE V20251225132743__Create_amenities()
BEGIN

IF NOT EXISTS (SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='amenities') THEN 

CREATE TABLE IF NOT EXISTS `amenities` (
		`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
		`itemCode` VARCHAR(255) NOT NULL,
		`itemValue` VARCHAR(255) NOT NULL,
		`isActive` bit(1) NOT NULL DEFAULT b'0',
		`lastUpdatedBy` BIGINT(20) NOT NULL,
		`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP, 
		PRIMARY KEY (`id`),
		UNIQUE KEY `fk_amenities_code_idx` (`itemCode`),
		FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
	) ENGINE=InnoDB;

	SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);

	SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
	INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, `droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
	VALUES (@standardMasterMaxId+1, NULL,'amenities','AMENITIES','Examinations','COMMON_MASTER',0,0,NULL,1,@currentTimeStamp);

	SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
	INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
	VALUES (@ItemsMaxId+1, 'code', 'AMENITIES_CODE', @standardMasterMaxId+1, 'varchar', '1', 0, 0, 0, 0, '1', SYSDATE());

	SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
	INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
	VALUES (@ItemsMaxId+1, 'value', 'AMENITIES_VALUE', @standardMasterMaxId+1, 'varchar', '2', 0, 0, 0, 0, '1', SYSDATE());

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
	INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
	VALUES (@ItemsMaxId+1, 'isActive', 'IS_ACTIVE', @standardMasterMaxId+1, 'boolean', '2', 0, 0, 0, 0, '1', SYSDATE());

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='masterNames' AND keyName='AMENITIES')) THEN
INSERT INTO ui_translation (objectName,keyName,defaultValue,customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
VALUES ('masterNames','AMENITIES','Amenities','Amenities','','',now(),1);
END IF; 

 IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='TRANSLATIONS' AND keyName='AMENITIES_CODE')) THEN
INSERT INTO ui_translation (objectName,keyName,defaultValue,customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
VALUES ('TRANSLATIONS','AMENITIES_CODE','Amenities Code','Amenities Code','','',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='TRANSLATIONS' AND keyName='AMENITIES_VALUE')) THEN
INSERT INTO ui_translation (objectName,keyName,defaultValue,customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
VALUES ('TRANSLATIONS','AMENITIES_VALUE','Amenities Value','Amenities Value','','',now(),1);
END IF; 



END IF; 

END $$
CALL V20251225132743__Create_amenities () $$ 
DROP PROCEDURE IF EXISTS V20251225132743__Create_amenities $$ 
DELIMITER ;