DELIMITER $$
DROP PROCEDURE IF EXISTS V20260107113328__Update_terms_and_condition $$
CREATE PROCEDURE V20260107113328__Update_terms_and_condition()
BEGIN
	
IF EXISTS (
SELECT 1
FROM information_schema.tables
WHERE table_schema = DATABASE()
AND table_name = 'terms_and_condition'
 ) THEN	

        SET @standardMasterMaxId = (
            SELECT id
            FROM standard_master
            WHERE tableName = 'terms_and_condition'
        );

        SET @ItemsMaxId = (
            SELECT IFNULL(MAX(id), 0)
            FROM standard_master_items
        );
        
        IF NOT EXISTS (
        SELECT 1
        FROM standard_master_items
        WHERE fieldLabel = 'HEADING'
          AND standardMasterId = @standardMasterMaxId
    ) THEN

        INSERT INTO standard_master_items
        (
            `id`,
            `dbFieldName`,
            `fieldLabel`,
            `standardMasterId`,
            `fieldType`,
            `diaplayOrder`,
            `whetherForeignKey`,
            `whetherShortCode`,
            `whetherReadOnly`,
            `wheherNullable`,
            `lastUpdatedBy`,
            `lastUpdate`
        )
        VALUES
        (
            @ItemsMaxId + 1,
            'heading',
            'HEADING',
            @standardMasterMaxId,
            'TextArea',
            1,
            0,
            0,
            0,
            0,
            '1',
            NOW()
        );
         END IF;

        SET SQL_SAFE_UPDATES = 0;

        IF EXISTS (
            SELECT 1
            FROM standard_master_items
            WHERE dbFieldName='termsAndCondition' AND fieldLabel='TERMSANDCONDITION' AND standardMasterId=@standardMasterMaxId
        ) THEN
            UPDATE standard_master_items
            SET diaplayOrder = 2
            WHERE dbFieldName='termsAndCondition' AND fieldLabel='TERMSANDCONDITION' AND standardMasterId=@standardMasterMaxId;
        END IF;

        IF EXISTS (
            SELECT 1
            FROM standard_master_items
            WHERE dbFieldName='isAdmin' AND fieldLabel='IS_ADMIN_PORTAL' AND standardMasterId=@standardMasterMaxId
        ) THEN
            UPDATE standard_master_items
            SET diaplayOrder = 3
            WHERE dbFieldName='isAdmin' AND fieldLabel='IS_ADMIN_PORTAL' AND standardMasterId=@standardMasterMaxId;
        END IF;

        IF EXISTS (
            SELECT 1
            FROM standard_master_items
            WHERE dbFieldName='isFaculty' AND fieldLabel='IS_FACULTY_PORTAL' AND standardMasterId=@standardMasterMaxId
        ) THEN
            UPDATE standard_master_items
            SET diaplayOrder = 4
            WHERE dbFieldName='isFaculty' AND fieldLabel='IS_FACULTY_PORTAL' AND standardMasterId=@standardMasterMaxId;
        END IF;

        IF EXISTS (
            SELECT 1
            FROM standard_master_items
            WHERE dbFieldName='isStudent' AND fieldLabel='IS_STUDENT_PORTAL' AND standardMasterId=@standardMasterMaxId
        ) THEN
            UPDATE standard_master_items
            SET diaplayOrder = 5
            WHERE dbFieldName='isStudent' AND fieldLabel='IS_STUDENT_PORTAL' AND standardMasterId=@standardMasterMaxId;
        END IF;

        IF EXISTS (
            SELECT 1
            FROM standard_master_items
            WHERE dbFieldName='isParent' AND fieldLabel='IS_PARENT_PORTAL' AND standardMasterId=@standardMasterMaxId
        ) THEN
            UPDATE standard_master_items
            SET diaplayOrder = 6
            WHERE dbFieldName='isParent' AND fieldLabel='IS_PARENT_PORTAL' AND standardMasterId=@standardMasterMaxId;
        END IF;

        IF EXISTS (
            SELECT 1
            FROM standard_master_items
            WHERE dbFieldName='isApplicant' AND fieldLabel='IS_APPLICANT_PORTAL' AND standardMasterId=@standardMasterMaxId
        ) THEN
            UPDATE standard_master_items
            SET diaplayOrder = 7
            WHERE dbFieldName='isApplicant' AND fieldLabel='IS_APPLICANT_PORTAL' AND standardMasterId=@standardMasterMaxId;
        END IF;

        IF EXISTS (
            SELECT 1
            FROM standard_master_items
            WHERE dbFieldName='isAlumini' AND fieldLabel='IS_ALUMINI_PORTAL' AND standardMasterId=@standardMasterMaxId
        ) THEN
            UPDATE standard_master_items
            SET diaplayOrder = 8
            WHERE dbFieldName='isAlumini' AND fieldLabel='IS_ALUMINI_PORTAL' AND standardMasterId=@standardMasterMaxId;
        END IF;

        IF EXISTS (
            SELECT 1
            FROM standard_master_items
            WHERE dbFieldName='numberOfDays' AND fieldLabel='NO_OF_DAYS' AND standardMasterId=@standardMasterMaxId
        ) THEN
            UPDATE standard_master_items
            SET diaplayOrder = 9
            WHERE dbFieldName='numberOfDays' AND fieldLabel='NO_OF_DAYS' AND standardMasterId=@standardMasterMaxId;
        END IF;
        
        
IF NOT EXISTS (
    SELECT 1
    FROM information_schema.columns
    WHERE table_schema = DATABASE()
      AND table_name = 'terms_and_condition'
      AND column_name = 'heading'
) THEN
    ALTER TABLE terms_and_condition
    ADD COLUMN heading TEXT AFTER isAlumini;
END IF;

        SET SQL_SAFE_UPDATES = 1;

END IF;
END $$
CALL V20260107113328__Update_terms_and_condition () $$
DROP PROCEDURE IF EXISTS V20260107113328__Update_terms_and_condition $$
DELIMITER ;