
set foreign_key_checks=0;


DROP TABLE  IF EXISTS `question_paper`;
CREATE TABLE `question_paper` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `questionPaperStructId` bigint(20) DEFAULT NULL,
  `questionPaperAssignTo` bigint(20) DEFAULT NULL,
  `isModelPaper` bit(1) DEFAULT NULL,
  `answerKeyLocation` varchar(255) DEFAULT NULL,
  `questionPaperStatus` varchar(45) DEFAULT NULL COMMENT 'pending,submitted,approved',
  `questionPaperCode` varchar(255) DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL,
  `whetherDeleted` bit(1) DEFAULT b'0',
  `approverId` bigint(20) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Refquestion_paper_structure783` (`questionPaperStructId`),
  KEY `Refusers1381` (`lastUpdatedBy`),
  KEY `Refusers1823` (`approverId`),
  CONSTRAINT `Refquestion_paper_structure783` FOREIGN KEY (`questionPaperStructId`) REFERENCES `question_paper_structure` (`id`),
  CONSTRAINT `Refusers1381` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
  CONSTRAINT `Refusers1823` FOREIGN KEY (`approverId`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE  IF EXISTS  `question_paper_details` ;
CREATE TABLE `question_paper_details` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `questionPaperId` bigint(20) DEFAULT NULL,
  `questionDescription` varchar(255) DEFAULT NULL,
  `courseTopicId` bigint(20) DEFAULT NULL,
  `questionType` varchar(255) DEFAULT NULL COMMENT 'Match the following,Sngle correct from,Multiple choices,Multiple correct from multiple choices,Fill in the blanks, \ntrue or false, true or false with reasoning, theory, sums, measurement & characteristics identification.',
  `questionText` text,
  `questionImage` varchar(255) DEFAULT NULL,
  `structureLevelTwoId` bigint(20) DEFAULT NULL,
  `structureLevelThreeId` bigint(20) DEFAULT NULL,
  `structureLeafNodeId` bigint(20) DEFAULT NULL,
  `answerText` text,
  `answerImage` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Refquestion_paper785` (`questionPaperId`),
  KEY `Refstructure_level_two1176` (`structureLevelTwoId`),
  KEY `Refstructure_level_three1177` (`structureLevelThreeId`),
  KEY `Refstructure_leaf_node1178` (`structureLeafNodeId`),
  KEY `Refusers1382` (`lastUpdatedBy`),
  KEY `Refcoursetopic453_idx` (`courseTopicId`),
  CONSTRAINT `Refcoursetopic453` FOREIGN KEY (`courseTopicId`) REFERENCES `course_topics` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refquestion_paper785` FOREIGN KEY (`questionPaperId`) REFERENCES `question_paper` (`id`),
  CONSTRAINT `Refstructure_leaf_node1178` FOREIGN KEY (`structureLeafNodeId`) REFERENCES `structure_leaf_node` (`id`),
  CONSTRAINT `Refstructure_level_three1177` FOREIGN KEY (`structureLevelThreeId`) REFERENCES `structure_level_three` (`id`),
  CONSTRAINT `Refstructure_level_two1176` FOREIGN KEY (`structureLevelTwoId`) REFERENCES `structure_level_two` (`id`),
  CONSTRAINT `Refusers1382` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE  IF EXISTS  `que_paper_details_break` ;
CREATE TABLE `que_paper_details_break` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `questionPaperDetailId` bigint(20) DEFAULT NULL,
  `questionSequence` int(11) DEFAULT NULL,
  `questionSequenceText` varchar(255) DEFAULT NULL,
  `questionSequenceImage` varchar(255) DEFAULT NULL,
  `questionSequenceOne` int(11) DEFAULT NULL,
  `questionSequenceTextOne` varchar(255) DEFAULT NULL,
  `questionSequenceImageOne` varchar(255) DEFAULT NULL,
  `isCorrectAnswer` bit(1) DEFAULT b'0',
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Refquestion_paper_details1179` (`questionPaperDetailId`),
  KEY `Refusers1376` (`lastUpdatedBy`),
  CONSTRAINT `Refquestion_paper_details1179` FOREIGN KEY (`questionPaperDetailId`) REFERENCES `question_paper_details` (`id`),
  CONSTRAINT `Refusers1376` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE  IF EXISTS  `question_bank_questions` ;
CREATE TABLE `question_bank_questions` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `questionDescription` varchar(255) DEFAULT NULL,
  `complexity` varchar(45) DEFAULT NULL,
  `questionNo` int(11) DEFAULT NULL,
  `questionType` varchar(10) DEFAULT NULL,
  `questionCourseTopicId` bigint(20) DEFAULT NULL,
  `questionText` varchar(255) DEFAULT NULL,
  `questionImage` varchar(255) DEFAULT NULL,
  `answerText` text,
  `answerImage` varchar(255) DEFAULT NULL,
  `approverId` bigint(20) DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Refusers1380` (`lastUpdatedBy`),
  KEY `Refusers1702` (`approverId`),
  KEY `Refcourse_topics2032` (`questionCourseTopicId`),
  CONSTRAINT `Refcourse_topics2032` FOREIGN KEY (`questionCourseTopicId`) REFERENCES `course_topics` (`id`),
  CONSTRAINT `Refusers1380` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
  CONSTRAINT `Refusers1702` FOREIGN KEY (`approverId`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE  IF EXISTS `question_bank_break_up`  ;
CREATE TABLE `question_bank_break_up` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `questionBankId` bigint(20) DEFAULT NULL,
  `questionSequence` int(11) DEFAULT NULL,
  `questionSequenceText` varchar(255) DEFAULT NULL,
  `questionSequenceImage` varchar(255) DEFAULT NULL,
  `questionSequenceOne` int(11) DEFAULT NULL,
  `questionSequenceTextOne` varchar(255) DEFAULT NULL,
  `questionSequenceImageOne` varchar(255) DEFAULT NULL,
  `isCorrectAnswer` bit(1) DEFAULT b'0',
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Refquestion_bank_questions1175` (`questionBankId`),
  KEY `Refusers1379` (`lastUpdatedBy`),
  CONSTRAINT `Refquestion_bank_questions1175` FOREIGN KEY (`questionBankId`) REFERENCES `question_bank_questions` (`id`),
  CONSTRAINT `Refusers1379` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
set foreign_key_checks=1;
