drop view if exists evaluation_group_specific;
create view evaluation_group_specific as
    select 
        batches.programId,
        program_batch_students.programBatchId,
        evaluation_group.id,
        examination_result.admissionId,
        users.printName,
        evaluation_group.evaluationGroupCode,
        sum(eval_seq_detail.maxMarks) as markObtainedFrom,
        sum(examination_result.finalMarks) as markObtained,
        avg(examination_result.gradePoints) as gradePoint 
    from
        examination_result
            left join
        program_batch_students ON examination_result.admissionId = program_batch_students.admissionId
            left join
        eval_seq_detail ON examination_result.evaluationDetailSequenceId = eval_seq_detail.id
            left join
        group_schedule_batch ON eval_seq_detail.id = group_schedule_batch.evalSequenceDetailId
            left join
        evaluation_group ON group_schedule_batch.evaluationGroupId = evaluation_group.id
            left join
        admission ON examination_result.admissionId = admission.id
            left join
        students ON admission.studentId = students.userId
            left join
        users ON students.userId = users.id
            left join
        batches ON program_batch_students.programBatchId = batches.id
            left join
        programs ON batches.programId = programs.id
    group by group_schedule_batch.evaluationGroupId , examination_result.admissionId;