/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.resolver.spring;

import com.googlecode.flyway.core.api.FlywayException;
import com.googlecode.flyway.core.api.migration.spring.SpringJdbcMigration;
import com.googlecode.flyway.core.resolver.MigrationExecutor;
import java.sql.Connection;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.SingleConnectionDataSource;

public class SpringJdbcMigrationExecutor
implements MigrationExecutor {
    private final SpringJdbcMigration springJdbcMigration;

    public SpringJdbcMigrationExecutor(SpringJdbcMigration springJdbcMigration) {
        this.springJdbcMigration = springJdbcMigration;
    }

    public void execute(Connection connection) {
        try {
            this.springJdbcMigration.migrate(new JdbcTemplate(new SingleConnectionDataSource(connection, true)));
        }
        catch (Exception e) {
            throw new FlywayException("Migration failed !", e);
        }
    }
}

