/*
 * Decompiled with CFR 0.152.
 */
package com.thetransactioncompany.cors;

import com.thetransactioncompany.cors.CORSConfiguration;
import com.thetransactioncompany.cors.CORSOriginDeniedException;
import com.thetransactioncompany.cors.CORSRequestType;
import com.thetransactioncompany.cors.HTTPMethod;
import com.thetransactioncompany.cors.HeaderFieldName;
import com.thetransactioncompany.cors.HeaderUtils;
import com.thetransactioncompany.cors.InvalidCORSRequestException;
import com.thetransactioncompany.cors.Origin;
import com.thetransactioncompany.cors.UnsupportedHTTPHeaderException;
import com.thetransactioncompany.cors.UnsupportedHTTPMethodException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CORSRequestHandler {
    private final CORSConfiguration config;
    private final String supportedMethods;
    private final String supportedHeaders;
    private final String exposedHeaders;

    public CORSRequestHandler(CORSConfiguration config) {
        this.config = config;
        this.supportedMethods = HeaderUtils.serialize(config.supportedMethods, ", ");
        this.supportedHeaders = !config.supportAnyHeader ? HeaderUtils.serialize(config.supportedHeaders, ", ") : null;
        this.exposedHeaders = HeaderUtils.serialize(config.exposedHeaders, ", ");
    }

    public void handleActualRequest(HttpServletRequest request, HttpServletResponse response) throws InvalidCORSRequestException, CORSOriginDeniedException, UnsupportedHTTPMethodException {
        HTTPMethod method;
        if (CORSRequestType.detect(request) != CORSRequestType.ACTUAL) {
            throw new InvalidCORSRequestException("Invalid simple/actual CORS request");
        }
        Origin requestOrigin = new Origin(request.getHeader("Origin"));
        if (!this.config.isAllowedOrigin(requestOrigin)) {
            throw new CORSOriginDeniedException("CORS origin denied", requestOrigin);
        }
        try {
            method = HTTPMethod.valueOf(request.getMethod());
        }
        catch (Exception e) {
            throw new UnsupportedHTTPMethodException("Unsupported HTTP method: " + request.getMethod());
        }
        if (!this.config.isSupportedMethod(method)) {
            throw new UnsupportedHTTPMethodException("Unsupported HTTP method", method);
        }
        if (this.config.supportsCredentials) {
            response.addHeader("Access-Control-Allow-Credentials", "true");
            response.addHeader("Access-Control-Allow-Origin", requestOrigin.toString());
            response.addHeader("Vary", "Origin");
        } else if (this.config.allowAnyOrigin) {
            response.addHeader("Access-Control-Allow-Origin", "*");
        } else {
            response.addHeader("Access-Control-Allow-Origin", requestOrigin.toString());
            response.addHeader("Vary", "Origin");
        }
        if (!this.exposedHeaders.isEmpty()) {
            response.addHeader("Access-Control-Expose-Headers", this.exposedHeaders);
        }
    }

    public void handlePreflightRequest(HttpServletRequest request, HttpServletResponse response) throws InvalidCORSRequestException, CORSOriginDeniedException, UnsupportedHTTPMethodException, UnsupportedHTTPHeaderException {
        HTTPMethod requestedMethod;
        if (CORSRequestType.detect(request) != CORSRequestType.PREFLIGHT) {
            throw new InvalidCORSRequestException("Invalid preflight CORS request");
        }
        Origin requestOrigin = new Origin(request.getHeader("Origin"));
        if (!this.config.isAllowedOrigin(requestOrigin)) {
            throw new CORSOriginDeniedException("CORS origin denied", requestOrigin);
        }
        String requestMethodHeader = request.getHeader("Access-Control-Request-Method");
        if (requestMethodHeader == null) {
            throw new InvalidCORSRequestException("Invalid preflight CORS request: Missing Access-Control-Request-Method header");
        }
        try {
            requestedMethod = HTTPMethod.valueOf(requestMethodHeader.toUpperCase());
        }
        catch (Exception e) {
            throw new UnsupportedHTTPMethodException("Unsupported HTTP method: " + requestMethodHeader);
        }
        String rawRequestHeadersString = request.getHeader("Access-Control-Request-Headers");
        String[] requestHeaderValues = HeaderUtils.parseMultipleHeaderValues(rawRequestHeadersString);
        HeaderFieldName[] requestHeaders = new HeaderFieldName[requestHeaderValues.length];
        for (int i = 0; i < requestHeaders.length; ++i) {
            try {
                requestHeaders[i] = new HeaderFieldName(requestHeaderValues[i]);
                continue;
            }
            catch (IllegalArgumentException e) {
                throw new InvalidCORSRequestException("Invalid preflight CORS request: Bad request header value");
            }
        }
        if (!this.config.isSupportedMethod(requestedMethod)) {
            throw new UnsupportedHTTPMethodException("Unsupported HTTP method", requestedMethod);
        }
        if (!this.config.supportAnyHeader) {
            for (HeaderFieldName requestHeader : requestHeaders) {
                if (this.config.supportedHeaders.contains(requestHeader)) continue;
                throw new UnsupportedHTTPHeaderException("Unsupported HTTP request header", requestHeader);
            }
        }
        if (this.config.supportsCredentials) {
            response.addHeader("Access-Control-Allow-Origin", requestOrigin.toString());
            response.addHeader("Access-Control-Allow-Credentials", "true");
            response.addHeader("Vary", "Origin");
        } else if (this.config.allowAnyOrigin) {
            response.addHeader("Access-Control-Allow-Origin", "*");
        } else {
            response.addHeader("Access-Control-Allow-Origin", requestOrigin.toString());
            response.addHeader("Vary", "Origin");
        }
        if (this.config.maxAge > 0) {
            response.addHeader("Access-Control-Max-Age", Integer.toString(this.config.maxAge));
        }
        response.addHeader("Access-Control-Allow-Methods", this.supportedMethods);
        if (this.config.supportAnyHeader && rawRequestHeadersString != null) {
            response.addHeader("Access-Control-Allow-Headers", rawRequestHeadersString);
        } else if (this.supportedHeaders != null && !this.supportedHeaders.isEmpty()) {
            response.addHeader("Access-Control-Allow-Headers", this.supportedHeaders);
        }
    }
}

