/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.CriteriaBuilderConfigurer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class XsdSyncApp {
    private static final String CODEBASE_DIRECTORY = "xsdFiles";
    private static final Path DESTINATION_DIRECTORY = Paths.get(System.getenv("ACADEMIA_PROPERTIES"), new String[0]).resolve("xsdFiles");
    private static final Logger PROGRAMANDCOURSEMODULELOGGER = LogManager.getLogger("ProgramAndCourseModuleLogger");

    public static void main(String[] args) throws IOException {
        File outputDir = DESTINATION_DIRECTORY.toFile();
        System.out.println("DESTINATION_DIRECTORY for XSDs: " + DESTINATION_DIRECTORY);
        if (!outputDir.exists()) {
            Files.createDirectories(DESTINATION_DIRECTORY, new FileAttribute[0]);
            System.out.println("Created destination directory: " + DESTINATION_DIRECTORY);
        }
        Set<String> existingFiles = Files.walk(DESTINATION_DIRECTORY, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::getFileName).map(Path::toString).collect(Collectors.toSet());
        Path sourceDirectory = XsdSyncApp.getSourceDirPath(CODEBASE_DIRECTORY);
        if (sourceDirectory != null) {
            XsdSyncApp.processFiles(sourceDirectory, existingFiles);
        } else {
            System.out.println("Source directory not found.");
        }
    }

    private static Path getSourceDirPath(String sourceDir) throws IOException {
        ClassLoader classLoader = XsdSyncApp.class.getClassLoader();
        URL url = classLoader.getResource(sourceDir);
        if (url == null) {
            return null;
        }
        try {
            URI uri = url.toURI();
            if ("jar".equals(uri.getScheme())) {
                return XsdSyncApp.getJarPath(uri, sourceDir);
            }
            return Paths.get(uri);
        }
        catch (URISyntaxException e) {
            PROGRAMANDCOURSEMODULELOGGER.error(e);
            return null;
        }
    }

    private static Path getJarPath(URI jarUri, String sourceDir) throws IOException {
        FileSystem fs;
        if (!"jar".equals(jarUri.getScheme()) && !"file".equals(jarUri.getScheme())) {
            throw new IllegalArgumentException("URI scheme must be 'jar' or 'file'");
        }
        String jarUriStr = jarUri.toString();
        if (jarUriStr.startsWith("jar:file:")) {
            jarUriStr = jarUriStr.substring(4);
        }
        URI fileSystemUri = URI.create("jar:" + jarUriStr);
        try {
            fs = FileSystems.getFileSystem(fileSystemUri);
        }
        catch (FileSystemNotFoundException e) {
            fs = FileSystems.newFileSystem(fileSystemUri, Collections.emptyMap());
        }
        return fs.getPath("/" + sourceDir, new String[0]);
    }

    private static void processFiles(Path sourceDirectory, Set<String> existingFiles) {
        try {
            Files.walk(sourceDirectory, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(file -> file.toString().endsWith(".xsd")).filter(file -> !existingFiles.contains(file.getFileName().toString())).forEach(file -> {
                try (InputStream inputStream = Files.newInputStream(file, new OpenOption[0]);){
                    Path destinationFile = DESTINATION_DIRECTORY.resolve(file.getFileName().toString());
                    XsdSyncApp.copyFile(inputStream, destinationFile);
                    System.out.println("Copied: " + file.getFileName());
                }
                catch (IOException e) {
                    System.err.println("Failed to copy: " + file.getFileName() + " due to " + e.getMessage());
                }
            });
        }
        catch (IOException e) {
            PROGRAMANDCOURSEMODULELOGGER.error(e);
        }
    }

    private static void copyFile(InputStream inputStream, Path destinationFile) throws IOException {
        try (OutputStream outputStream = Files.newOutputStream(destinationFile, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            int bytesRead;
            byte[] buffer = new byte[8192];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
        }
    }
}

