/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.SystemModuleConfigurer;

import in.serosoft.CriteriaBuilderConfigurer.ConfigUtil;
import in.serosoft.CriteriaBuilderConfigurer.DBProperties;
import in.serosoft.sm.entity.Privilege;
import in.serosoft.sm.entity.SystemModule;
import in.serosoft.sm.helper.SystemModuleDtoTOEntityConverter;
import in.serosoft.sm.model.SystemModuleDTO;
import in.serosoft.sm.model.SystemModulesListDTO;
import in.serosoft.sm.service.PrivilegeService;
import in.serosoft.sm.service.SystemModuleService;
import in.serosoft.sm.xmlparser.XmlReader;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class SysModuleConfigurationApp {
    public static void main(String[] args) throws URISyntaxException {
        ApplicationContext appContext = ConfigUtil.getApplicationContext();
        DBProperties dbProperties = appContext.getBean(DBProperties.class);
        PrivilegeService privilegeService = (PrivilegeService)appContext.getBean("privilegeService");
        SystemModuleService systemModuleService = (SystemModuleService)appContext.getBean("systemModuleServie");
        Map<String, Privilege> privilegeMap = privilegeService.findAll();
        Path fileName = Paths.get(SysModuleConfigurationApp.class.getClassLoader().getResource("XMLParser/systemModule/System_Module.xml").toURI());
        SystemModulesListDTO sModuleListDTO = XmlReader.readXmlFile(fileName);
        if (sModuleListDTO != null) {
            System.out.println("Total size of System_Module: " + sModuleListDTO.getModule().size());
        } else {
            System.out.println("System_Module is null. Please check codebase");
            System.exit(1);
        }
        List<SystemModuleDTO> systemmoduleList = sModuleListDTO.getModule();
        SystemModuleDtoTOEntityConverter systemModuleDtoTOEntity = new SystemModuleDtoTOEntityConverter();
        for (SystemModuleDTO systemModuleDTO : systemmoduleList) {
            SystemModule systemModule = systemModuleDtoTOEntity.convertsystemModuleDtotoEntity(systemModuleDTO, privilegeMap);
            systemModule.setDisplayCode("displayCode");
            try {
                systemModuleService.create(systemModule);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ((ConfigurableApplicationContext)appContext).close();
    }
}

