/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.cb.enumeration;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonValue;

public enum Language {
    RUSSIAN("RU", "ru"),
    SPANISH("ES", "es"),
    ENGLISH("EN", "en"),
    DEFAULT("DEFAULT", "default"),
    VIETNAMESE("VI", "vi"),
    AFRIKAANS("AFR", "afr"),
    FRENCH("FR", "fr");

    private String codeName;
    private String codeValue;
    public static List<Language> enums;

    private Language(String codeName, String codeValue) {
        this.codeName = codeName;
        this.codeValue = codeValue;
    }

    public String getCodeName() {
        return this.codeName;
    }

    public void setCodeName(String codeName) {
        this.codeName = codeName;
    }

    public String getCodeValue() {
        return this.codeValue;
    }

    public void setCodeValue(String codeValue) {
        this.codeValue = codeValue;
    }

    public String toString() {
        return super.toString();
    }

    @JsonValue
    public String toValue() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.codeName);
        return builder.toString();
    }

    @JsonCreator
    public static Language create(String value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        for (Language v : Language.values()) {
            if (!value.equals(v.codeName)) continue;
            return v;
        }
        throw new IllegalArgumentException();
    }

    public String toCodeName() {
        return this.codeName;
    }

    public static Language fromCodeName(String codeName) {
        switch (codeName) {
            case "RUSSIAN": {
                return RUSSIAN;
            }
            case "SPANISH": {
                return SPANISH;
            }
            case "ENGLISH": {
                return ENGLISH;
            }
            case "DEFAULT": {
                return DEFAULT;
            }
        }
        return null;
    }

    public static List<Language> getyesNoEnums() {
        return enums;
    }

    static {
        enums = new ArrayList<Language>();
        enums.add(RUSSIAN);
        enums.add(SPANISH);
        enums.add(ENGLISH);
        enums.add(DEFAULT);
    }
}

