/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.cb.helper;

import in.serosoft.cb.dao.SearchTableColumnDAO;
import in.serosoft.cb.dao.SearchTableRelationDAO;
import in.serosoft.cb.entity.SavedSearch;
import in.serosoft.cb.entity.SavedSearchCriteria;
import in.serosoft.cb.entity.SearchConfigTable;
import in.serosoft.cb.entity.SearchResultView;
import in.serosoft.cb.entity.SearchResultViewColumn;
import in.serosoft.cb.entity.SearchSQLGroup;
import in.serosoft.cb.entity.SearchTable;
import in.serosoft.cb.entity.SearchTableRelation;
import in.serosoft.cb.helper.SearchResultViewEntityToDTOConvertor;
import in.serosoft.cb.model.SavedSearchCriteriaDTO;
import in.serosoft.cb.model.SavedSearchDTO;
import in.serosoft.cb.model.SearchResultViewDTO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SavedSearchEntityToDTOConvertor {
    SearchTableRelationDAO searchTableRelationDAO;
    SearchTableColumnDAO searchTableColumnDAO;
    Map<String, SearchTable> searchTablesMap;
    List<SearchTableRelation> searchTableRelations;
    Map<String, SearchConfigTable> searchConfigTablesMap = new HashMap<String, SearchConfigTable>();
    Map<String, SearchResultViewColumn> searchResultViewColumnMap = new HashMap<String, SearchResultViewColumn>();
    Map<String, SearchSQLGroup> searchSQLGroupMap = new HashMap<String, SearchSQLGroup>();
    SearchConfigTable rootSearchConfigTable = new SearchConfigTable();
    SearchResultView defaultSearchResultView = new SearchResultView();

    public SavedSearchEntityToDTOConvertor(Map<String, SearchTable> searchTablesMap, List<SearchTableRelation> searchTableRelations, SearchTableRelationDAO searchTableRelationDAO, SearchTableColumnDAO searchTableColumnDAO) {
        this.searchTablesMap = searchTablesMap;
        this.searchTableRelations = searchTableRelations;
        this.searchTableRelationDAO = searchTableRelationDAO;
        this.searchTableColumnDAO = searchTableColumnDAO;
    }

    public SavedSearchEntityToDTOConvertor() {
    }

    public SavedSearchDTO convert(SavedSearch savedSearch) {
        SavedSearchDTO savedSearchDTO = new SavedSearchDTO();
        savedSearchDTO.setConfigCode(savedSearch.getSearchConfiguration().getConfigCode());
        savedSearchDTO.setUserId(savedSearch.getUserId() != null ? savedSearch.getUserId() : 1L);
        savedSearchDTO.setId(savedSearch.getId());
        savedSearchDTO.setSearchName(savedSearch.getSearchName());
        savedSearchDTO.setWhetherPredefined(savedSearch.getWhetherPredefined());
        savedSearchDTO.setModuleName(savedSearch.getModuleName());
        savedSearchDTO.setViewCode(savedSearch.getSearchResultView().getViewCode());
        Set<SavedSearchCriteria> savedSearchCriterias = savedSearch.getSavedSearchCriterias();
        for (SavedSearchCriteria savedSearchCriteria : savedSearchCriterias) {
            SavedSearchCriteriaDTO savedSearchCriteriaDTO = this.covertSavedSearchCriteriaToSavedSearchCriteriaDTO(savedSearchCriteria, new SavedSearchCriteriaDTO());
            savedSearchDTO.setSavedSearchCriteriaDTO(savedSearchCriteriaDTO);
        }
        SearchResultViewDTO searchResultViewDTO = new SearchResultViewEntityToDTOConvertor().convert(savedSearch.getSearchResultView());
        savedSearchDTO.setSearchResultView(searchResultViewDTO);
        return savedSearchDTO;
    }

    private SavedSearchCriteriaDTO covertSavedSearchCriteriaToSavedSearchCriteriaDTO(SavedSearchCriteria savedSearchCriteria, SavedSearchCriteriaDTO savedSearchCriteriaDTO) {
        savedSearchCriteriaDTO.setCriteriaType(savedSearchCriteria.getCriteriaType());
        savedSearchCriteriaDTO.setLogicalOperator(savedSearchCriteria.getLogicalOperator());
        ArrayList<SavedSearchCriteriaDTO> childSavedSearchCriteriaDTOs = new ArrayList<SavedSearchCriteriaDTO>();
        Set<SavedSearchCriteria> childSavedSearchCriterias = savedSearchCriteria.getSavedSearchCriterias();
        for (SavedSearchCriteria childSavedSearchCriteria : childSavedSearchCriterias) {
            SavedSearchCriteriaDTO childSavedSearchCriteriaDTO = null;
            childSavedSearchCriteriaDTO = childSavedSearchCriteria.getCriteriaType().equals("SQL") ? this.covertChildSavedSearchCriteriaToSavedSearchCriteriaDTO(childSavedSearchCriteria) : this.covertSavedSearchCriteriaToSavedSearchCriteriaDTO(childSavedSearchCriteria, new SavedSearchCriteriaDTO());
            childSavedSearchCriteriaDTOs.add(childSavedSearchCriteriaDTO);
        }
        savedSearchCriteriaDTO.setChildSavedSearchCriteriaDTOs(childSavedSearchCriteriaDTOs);
        return savedSearchCriteriaDTO;
    }

    private SavedSearchCriteriaDTO covertChildSavedSearchCriteriaToSavedSearchCriteriaDTO(SavedSearchCriteria savedSearchCriteria) {
        SavedSearchCriteriaDTO savedSearchCriteriaDTO = new SavedSearchCriteriaDTO();
        savedSearchCriteriaDTO.setColumnName(savedSearchCriteria.getSearchTableColumn().getColumnName());
        savedSearchCriteriaDTO.setTableName(savedSearchCriteria.getSearchConfigTable().getAlias() + "#" + savedSearchCriteria.getSearchConfigTable().getSearchTableBySearchTableId().getDbTableName());
        savedSearchCriteriaDTO.setCriteriaType(savedSearchCriteria.getCriteriaType());
        savedSearchCriteriaDTO.setLogicalOperator(savedSearchCriteria.getLogicalOperator());
        savedSearchCriteriaDTO.setOperatorCode(savedSearchCriteria.getSearchCriteriaOperator().getDisplayCode());
        savedSearchCriteriaDTO.setOperandValue(savedSearchCriteria.getOperandValue());
        return savedSearchCriteriaDTO;
    }
}

