/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.translation.utility;

import in.serosoft.translation.utility.JsLabelConfigurationUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Scanner;

public class JSLabelUtility {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) throws IOException {
        Scanner scanner = new Scanner(System.in);
        int k = scanner.nextInt();
        try {
            switch (k) {
                case 1: {
                    JSLabelUtility.partialMatch();
                    return;
                }
                case 2: {
                    JSLabelUtility.exactMatch();
                    return;
                }
            }
            return;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return;
        }
        finally {
            scanner.close();
        }
    }

    private static void exactMatch() throws IOException {
        File folder = new File("/home/mohit/rsBundleCompress/src/");
        for (File fileEntry : folder.listFiles()) {
            if (fileEntry.isDirectory()) continue;
            File yourFile = new File("/home/mohit/rsBundleCompress/generated/" + fileEntry.getName());
            if (!yourFile.exists()) {
                yourFile.createNewFile();
            }
            JSLabelUtility.replaceLablesExactMatch("/home/mohit/rsBundleCompress/src/" + fileEntry.getName(), "/home/mohit/rsBundleCompress/generated/" + fileEntry.getName());
        }
    }

    private static void partialMatch() throws IOException {
        File folder = new File("/home/mohit/rsBundleCompress/src/");
        for (File fileEntry : folder.listFiles()) {
            if (fileEntry.isDirectory()) continue;
            File yourFile = new File("/home/mohit/rsBundleCompress/generated/" + fileEntry.getName());
            if (!yourFile.exists()) {
                yourFile.createNewFile();
            }
            JSLabelUtility.replaceLables("/home/mohit/rsBundleCompress/src/" + fileEntry.getName(), "/home/mohit/rsBundleCompress/generated/" + fileEntry.getName());
        }
    }

    private static BufferedWriter getOutPutFileStream(String OUTPUT_FILE) throws IOException {
        File newFile = new File(OUTPUT_FILE);
        BufferedWriter output = new BufferedWriter(new FileWriter(newFile));
        return output;
    }

    private static DataInputStream getDataInputStream(String INPUT_FILE) throws FileNotFoundException {
        FileInputStream fstream = new FileInputStream(INPUT_FILE);
        DataInputStream in = new DataInputStream(fstream);
        return in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void replaceLables(String INPUT_FILE, String OUTPUT_FILE) throws IOException {
        try (BufferedWriter output = null;){
            output = JSLabelUtility.getOutPutFileStream(OUTPUT_FILE);
            StringBuilder strBuilder = null;
            DataInputStream in = JSLabelUtility.getDataInputStream(INPUT_FILE);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            String strLine = null;
            while ((strLine = br.readLine()) != null) {
                strBuilder = new StringBuilder();
                if (strLine.contains("=") || strLine.contains("//") || strLine.contains("}") || strLine.contains(";")) {
                    strBuilder.append(strLine);
                } else {
                    ArrayList<String> list = new ArrayList<String>(Arrays.asList(strLine.split(":")));
                    if (list.size() == 2) {
                        String str = (String)list.get(1);
                        String newString = JsLabelConfigurationUtil.changelLable(str);
                        strBuilder.append((String)list.get(0));
                        strBuilder.append(":");
                        strBuilder.append(newString);
                    } else {
                        strBuilder.append(strLine);
                    }
                }
                output.write(strBuilder.toString());
                output.newLine();
            }
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void replaceLablesExactMatch(String INPUT_FILE, String OUTPUT_FILE) throws IOException {
        try (BufferedWriter output = null;){
            output = JSLabelUtility.getOutPutFileStream(OUTPUT_FILE);
            StringBuilder strBuilder = null;
            DataInputStream in = JSLabelUtility.getDataInputStream(INPUT_FILE);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            String strLine = null;
            while ((strLine = br.readLine()) != null) {
                strBuilder = new StringBuilder();
                if (strLine.contains("=") || strLine.contains("//") || strLine.contains("}") || strLine.contains(";") || strLine.contains("/")) {
                    strBuilder.append(strLine);
                } else {
                    ArrayList<String> list = new ArrayList<String>(Arrays.asList(strLine.split(":")));
                    if (list.size() == 2) {
                        String str = (String)list.get(1);
                        if ((str = str.trim()).length() > 2) {
                            String newString;
                            String localStr;
                            if (str.startsWith("'") && str.contains(",") && str.lastIndexOf(",") - str.lastIndexOf("'") > 0) {
                                str = str.substring(0, str.lastIndexOf("'") + 1) + ",";
                            }
                            if (str.startsWith("\"") && str.contains(",") && str.lastIndexOf(",") - str.lastIndexOf("\"") > 0) {
                                str = str.substring(0, str.lastIndexOf("\"") + 1) + ",";
                            }
                            if (str.endsWith("',")) {
                                localStr = null;
                                localStr = str.substring(1, str.lastIndexOf("'"));
                                newString = JsLabelConfigurationUtil.changeLableExactMatch(localStr);
                                strBuilder.append((String)list.get(0));
                                strBuilder.append(":'");
                                strBuilder.append(newString + "',");
                            }
                            if (str.endsWith("\",")) {
                                localStr = null;
                                localStr = str.substring(1, str.lastIndexOf("\""));
                                newString = JsLabelConfigurationUtil.changeLableExactMatch(localStr);
                                strBuilder.append((String)list.get(0));
                                strBuilder.append(":\"");
                                strBuilder.append(newString + "\",");
                            }
                            if (!str.endsWith(",")) {
                                str = str.substring(1, str.length() - 1);
                                String newString2 = JsLabelConfigurationUtil.changeLableExactMatch(str);
                                strBuilder.append((String)list.get(0));
                                strBuilder.append(":'");
                                strBuilder.append(newString2 + "'");
                            }
                        } else {
                            strBuilder.append(strLine);
                        }
                    } else {
                        strBuilder.append(strLine);
                    }
                }
                output.write(strBuilder.toString());
                output.newLine();
            }
            in.close();
        }
    }
}

