/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.ehcache.internal.strategy;

import org.hibernate.cache.CacheException;
import org.hibernate.cache.ehcache.internal.regions.EhcacheNaturalIdRegion;
import org.hibernate.cache.ehcache.internal.strategy.AbstractEhcacheAccessStrategy;
import org.hibernate.cache.spi.NaturalIdRegion;
import org.hibernate.cache.spi.access.NaturalIdRegionAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.cfg.Settings;

public class NonStrictReadWriteEhcacheNaturalIdRegionAccessStrategy
extends AbstractEhcacheAccessStrategy<EhcacheNaturalIdRegion>
implements NaturalIdRegionAccessStrategy {
    public NonStrictReadWriteEhcacheNaturalIdRegionAccessStrategy(EhcacheNaturalIdRegion region, Settings settings) {
        super(region, settings);
    }

    @Override
    public NaturalIdRegion getRegion() {
        return (NaturalIdRegion)((Object)this.region);
    }

    @Override
    public Object get(Object key, long txTimestamp) throws CacheException {
        return ((EhcacheNaturalIdRegion)this.region).get(key);
    }

    @Override
    public boolean putFromLoad(Object key, Object value, long txTimestamp, Object version, boolean minimalPutOverride) throws CacheException {
        if (minimalPutOverride && ((EhcacheNaturalIdRegion)this.region).contains(key)) {
            return false;
        }
        ((EhcacheNaturalIdRegion)this.region).put(key, value);
        return true;
    }

    @Override
    public SoftLock lockItem(Object key, Object version) throws CacheException {
        return null;
    }

    @Override
    public void unlockItem(Object key, SoftLock lock) throws CacheException {
        ((EhcacheNaturalIdRegion)this.region).remove(key);
    }

    @Override
    public boolean insert(Object key, Object value) throws CacheException {
        return false;
    }

    @Override
    public boolean afterInsert(Object key, Object value) throws CacheException {
        return false;
    }

    @Override
    public boolean update(Object key, Object value) throws CacheException {
        this.remove(key);
        return false;
    }

    @Override
    public boolean afterUpdate(Object key, Object value, SoftLock lock) throws CacheException {
        this.unlockItem(key, lock);
        return false;
    }

    @Override
    public void remove(Object key) throws CacheException {
        ((EhcacheNaturalIdRegion)this.region).remove(key);
    }
}

