/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CollectionTable;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.ElementCollection;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MapKey;
import javax.persistence.MapKeyColumn;
import javax.persistence.MapKeyJoinColumn;
import javax.persistence.MapKeyJoinColumns;
import javax.persistence.MappedSuperclass;
import javax.persistence.MapsId;
import javax.persistence.NamedNativeQuery;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.OrderColumn;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.PrimaryKeyJoinColumns;
import javax.persistence.SecondaryTable;
import javax.persistence.SecondaryTables;
import javax.persistence.SequenceGenerator;
import javax.persistence.SharedCacheMode;
import javax.persistence.SqlResultSetMapping;
import javax.persistence.SqlResultSetMappings;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.EntityMode;
import org.hibernate.FetchMode;
import org.hibernate.MappingException;
import org.hibernate.annotations.Any;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Check;
import org.hibernate.annotations.CollectionId;
import org.hibernate.annotations.Columns;
import org.hibernate.annotations.DiscriminatorFormula;
import org.hibernate.annotations.DiscriminatorOptions;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchProfile;
import org.hibernate.annotations.FetchProfiles;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.FilterDefs;
import org.hibernate.annotations.Filters;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.Formula;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.GenericGenerators;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.LazyToOne;
import org.hibernate.annotations.LazyToOneOption;
import org.hibernate.annotations.ManyToAny;
import org.hibernate.annotations.MapKeyType;
import org.hibernate.annotations.NamedNativeQueries;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.NaturalIdCache;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;
import org.hibernate.annotations.ParamDef;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Parent;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Sort;
import org.hibernate.annotations.Source;
import org.hibernate.annotations.Tables;
import org.hibernate.annotations.Tuplizer;
import org.hibernate.annotations.Tuplizers;
import org.hibernate.annotations.TypeDef;
import org.hibernate.annotations.TypeDefs;
import org.hibernate.annotations.Where;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XMethod;
import org.hibernate.annotations.common.reflection.XPackage;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cfg.AccessType;
import org.hibernate.cfg.AnnotatedClassType;
import org.hibernate.cfg.BinderHelper;
import org.hibernate.cfg.ColumnsBuilder;
import org.hibernate.cfg.CopyIdentifierComponentSecondPass;
import org.hibernate.cfg.CreateKeySecondPass;
import org.hibernate.cfg.Ejb3Column;
import org.hibernate.cfg.Ejb3DiscriminatorColumn;
import org.hibernate.cfg.Ejb3JoinColumn;
import org.hibernate.cfg.IndexColumn;
import org.hibernate.cfg.InheritanceState;
import org.hibernate.cfg.JoinedSubclassFkSecondPass;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.cfg.OneToOneSecondPass;
import org.hibernate.cfg.PropertyContainer;
import org.hibernate.cfg.PropertyData;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.cfg.PropertyHolderBuilder;
import org.hibernate.cfg.PropertyInferredData;
import org.hibernate.cfg.PropertyPreloadedData;
import org.hibernate.cfg.SecondaryTableSecondPass;
import org.hibernate.cfg.SettingsFactory;
import org.hibernate.cfg.ToOneBinder;
import org.hibernate.cfg.ToOneFkSecondPass;
import org.hibernate.cfg.UniqueConstraintHolder;
import org.hibernate.cfg.VerifyFetchProfileReferenceSecondPass;
import org.hibernate.cfg.WrappedInferredData;
import org.hibernate.cfg.annotations.CollectionBinder;
import org.hibernate.cfg.annotations.EntityBinder;
import org.hibernate.cfg.annotations.MapKeyColumnDelegator;
import org.hibernate.cfg.annotations.MapKeyJoinColumnDelegator;
import org.hibernate.cfg.annotations.Nullability;
import org.hibernate.cfg.annotations.PropertyBinder;
import org.hibernate.cfg.annotations.QueryBinder;
import org.hibernate.cfg.annotations.SimpleValueBinder;
import org.hibernate.cfg.annotations.TableBinder;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.id.MultipleHiLoPerTableGenerator;
import org.hibernate.id.enhanced.SequenceStyleGenerator;
import org.hibernate.id.enhanced.TableGenerator;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.IdGenerator;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.JoinedSubclass;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.SingleTableSubclass;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.UnionSubclass;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public final class AnnotationBinder {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, AnnotationBinder.class.getName());
    private static CacheConcurrencyStrategy DEFAULT_CACHE_CONCURRENCY_STRATEGY;

    private AnnotationBinder() {
    }

    public static void bindDefaults(Mappings mappings) {
        IdGenerator idGen;
        Map defaults = mappings.getReflectionManager().getDefaults();
        List anns = (List)defaults.get(SequenceGenerator.class);
        if (anns != null) {
            for (Annotation ann : anns) {
                idGen = AnnotationBinder.buildIdGenerator(ann, mappings);
                if (idGen == null) continue;
                mappings.addDefaultGenerator(idGen);
            }
        }
        if ((anns = (List)defaults.get(javax.persistence.TableGenerator.class)) != null) {
            for (Annotation ann : anns) {
                idGen = AnnotationBinder.buildIdGenerator(ann, mappings);
                if (idGen == null) continue;
                mappings.addDefaultGenerator(idGen);
            }
        }
        if ((anns = (List)defaults.get(NamedQuery.class)) != null) {
            for (Annotation ann : anns) {
                QueryBinder.bindQuery((NamedQuery)ann, mappings, true);
            }
        }
        if ((anns = (List)defaults.get(NamedNativeQuery.class)) != null) {
            for (Annotation ann : anns) {
                QueryBinder.bindNativeQuery((NamedNativeQuery)ann, mappings, true);
            }
        }
        if ((anns = (List)defaults.get(SqlResultSetMapping.class)) != null) {
            for (Annotation ann : anns) {
                QueryBinder.bindSqlResultsetMapping((SqlResultSetMapping)ann, mappings, true);
            }
        }
    }

    public static void bindPackage(String packageName, Mappings mappings) {
        IdGenerator idGen;
        Annotation ann;
        XPackage pckg;
        try {
            pckg = mappings.getReflectionManager().packageForName(packageName);
        }
        catch (ClassNotFoundException cnf) {
            LOG.packageNotFound(packageName);
            return;
        }
        if (pckg.isAnnotationPresent(SequenceGenerator.class)) {
            ann = pckg.getAnnotation(SequenceGenerator.class);
            idGen = AnnotationBinder.buildIdGenerator(ann, mappings);
            mappings.addGenerator(idGen);
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Add sequence generator with name: {0}", (Object)idGen.getName());
            }
        }
        if (pckg.isAnnotationPresent(javax.persistence.TableGenerator.class)) {
            ann = pckg.getAnnotation(javax.persistence.TableGenerator.class);
            idGen = AnnotationBinder.buildIdGenerator(ann, mappings);
            mappings.addGenerator(idGen);
        }
        AnnotationBinder.bindGenericGenerators(pckg, mappings);
        AnnotationBinder.bindQueries(pckg, mappings);
        AnnotationBinder.bindFilterDefs(pckg, mappings);
        AnnotationBinder.bindTypeDefs(pckg, mappings);
        AnnotationBinder.bindFetchProfiles(pckg, mappings);
        BinderHelper.bindAnyMetaDefs(pckg, mappings);
    }

    private static void bindGenericGenerators(XAnnotatedElement annotatedElement, Mappings mappings) {
        GenericGenerator defAnn = annotatedElement.getAnnotation(GenericGenerator.class);
        GenericGenerators defsAnn = annotatedElement.getAnnotation(GenericGenerators.class);
        if (defAnn != null) {
            AnnotationBinder.bindGenericGenerator(defAnn, mappings);
        }
        if (defsAnn != null) {
            for (GenericGenerator def : defsAnn.value()) {
                AnnotationBinder.bindGenericGenerator(def, mappings);
            }
        }
    }

    private static void bindGenericGenerator(GenericGenerator def, Mappings mappings) {
        IdGenerator idGen = AnnotationBinder.buildIdGenerator(def, mappings);
        mappings.addGenerator(idGen);
    }

    private static void bindQueries(XAnnotatedElement annotatedElement, Mappings mappings) {
        Annotation ann = annotatedElement.getAnnotation(SqlResultSetMapping.class);
        QueryBinder.bindSqlResultsetMapping((SqlResultSetMapping)ann, mappings, false);
        ann = annotatedElement.getAnnotation(SqlResultSetMappings.class);
        if (ann != null) {
            for (SqlResultSetMapping current : ann.value()) {
                QueryBinder.bindSqlResultsetMapping(current, mappings, false);
            }
        }
        ann = annotatedElement.getAnnotation(NamedQuery.class);
        QueryBinder.bindQuery((NamedQuery)ann, mappings, false);
        ann = annotatedElement.getAnnotation(org.hibernate.annotations.NamedQuery.class);
        QueryBinder.bindQuery((org.hibernate.annotations.NamedQuery)ann, mappings);
        ann = annotatedElement.getAnnotation(NamedQueries.class);
        QueryBinder.bindQueries((NamedQueries)ann, mappings, false);
        ann = annotatedElement.getAnnotation(org.hibernate.annotations.NamedQueries.class);
        QueryBinder.bindQueries((org.hibernate.annotations.NamedQueries)ann, mappings);
        ann = annotatedElement.getAnnotation(NamedNativeQuery.class);
        QueryBinder.bindNativeQuery((NamedNativeQuery)ann, mappings, false);
        ann = annotatedElement.getAnnotation(org.hibernate.annotations.NamedNativeQuery.class);
        QueryBinder.bindNativeQuery((org.hibernate.annotations.NamedNativeQuery)ann, mappings);
        ann = annotatedElement.getAnnotation(javax.persistence.NamedNativeQueries.class);
        QueryBinder.bindNativeQueries((javax.persistence.NamedNativeQueries)ann, mappings, false);
        ann = annotatedElement.getAnnotation(NamedNativeQueries.class);
        QueryBinder.bindNativeQueries((NamedNativeQueries)ann, mappings);
    }

    private static IdGenerator buildIdGenerator(Annotation ann, Mappings mappings) {
        IdGenerator idGen = new IdGenerator();
        if (mappings.getSchemaName() != null) {
            idGen.addParam("schema", mappings.getSchemaName());
        }
        if (mappings.getCatalogName() != null) {
            idGen.addParam("catalog", mappings.getCatalogName());
        }
        boolean useNewGeneratorMappings = mappings.useNewGeneratorMappings();
        if (ann == null) {
            idGen = null;
        } else if (ann instanceof javax.persistence.TableGenerator) {
            javax.persistence.TableGenerator tabGen = (javax.persistence.TableGenerator)ann;
            idGen.setName(tabGen.name());
            if (useNewGeneratorMappings) {
                idGen.setIdentifierGeneratorStrategy(TableGenerator.class.getName());
                idGen.addParam("prefer_entity_table_as_segment_value", "true");
                if (!BinderHelper.isEmptyAnnotationValue(tabGen.catalog())) {
                    idGen.addParam("catalog", tabGen.catalog());
                }
                if (!BinderHelper.isEmptyAnnotationValue(tabGen.schema())) {
                    idGen.addParam("schema", tabGen.schema());
                }
                if (!BinderHelper.isEmptyAnnotationValue(tabGen.table())) {
                    idGen.addParam("table_name", tabGen.table());
                }
                if (!BinderHelper.isEmptyAnnotationValue(tabGen.pkColumnName())) {
                    idGen.addParam("segment_column_name", tabGen.pkColumnName());
                }
                if (!BinderHelper.isEmptyAnnotationValue(tabGen.pkColumnValue())) {
                    idGen.addParam("segment_value", tabGen.pkColumnValue());
                }
                if (!BinderHelper.isEmptyAnnotationValue(tabGen.valueColumnName())) {
                    idGen.addParam("value_column_name", tabGen.valueColumnName());
                }
                idGen.addParam("increment_size", String.valueOf(tabGen.allocationSize()));
                idGen.addParam("initial_value", String.valueOf(tabGen.initialValue() + 1));
                if (tabGen.uniqueConstraints() != null && tabGen.uniqueConstraints().length > 0) {
                    LOG.warn(tabGen.name());
                }
            } else {
                idGen.setIdentifierGeneratorStrategy(MultipleHiLoPerTableGenerator.class.getName());
                if (!BinderHelper.isEmptyAnnotationValue(tabGen.table())) {
                    idGen.addParam("table", tabGen.table());
                }
                if (!BinderHelper.isEmptyAnnotationValue(tabGen.catalog())) {
                    idGen.addParam("catalog", tabGen.catalog());
                }
                if (!BinderHelper.isEmptyAnnotationValue(tabGen.schema())) {
                    idGen.addParam("schema", tabGen.schema());
                }
                if (tabGen.uniqueConstraints() != null && tabGen.uniqueConstraints().length > 0) {
                    LOG.ignoringTableGeneratorConstraints(tabGen.name());
                }
                if (!BinderHelper.isEmptyAnnotationValue(tabGen.pkColumnName())) {
                    idGen.addParam("primary_key_column", tabGen.pkColumnName());
                }
                if (!BinderHelper.isEmptyAnnotationValue(tabGen.valueColumnName())) {
                    idGen.addParam("value_column", tabGen.valueColumnName());
                }
                if (!BinderHelper.isEmptyAnnotationValue(tabGen.pkColumnValue())) {
                    idGen.addParam("primary_key_value", tabGen.pkColumnValue());
                }
                idGen.addParam("max_lo", String.valueOf(tabGen.allocationSize() - 1));
            }
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Add table generator with name: {0}", (Object)idGen.getName());
            }
        } else if (ann instanceof SequenceGenerator) {
            SequenceGenerator seqGen = (SequenceGenerator)ann;
            idGen.setName(seqGen.name());
            if (useNewGeneratorMappings) {
                idGen.setIdentifierGeneratorStrategy(SequenceStyleGenerator.class.getName());
                if (!BinderHelper.isEmptyAnnotationValue(seqGen.catalog())) {
                    idGen.addParam("catalog", seqGen.catalog());
                }
                if (!BinderHelper.isEmptyAnnotationValue(seqGen.schema())) {
                    idGen.addParam("schema", seqGen.schema());
                }
                if (!BinderHelper.isEmptyAnnotationValue(seqGen.sequenceName())) {
                    idGen.addParam("sequence_name", seqGen.sequenceName());
                }
                idGen.addParam("increment_size", String.valueOf(seqGen.allocationSize()));
                idGen.addParam("initial_value", String.valueOf(seqGen.initialValue()));
            } else {
                idGen.setIdentifierGeneratorStrategy("seqhilo");
                if (!BinderHelper.isEmptyAnnotationValue(seqGen.sequenceName())) {
                    idGen.addParam("sequence", seqGen.sequenceName());
                }
                if (seqGen.initialValue() != 1) {
                    LOG.unsupportedInitialValue("hibernate.id.new_generator_mappings");
                }
                idGen.addParam("max_lo", String.valueOf(seqGen.allocationSize() - 1));
                if (LOG.isTraceEnabled()) {
                    LOG.tracev("Add sequence generator with name: {0}", (Object)idGen.getName());
                }
            }
        } else if (ann instanceof GenericGenerator) {
            Parameter[] params;
            GenericGenerator genGen = (GenericGenerator)ann;
            idGen.setName(genGen.name());
            idGen.setIdentifierGeneratorStrategy(genGen.strategy());
            for (Parameter parameter : params = genGen.parameters()) {
                idGen.addParam(parameter.name(), parameter.value());
            }
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Add generic generator with name: {0}", (Object)idGen.getName());
            }
        } else {
            throw new AssertionFailure("Unknown Generator annotation: " + ann);
        }
        return idGen;
    }

    public static void bindClass(XClass clazzToProcess, Map<XClass, InheritanceState> inheritanceStatePerClass, Mappings mappings) throws MappingException {
        if (clazzToProcess.isAnnotationPresent(Entity.class) && clazzToProcess.isAnnotationPresent(MappedSuperclass.class)) {
            throw new AnnotationException("An entity cannot be annotated with both @Entity and @MappedSuperclass: " + clazzToProcess.getName());
        }
        InheritanceState inheritanceState = inheritanceStatePerClass.get(clazzToProcess);
        AnnotatedClassType classType = mappings.getClassType(clazzToProcess);
        if (AnnotatedClassType.EMBEDDABLE_SUPERCLASS.equals((Object)classType)) {
            AnnotationBinder.bindQueries(clazzToProcess, mappings);
            AnnotationBinder.bindTypeDefs(clazzToProcess, mappings);
            AnnotationBinder.bindFilterDefs(clazzToProcess, mappings);
        }
        if (!AnnotationBinder.isEntityClassType(clazzToProcess, classType)) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Binding entity from annotated class: %s", (Object)clazzToProcess.getName());
        }
        PersistentClass superEntity = AnnotationBinder.getSuperEntity(clazzToProcess, inheritanceStatePerClass, mappings, inheritanceState);
        PersistentClass persistentClass = AnnotationBinder.makePersistentClass(inheritanceState, superEntity);
        Entity entityAnn = clazzToProcess.getAnnotation(Entity.class);
        org.hibernate.annotations.Entity hibEntityAnn = clazzToProcess.getAnnotation(org.hibernate.annotations.Entity.class);
        EntityBinder entityBinder = new EntityBinder(entityAnn, hibEntityAnn, clazzToProcess, persistentClass, mappings);
        entityBinder.setInheritanceState(inheritanceState);
        AnnotationBinder.bindQueries(clazzToProcess, mappings);
        AnnotationBinder.bindFilterDefs(clazzToProcess, mappings);
        AnnotationBinder.bindTypeDefs(clazzToProcess, mappings);
        AnnotationBinder.bindFetchProfiles(clazzToProcess, mappings);
        BinderHelper.bindAnyMetaDefs(clazzToProcess, mappings);
        String schema = "";
        String table = "";
        String catalog = "";
        ArrayList<UniqueConstraintHolder> uniqueConstraints = new ArrayList();
        if (clazzToProcess.isAnnotationPresent(Table.class)) {
            Table tabAnn = clazzToProcess.getAnnotation(Table.class);
            table = tabAnn.name();
            schema = tabAnn.schema();
            catalog = tabAnn.catalog();
            uniqueConstraints = TableBinder.buildUniqueConstraintHolders(tabAnn.uniqueConstraints());
        }
        Ejb3JoinColumn[] inheritanceJoinedColumns = AnnotationBinder.makeInheritanceJoinColumns(clazzToProcess, mappings, inheritanceState, superEntity);
        Ejb3DiscriminatorColumn discriminatorColumn = null;
        if (InheritanceType.SINGLE_TABLE.equals((Object)inheritanceState.getType())) {
            discriminatorColumn = AnnotationBinder.processDiscriminatorProperties(clazzToProcess, mappings, inheritanceState, entityBinder);
        }
        entityBinder.setProxy(clazzToProcess.getAnnotation(Proxy.class));
        entityBinder.setBatchSize(clazzToProcess.getAnnotation(BatchSize.class));
        entityBinder.setWhere(clazzToProcess.getAnnotation(Where.class));
        entityBinder.setCache(AnnotationBinder.determineCacheSettings(clazzToProcess, mappings));
        entityBinder.setNaturalIdCache(clazzToProcess, clazzToProcess.getAnnotation(NaturalIdCache.class));
        AnnotationBinder.bindFilters(clazzToProcess, entityBinder, mappings);
        entityBinder.bindEntity();
        if (inheritanceState.hasTable()) {
            Check checkAnn = clazzToProcess.getAnnotation(Check.class);
            String constraints = checkAnn == null ? null : checkAnn.constraints();
            entityBinder.bindTable(schema, catalog, table, uniqueConstraints, constraints, inheritanceState.hasDenormalizedTable() ? superEntity.getTable() : null);
        } else if (clazzToProcess.isAnnotationPresent(Table.class)) {
            LOG.invalidTableAnnotation(clazzToProcess.getName());
        }
        PropertyHolder propertyHolder = PropertyHolderBuilder.buildPropertyHolder(clazzToProcess, persistentClass, entityBinder, mappings, inheritanceStatePerClass);
        SecondaryTable secTabAnn = clazzToProcess.getAnnotation(SecondaryTable.class);
        SecondaryTables secTabsAnn = clazzToProcess.getAnnotation(SecondaryTables.class);
        entityBinder.firstLevelSecondaryTablesBinding(secTabAnn, secTabsAnn);
        OnDelete onDeleteAnn = clazzToProcess.getAnnotation(OnDelete.class);
        boolean onDeleteAppropriate = false;
        if (InheritanceType.JOINED.equals((Object)inheritanceState.getType()) && inheritanceState.hasParents()) {
            onDeleteAppropriate = true;
            JoinedSubclass jsc = (JoinedSubclass)persistentClass;
            DependantValue key = new DependantValue(mappings, jsc.getTable(), jsc.getIdentifier());
            jsc.setKey(key);
            ForeignKey fk = clazzToProcess.getAnnotation(ForeignKey.class);
            if (fk != null && !BinderHelper.isEmptyAnnotationValue(fk.name())) {
                key.setForeignKeyName(fk.name());
            }
            if (onDeleteAnn != null) {
                key.setCascadeDeleteEnabled(OnDeleteAction.CASCADE.equals((Object)onDeleteAnn.action()));
            } else {
                key.setCascadeDeleteEnabled(false);
            }
            JoinedSubclassFkSecondPass sp = new JoinedSubclassFkSecondPass(jsc, inheritanceJoinedColumns, key, mappings);
            mappings.addSecondPass(sp);
            mappings.addSecondPass(new CreateKeySecondPass(jsc));
        } else if (InheritanceType.SINGLE_TABLE.equals((Object)inheritanceState.getType())) {
            if (!(inheritanceState.hasParents() || !inheritanceState.hasSiblings() && discriminatorColumn.isImplicit())) {
                AnnotationBinder.bindDiscriminatorToPersistentClass((RootClass)persistentClass, discriminatorColumn, entityBinder.getSecondaryTables(), propertyHolder, mappings);
                entityBinder.bindDiscriminatorValue();
            }
        } else if (InheritanceType.TABLE_PER_CLASS.equals((Object)inheritanceState.getType())) {
            // empty if block
        }
        if (onDeleteAnn != null && !onDeleteAppropriate) {
            LOG.invalidOnDeleteAnnotation(propertyHolder.getEntityName());
        }
        HashMap<String, IdGenerator> classGenerators = AnnotationBinder.buildLocalGenerators(clazzToProcess, mappings);
        InheritanceState.ElementsToProcess elementsToProcess = inheritanceState.getElementsToProcess();
        inheritanceState.postProcess(persistentClass, entityBinder);
        boolean subclassAndSingleTableStrategy = inheritanceState.getType() == InheritanceType.SINGLE_TABLE && inheritanceState.hasParents();
        HashSet<String> idPropertiesIfIdClass = new HashSet<String>();
        boolean isIdClass = AnnotationBinder.mapAsIdClass(inheritanceStatePerClass, inheritanceState, persistentClass, entityBinder, propertyHolder, elementsToProcess, idPropertiesIfIdClass, mappings);
        if (!isIdClass) {
            entityBinder.setWrapIdsInEmbeddedComponents(elementsToProcess.getIdPropertyCount() > 1);
        }
        AnnotationBinder.processIdPropertiesIfNotAlready(inheritanceStatePerClass, mappings, persistentClass, entityBinder, propertyHolder, classGenerators, elementsToProcess, subclassAndSingleTableStrategy, idPropertiesIfIdClass);
        if (!inheritanceState.hasParents()) {
            RootClass rootClass = (RootClass)persistentClass;
            mappings.addSecondPass(new CreateKeySecondPass(rootClass));
        } else {
            superEntity.addSubclass((Subclass)persistentClass);
        }
        mappings.addClass(persistentClass);
        mappings.addSecondPass(new SecondaryTableSecondPass(entityBinder, propertyHolder, clazzToProcess));
        entityBinder.processComplementaryTableDefinitions(clazzToProcess.getAnnotation(org.hibernate.annotations.Table.class));
        entityBinder.processComplementaryTableDefinitions(clazzToProcess.getAnnotation(Tables.class));
    }

    private static Ejb3DiscriminatorColumn processDiscriminatorProperties(XClass clazzToProcess, Mappings mappings, InheritanceState inheritanceState, EntityBinder entityBinder) {
        Ejb3DiscriminatorColumn discriminatorColumn = null;
        DiscriminatorColumn discAnn = clazzToProcess.getAnnotation(DiscriminatorColumn.class);
        DiscriminatorType discriminatorType = discAnn != null ? discAnn.discriminatorType() : DiscriminatorType.STRING;
        DiscriminatorFormula discFormulaAnn = clazzToProcess.getAnnotation(DiscriminatorFormula.class);
        if (!inheritanceState.hasParents()) {
            discriminatorColumn = Ejb3DiscriminatorColumn.buildDiscriminatorColumn(discriminatorType, discAnn, discFormulaAnn, mappings);
        }
        if (discAnn != null && inheritanceState.hasParents()) {
            LOG.invalidDiscriminatorAnnotation(clazzToProcess.getName());
        }
        String discrimValue = clazzToProcess.isAnnotationPresent(DiscriminatorValue.class) ? clazzToProcess.getAnnotation(DiscriminatorValue.class).value() : null;
        entityBinder.setDiscriminatorValue(discrimValue);
        DiscriminatorOptions discriminatorOptions = clazzToProcess.getAnnotation(DiscriminatorOptions.class);
        if (discriminatorOptions != null) {
            entityBinder.setForceDiscriminator(discriminatorOptions.force());
            entityBinder.setInsertableDiscriminator(discriminatorOptions.insert());
        }
        return discriminatorColumn;
    }

    private static void processIdPropertiesIfNotAlready(Map<XClass, InheritanceState> inheritanceStatePerClass, Mappings mappings, PersistentClass persistentClass, EntityBinder entityBinder, PropertyHolder propertyHolder, HashMap<String, IdGenerator> classGenerators, InheritanceState.ElementsToProcess elementsToProcess, boolean subclassAndSingleTableStrategy, Set<String> idPropertiesIfIdClass) {
        HashSet<String> missingIdProperties = new HashSet<String>(idPropertiesIfIdClass);
        for (PropertyData propertyAnnotatedElement : elementsToProcess.getElements()) {
            String propertyName = propertyAnnotatedElement.getPropertyName();
            if (!idPropertiesIfIdClass.contains(propertyName)) {
                AnnotationBinder.processElementAnnotations(propertyHolder, subclassAndSingleTableStrategy ? Nullability.FORCED_NULL : Nullability.NO_CONSTRAINT, propertyAnnotatedElement, classGenerators, entityBinder, false, false, false, mappings, inheritanceStatePerClass);
                continue;
            }
            missingIdProperties.remove(propertyName);
        }
        if (missingIdProperties.size() != 0) {
            StringBuilder missings = new StringBuilder();
            for (String property : missingIdProperties) {
                missings.append(property).append(", ");
            }
            throw new AnnotationException("Unable to find properties (" + missings.substring(0, missings.length() - 2) + ") in entity annotated with @IdClass:" + persistentClass.getEntityName());
        }
    }

    private static boolean mapAsIdClass(Map<XClass, InheritanceState> inheritanceStatePerClass, InheritanceState inheritanceState, PersistentClass persistentClass, EntityBinder entityBinder, PropertyHolder propertyHolder, InheritanceState.ElementsToProcess elementsToProcess, Set<String> idPropertiesIfIdClass, Mappings mappings) {
        XClass classWithIdClass = inheritanceState.getClassWithIdClass(false);
        if (classWithIdClass != null) {
            AccessType propertyAccessor;
            PropertyPreloadedData baseInferredData;
            PropertyPreloadedData inferredData;
            IdClass idClass = classWithIdClass.getAnnotation(IdClass.class);
            XClass compositeClass = mappings.getReflectionManager().toXClass(idClass.value());
            boolean isFakeIdClass = AnnotationBinder.isIdClassPkOfTheAssociatedEntity(elementsToProcess, compositeClass, inferredData = new PropertyPreloadedData(entityBinder.getPropertyAccessType(), "id", compositeClass), baseInferredData = new PropertyPreloadedData(entityBinder.getPropertyAccessType(), "id", classWithIdClass), propertyAccessor = entityBinder.getPropertyAccessor(compositeClass), inheritanceStatePerClass, mappings);
            if (isFakeIdClass) {
                return false;
            }
            boolean isComponent = true;
            String generatorType = "assigned";
            String generator = "";
            boolean ignoreIdAnnotations = entityBinder.isIgnoreIdAnnotations();
            entityBinder.setIgnoreIdAnnotations(true);
            propertyHolder.setInIdClass(true);
            AnnotationBinder.bindIdClass(generatorType, generator, inferredData, baseInferredData, null, propertyHolder, isComponent, propertyAccessor, entityBinder, true, false, mappings, inheritanceStatePerClass);
            propertyHolder.setInIdClass(null);
            inferredData = new PropertyPreloadedData(propertyAccessor, "_identifierMapper", compositeClass);
            Component mapper = AnnotationBinder.fillComponent(propertyHolder, inferredData, baseInferredData, propertyAccessor, false, entityBinder, true, true, false, mappings, inheritanceStatePerClass);
            entityBinder.setIgnoreIdAnnotations(ignoreIdAnnotations);
            persistentClass.setIdentifierMapper(mapper);
            org.hibernate.mapping.MappedSuperclass superclass = BinderHelper.getMappedSuperclassOrNull(inferredData.getDeclaringClass(), inheritanceStatePerClass, mappings);
            if (superclass != null) {
                superclass.setDeclaredIdentifierMapper(mapper);
            } else {
                persistentClass.setDeclaredIdentifierMapper(mapper);
            }
            Property property = new Property();
            property.setName("_identifierMapper");
            property.setNodeName("id");
            property.setUpdateable(false);
            property.setInsertable(false);
            property.setValue(mapper);
            property.setPropertyAccessorName("embedded");
            persistentClass.addProperty(property);
            entityBinder.setIgnoreIdAnnotations(true);
            Iterator properties = mapper.getPropertyIterator();
            while (properties.hasNext()) {
                idPropertiesIfIdClass.add(((Property)properties.next()).getName());
            }
            return true;
        }
        return false;
    }

    private static boolean isIdClassPkOfTheAssociatedEntity(InheritanceState.ElementsToProcess elementsToProcess, XClass compositeClass, PropertyData inferredData, PropertyData baseInferredData, AccessType propertyAccessor, Map<XClass, InheritanceState> inheritanceStatePerClass, Mappings mappings) {
        if (elementsToProcess.getIdPropertyCount() == 1) {
            PropertyData idPropertyOnBaseClass = AnnotationBinder.getUniqueIdPropertyFromBaseClass(inferredData, baseInferredData, propertyAccessor, mappings);
            InheritanceState state = inheritanceStatePerClass.get(idPropertyOnBaseClass.getClassOrElement());
            if (state == null) {
                return false;
            }
            XClass associatedClassWithIdClass = state.getClassWithIdClass(true);
            if (associatedClassWithIdClass == null) {
                XProperty property = idPropertyOnBaseClass.getProperty();
                return property.isAnnotationPresent(ManyToOne.class) || property.isAnnotationPresent(OneToOne.class);
            }
            XClass idClass = mappings.getReflectionManager().toXClass(associatedClassWithIdClass.getAnnotation(IdClass.class).value());
            return idClass.equals(compositeClass);
        }
        return false;
    }

    private static Cache determineCacheSettings(XClass clazzToProcess, Mappings mappings) {
        Cache cacheAnn = clazzToProcess.getAnnotation(Cache.class);
        if (cacheAnn != null) {
            return cacheAnn;
        }
        Cacheable cacheableAnn = clazzToProcess.getAnnotation(Cacheable.class);
        SharedCacheMode mode = AnnotationBinder.determineSharedCacheMode(mappings);
        switch (mode) {
            case ALL: {
                cacheAnn = AnnotationBinder.buildCacheMock(clazzToProcess.getName(), mappings);
                break;
            }
            case ENABLE_SELECTIVE: {
                if (cacheableAnn == null || !cacheableAnn.value()) break;
                cacheAnn = AnnotationBinder.buildCacheMock(clazzToProcess.getName(), mappings);
                break;
            }
            case DISABLE_SELECTIVE: {
                if (cacheableAnn != null && !cacheableAnn.value()) break;
                cacheAnn = AnnotationBinder.buildCacheMock(clazzToProcess.getName(), mappings);
                break;
            }
        }
        return cacheAnn;
    }

    private static SharedCacheMode determineSharedCacheMode(Mappings mappings) {
        SharedCacheMode mode;
        Object value = mappings.getConfigurationProperties().get("javax.persistence.sharedCache.mode");
        if (value == null) {
            LOG.debug("No value specified for 'javax.persistence.sharedCache.mode'; using UNSPECIFIED");
            mode = SharedCacheMode.UNSPECIFIED;
        } else if (SharedCacheMode.class.isInstance(value)) {
            mode = (SharedCacheMode)((Object)value);
        } else {
            try {
                mode = SharedCacheMode.valueOf(value.toString());
            }
            catch (Exception e) {
                LOG.debugf("Unable to resolve given mode name [%s]; using UNSPECIFIED : %s", value, (Object)e);
                mode = SharedCacheMode.UNSPECIFIED;
            }
        }
        return mode;
    }

    private static Cache buildCacheMock(String region, Mappings mappings) {
        return new LocalCacheAnnotationImpl(region, AnnotationBinder.determineCacheConcurrencyStrategy(mappings));
    }

    static void prepareDefaultCacheConcurrencyStrategy(Properties properties) {
        if (DEFAULT_CACHE_CONCURRENCY_STRATEGY != null) {
            LOG.trace("Default cache concurrency strategy already defined");
            return;
        }
        if (!properties.containsKey("hibernate.cache.default_cache_concurrency_strategy")) {
            LOG.trace("Given properties did not contain any default cache concurrency strategy setting");
            return;
        }
        String strategyName = properties.getProperty("hibernate.cache.default_cache_concurrency_strategy");
        LOG.tracev("Discovered default cache concurrency strategy via config [{0}]", (Object)strategyName);
        CacheConcurrencyStrategy strategy = CacheConcurrencyStrategy.parse(strategyName);
        if (strategy == null) {
            LOG.trace("Discovered default cache concurrency strategy specified nothing");
            return;
        }
        LOG.debugf("Setting default cache concurrency strategy via config [%s]", (Object)strategy.name());
        DEFAULT_CACHE_CONCURRENCY_STRATEGY = strategy;
    }

    private static CacheConcurrencyStrategy determineCacheConcurrencyStrategy(Mappings mappings) {
        if (DEFAULT_CACHE_CONCURRENCY_STRATEGY == null) {
            RegionFactory cacheRegionFactory = SettingsFactory.createRegionFactory(mappings.getConfigurationProperties(), true);
            DEFAULT_CACHE_CONCURRENCY_STRATEGY = CacheConcurrencyStrategy.fromAccessType(cacheRegionFactory.getDefaultAccessType());
        }
        return DEFAULT_CACHE_CONCURRENCY_STRATEGY;
    }

    private static PersistentClass makePersistentClass(InheritanceState inheritanceState, PersistentClass superEntity) {
        PersistentClass persistentClass;
        if (!inheritanceState.hasParents()) {
            persistentClass = new RootClass();
        } else if (InheritanceType.SINGLE_TABLE.equals((Object)inheritanceState.getType())) {
            persistentClass = new SingleTableSubclass(superEntity);
        } else if (InheritanceType.JOINED.equals((Object)inheritanceState.getType())) {
            persistentClass = new JoinedSubclass(superEntity);
        } else if (InheritanceType.TABLE_PER_CLASS.equals((Object)inheritanceState.getType())) {
            persistentClass = new UnionSubclass(superEntity);
        } else {
            throw new AssertionFailure("Unknown inheritance type: " + (Object)((Object)inheritanceState.getType()));
        }
        return persistentClass;
    }

    private static Ejb3JoinColumn[] makeInheritanceJoinColumns(XClass clazzToProcess, Mappings mappings, InheritanceState inheritanceState, PersistentClass superEntity) {
        boolean hasJoinedColumns;
        Ejb3JoinColumn[] inheritanceJoinedColumns = null;
        boolean bl = hasJoinedColumns = inheritanceState.hasParents() && InheritanceType.JOINED.equals((Object)inheritanceState.getType());
        if (hasJoinedColumns) {
            boolean explicitInheritanceJoinedColumns;
            PrimaryKeyJoinColumns jcsAnn = clazzToProcess.getAnnotation(PrimaryKeyJoinColumns.class);
            boolean bl2 = explicitInheritanceJoinedColumns = jcsAnn != null && jcsAnn.value().length != 0;
            if (explicitInheritanceJoinedColumns) {
                int nbrOfInhJoinedColumns = jcsAnn.value().length;
                inheritanceJoinedColumns = new Ejb3JoinColumn[nbrOfInhJoinedColumns];
                for (int colIndex = 0; colIndex < nbrOfInhJoinedColumns; ++colIndex) {
                    PrimaryKeyJoinColumn jcAnn = jcsAnn.value()[colIndex];
                    inheritanceJoinedColumns[colIndex] = Ejb3JoinColumn.buildJoinColumn(jcAnn, null, superEntity.getIdentifier(), null, null, mappings);
                }
            } else {
                PrimaryKeyJoinColumn jcAnn = clazzToProcess.getAnnotation(PrimaryKeyJoinColumn.class);
                inheritanceJoinedColumns = new Ejb3JoinColumn[]{Ejb3JoinColumn.buildJoinColumn(jcAnn, null, superEntity.getIdentifier(), null, null, mappings)};
            }
            LOG.trace("Subclass joined column(s) created");
        } else if (clazzToProcess.isAnnotationPresent(PrimaryKeyJoinColumns.class) || clazzToProcess.isAnnotationPresent(PrimaryKeyJoinColumn.class)) {
            LOG.invalidPrimaryKeyJoinColumnAnnotation();
        }
        return inheritanceJoinedColumns;
    }

    private static PersistentClass getSuperEntity(XClass clazzToProcess, Map<XClass, InheritanceState> inheritanceStatePerClass, Mappings mappings, InheritanceState inheritanceState) {
        PersistentClass superEntity;
        InheritanceState superEntityState = InheritanceState.getInheritanceStateOfSuperEntity(clazzToProcess, inheritanceStatePerClass);
        PersistentClass persistentClass = superEntity = superEntityState != null ? mappings.getClass(superEntityState.getClazz().getName()) : null;
        if (superEntity == null && inheritanceState.hasParents()) {
            throw new AssertionFailure("Subclass has to be binded after it's mother class: " + superEntityState.getClazz().getName());
        }
        return superEntity;
    }

    private static boolean isEntityClassType(XClass clazzToProcess, AnnotatedClassType classType) {
        if (AnnotatedClassType.EMBEDDABLE_SUPERCLASS.equals((Object)classType) || AnnotatedClassType.NONE.equals((Object)classType) || AnnotatedClassType.EMBEDDABLE.equals((Object)classType)) {
            if (AnnotatedClassType.NONE.equals((Object)classType) && clazzToProcess.isAnnotationPresent(org.hibernate.annotations.Entity.class)) {
                LOG.missingEntityAnnotation(clazzToProcess.getName());
            }
            return false;
        }
        if (!classType.equals((Object)AnnotatedClassType.ENTITY)) {
            throw new AnnotationException("Annotated class should have a @javax.persistence.Entity, @javax.persistence.Embeddable or @javax.persistence.EmbeddedSuperclass annotation: " + clazzToProcess.getName());
        }
        return true;
    }

    private static void bindFilters(XClass annotatedClass, EntityBinder entityBinder, Mappings mappings) {
        AnnotationBinder.bindFilters(annotatedClass, entityBinder);
        for (XClass classToProcess = annotatedClass.getSuperclass(); classToProcess != null; classToProcess = classToProcess.getSuperclass()) {
            AnnotatedClassType classType = mappings.getClassType(classToProcess);
            if (!AnnotatedClassType.EMBEDDABLE_SUPERCLASS.equals((Object)classType)) continue;
            AnnotationBinder.bindFilters(classToProcess, entityBinder);
        }
    }

    private static void bindFilters(XAnnotatedElement annotatedElement, EntityBinder entityBinder) {
        Filter filterAnn;
        Filters filtersAnn = annotatedElement.getAnnotation(Filters.class);
        if (filtersAnn != null) {
            for (Filter filter : filtersAnn.value()) {
                entityBinder.addFilter(filter);
            }
        }
        if ((filterAnn = annotatedElement.getAnnotation(Filter.class)) != null) {
            entityBinder.addFilter(filterAnn);
        }
    }

    private static void bindFilterDefs(XAnnotatedElement annotatedElement, Mappings mappings) {
        FilterDef defAnn = annotatedElement.getAnnotation(FilterDef.class);
        FilterDefs defsAnn = annotatedElement.getAnnotation(FilterDefs.class);
        if (defAnn != null) {
            AnnotationBinder.bindFilterDef(defAnn, mappings);
        }
        if (defsAnn != null) {
            for (FilterDef def : defsAnn.value()) {
                AnnotationBinder.bindFilterDef(def, mappings);
            }
        }
    }

    private static void bindFilterDef(FilterDef defAnn, Mappings mappings) {
        HashMap<String, Type> params = new HashMap<String, Type>();
        for (ParamDef param : defAnn.parameters()) {
            params.put(param.name(), mappings.getTypeResolver().heuristicType(param.type()));
        }
        FilterDefinition def = new FilterDefinition(defAnn.name(), defAnn.defaultCondition(), params);
        LOG.debugf("Binding filter definition: %s", (Object)def.getFilterName());
        mappings.addFilterDefinition(def);
    }

    private static void bindTypeDefs(XAnnotatedElement annotatedElement, Mappings mappings) {
        TypeDef defAnn = annotatedElement.getAnnotation(TypeDef.class);
        TypeDefs defsAnn = annotatedElement.getAnnotation(TypeDefs.class);
        if (defAnn != null) {
            AnnotationBinder.bindTypeDef(defAnn, mappings);
        }
        if (defsAnn != null) {
            for (TypeDef def : defsAnn.value()) {
                AnnotationBinder.bindTypeDef(def, mappings);
            }
        }
    }

    private static void bindFetchProfiles(XAnnotatedElement annotatedElement, Mappings mappings) {
        FetchProfile fetchProfileAnnotation = annotatedElement.getAnnotation(FetchProfile.class);
        FetchProfiles fetchProfileAnnotations = annotatedElement.getAnnotation(FetchProfiles.class);
        if (fetchProfileAnnotation != null) {
            AnnotationBinder.bindFetchProfile(fetchProfileAnnotation, mappings);
        }
        if (fetchProfileAnnotations != null) {
            for (FetchProfile profile : fetchProfileAnnotations.value()) {
                AnnotationBinder.bindFetchProfile(profile, mappings);
            }
        }
    }

    private static void bindFetchProfile(FetchProfile fetchProfileAnnotation, Mappings mappings) {
        for (FetchProfile.FetchOverride fetch : fetchProfileAnnotation.fetchOverrides()) {
            org.hibernate.annotations.FetchMode mode = fetch.mode();
            if (!mode.equals((Object)org.hibernate.annotations.FetchMode.JOIN)) {
                throw new MappingException("Only FetchMode.JOIN is currently supported");
            }
            VerifyFetchProfileReferenceSecondPass sp = new VerifyFetchProfileReferenceSecondPass(fetchProfileAnnotation.name(), fetch, mappings);
            mappings.addSecondPass(sp);
        }
    }

    private static void bindTypeDef(TypeDef defAnn, Mappings mappings) {
        Properties params = new Properties();
        for (Parameter param : defAnn.parameters()) {
            params.setProperty(param.name(), param.value());
        }
        if (BinderHelper.isEmptyAnnotationValue(defAnn.name()) && defAnn.defaultForType().equals(Void.TYPE)) {
            throw new AnnotationException("Either name or defaultForType (or both) attribute should be set in TypeDef having typeClass " + defAnn.typeClass().getName());
        }
        String typeBindMessageF = "Binding type definition: %s";
        if (!BinderHelper.isEmptyAnnotationValue(defAnn.name())) {
            if (LOG.isDebugEnabled()) {
                LOG.debugf("Binding type definition: %s", (Object)defAnn.name());
            }
            mappings.addTypeDef(defAnn.name(), defAnn.typeClass().getName(), params);
        }
        if (!defAnn.defaultForType().equals(Void.TYPE)) {
            if (LOG.isDebugEnabled()) {
                LOG.debugf("Binding type definition: %s", (Object)defAnn.defaultForType().getName());
            }
            mappings.addTypeDef(defAnn.defaultForType().getName(), defAnn.typeClass().getName(), params);
        }
    }

    private static void bindDiscriminatorToPersistentClass(RootClass rootClass, Ejb3DiscriminatorColumn discriminatorColumn, Map<String, Join> secondaryTables, PropertyHolder propertyHolder, Mappings mappings) {
        if (rootClass.getDiscriminator() == null) {
            if (discriminatorColumn == null) {
                throw new AssertionFailure("discriminator column should have been built");
            }
            discriminatorColumn.setJoins(secondaryTables);
            discriminatorColumn.setPropertyHolder(propertyHolder);
            SimpleValue discrim = new SimpleValue(mappings, rootClass.getTable());
            rootClass.setDiscriminator(discrim);
            discriminatorColumn.linkWithValue(discrim);
            discrim.setTypeName(discriminatorColumn.getDiscriminatorTypeName());
            rootClass.setPolymorphic(true);
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Setting discriminator for entity {0}", (Object)rootClass.getEntityName());
            }
        }
    }

    static int addElementsOfClass(List<PropertyData> elements, AccessType defaultAccessType, PropertyContainer propertyContainer, Mappings mappings) {
        int idPropertyCounter = 0;
        AccessType accessType = defaultAccessType;
        if (propertyContainer.hasExplicitAccessStrategy()) {
            accessType = propertyContainer.getExplicitAccessStrategy();
        }
        Collection<XProperty> properties = propertyContainer.getProperties(accessType);
        for (XProperty p : properties) {
            int currentIdPropertyCounter = AnnotationBinder.addProperty(propertyContainer, p, elements, accessType.getType(), mappings);
            idPropertyCounter += currentIdPropertyCounter;
        }
        return idPropertyCounter;
    }

    private static int addProperty(PropertyContainer propertyContainer, XProperty property, List<PropertyData> annElts, String propertyAccessor, Mappings mappings) {
        XClass declaringClass = propertyContainer.getDeclaringClass();
        XClass entity = propertyContainer.getEntityAtStake();
        int idPropertyCounter = 0;
        PropertyInferredData propertyAnnotatedElement = new PropertyInferredData(declaringClass, property, propertyAccessor, mappings.getReflectionManager());
        XProperty element = propertyAnnotatedElement.getProperty();
        if (element.isAnnotationPresent(Id.class) || element.isAnnotationPresent(EmbeddedId.class)) {
            annElts.add(0, propertyAnnotatedElement);
            if (mappings.isSpecjProprietarySyntaxEnabled() && element.isAnnotationPresent(Id.class) && element.isAnnotationPresent(javax.persistence.Column.class)) {
                String columnName = element.getAnnotation(javax.persistence.Column.class).name();
                for (XProperty prop : declaringClass.getDeclaredProperties(AccessType.FIELD.getType())) {
                    if (prop.isAnnotationPresent(MapsId.class)) continue;
                    boolean isRequiredAnnotationPresent = false;
                    JoinColumns groupAnnotation = prop.getAnnotation(JoinColumns.class);
                    if (prop.isAnnotationPresent(JoinColumn.class) && prop.getAnnotation(JoinColumn.class).name().equals(columnName)) {
                        isRequiredAnnotationPresent = true;
                    } else if (prop.isAnnotationPresent(JoinColumns.class)) {
                        for (JoinColumn columnAnnotation : groupAnnotation.value()) {
                            if (!columnName.equals(columnAnnotation.name())) continue;
                            isRequiredAnnotationPresent = true;
                            break;
                        }
                    }
                    if (!isRequiredAnnotationPresent) continue;
                    PropertyInferredData specJPropertyData = new PropertyInferredData(declaringClass, prop, propertyAccessor, mappings.getReflectionManager());
                    mappings.addPropertyAnnotatedWithMapsIdSpecj(entity, specJPropertyData, element.toString());
                }
            }
            if (element.isAnnotationPresent(ManyToOne.class) || element.isAnnotationPresent(OneToOne.class)) {
                mappings.addToOneAndIdProperty(entity, propertyAnnotatedElement);
            }
            ++idPropertyCounter;
        } else {
            annElts.add(propertyAnnotatedElement);
        }
        if (element.isAnnotationPresent(MapsId.class)) {
            mappings.addPropertyAnnotatedWithMapsId(entity, propertyAnnotatedElement);
        }
        return idPropertyCounter;
    }

    private static void processElementAnnotations(PropertyHolder propertyHolder, Nullability nullability, PropertyData inferredData, HashMap<String, IdGenerator> classGenerators, EntityBinder entityBinder, boolean isIdentifierMapper, boolean isComponentEmbedded, boolean inSecondPass, Mappings mappings, Map<XClass, InheritanceState> inheritanceStatePerClass) throws MappingException {
        block77: {
            NaturalId naturalIdAnn;
            XProperty property;
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Processing annotations of {0}.{1}", (Object)propertyHolder.getEntityName(), (Object)inferredData.getPropertyName());
            }
            if ((property = inferredData.getProperty()).isAnnotationPresent(Parent.class)) {
                if (!propertyHolder.isComponent()) {
                    throw new AnnotationException("@Parent cannot be applied outside an embeddable object: " + BinderHelper.getPath(propertyHolder, inferredData));
                }
                propertyHolder.setParentProperty(property.getName());
                return;
            }
            ColumnsBuilder columnsBuilder = new ColumnsBuilder(propertyHolder, nullability, property, inferredData, entityBinder, mappings).extractMetadata();
            Ejb3Column[] columns = columnsBuilder.getColumns();
            Ejb3JoinColumn[] joinColumns = columnsBuilder.getJoinColumns();
            XClass returnedClass = inferredData.getClassOrElement();
            PropertyBinder propertyBinder = new PropertyBinder();
            propertyBinder.setName(inferredData.getPropertyName());
            propertyBinder.setReturnedClassName(inferredData.getTypeName());
            propertyBinder.setAccessType(inferredData.getDefaultAccess());
            propertyBinder.setHolder(propertyHolder);
            propertyBinder.setProperty(property);
            propertyBinder.setReturnedClass(inferredData.getPropertyClass());
            propertyBinder.setMappings(mappings);
            if (isIdentifierMapper) {
                propertyBinder.setInsertable(false);
                propertyBinder.setUpdatable(false);
            }
            propertyBinder.setDeclaringClass(inferredData.getDeclaringClass());
            propertyBinder.setEntityBinder(entityBinder);
            propertyBinder.setInheritanceStatePerClass(inheritanceStatePerClass);
            boolean isId = !entityBinder.isIgnoreIdAnnotations() && (property.isAnnotationPresent(Id.class) || property.isAnnotationPresent(EmbeddedId.class));
            propertyBinder.setId(isId);
            if (property.isAnnotationPresent(Version.class)) {
                if (isIdentifierMapper) {
                    throw new AnnotationException("@IdClass class should not have @Version property");
                }
                if (!(propertyHolder.getPersistentClass() instanceof RootClass)) {
                    throw new AnnotationException("Unable to define/override @Version on a subclass: " + propertyHolder.getEntityName());
                }
                if (!propertyHolder.isEntity()) {
                    throw new AnnotationException("Unable to define @Version on an embedded class: " + propertyHolder.getEntityName());
                }
                if (LOG.isTraceEnabled()) {
                    LOG.tracev("{0} is a version property", (Object)inferredData.getPropertyName());
                }
                RootClass rootClass = (RootClass)propertyHolder.getPersistentClass();
                propertyBinder.setColumns(columns);
                Property prop = propertyBinder.makePropertyValueAndBind();
                AnnotationBinder.setVersionInformation(property, propertyBinder);
                rootClass.setVersion(prop);
                org.hibernate.mapping.MappedSuperclass superclass = BinderHelper.getMappedSuperclassOrNull(inferredData.getDeclaringClass(), inheritanceStatePerClass, mappings);
                if (superclass != null) {
                    superclass.setDeclaredVersion(prop);
                } else {
                    rootClass.setDeclaredVersion(prop);
                }
                SimpleValue simpleValue = (SimpleValue)prop.getValue();
                simpleValue.setNullValue("undefined");
                rootClass.setOptimisticLockMode(0);
                if (LOG.isTraceEnabled()) {
                    LOG.tracev("Version name: {0}, unsavedValue: {1}", (Object)rootClass.getVersion().getName(), (Object)((SimpleValue)rootClass.getVersion().getValue()).getNullValue());
                }
            } else {
                boolean forcePersist;
                boolean bl = forcePersist = property.isAnnotationPresent(MapsId.class) || property.isAnnotationPresent(Id.class);
                if (property.isAnnotationPresent(ManyToOne.class)) {
                    ManyToOne ann = property.getAnnotation(ManyToOne.class);
                    if (property.isAnnotationPresent(javax.persistence.Column.class) || property.isAnnotationPresent(Columns.class)) {
                        throw new AnnotationException("@Column(s) not allowed on a @ManyToOne property: " + BinderHelper.getPath(propertyHolder, inferredData));
                    }
                    Cascade hibernateCascade = property.getAnnotation(Cascade.class);
                    NotFound notFound = property.getAnnotation(NotFound.class);
                    boolean ignoreNotFound = notFound != null && notFound.action().equals((Object)NotFoundAction.IGNORE);
                    OnDelete onDelete = property.getAnnotation(OnDelete.class);
                    boolean onDeleteCascade = onDelete != null && OnDeleteAction.CASCADE.equals((Object)onDelete.action());
                    JoinTable assocTable = propertyHolder.getJoinTable(property);
                    if (assocTable != null) {
                        Join join = propertyHolder.addJoin(assocTable, false);
                        for (Ejb3JoinColumn joinColumn : joinColumns) {
                            joinColumn.setSecondaryTableName(join.getTable().getName());
                        }
                    }
                    boolean mandatory = !ann.optional() || forcePersist;
                    AnnotationBinder.bindManyToOne(AnnotationBinder.getCascadeStrategy(ann.cascade(), hibernateCascade, false, forcePersist), joinColumns, !mandatory, ignoreNotFound, onDeleteCascade, ToOneBinder.getTargetEntity(inferredData, mappings), propertyHolder, inferredData, false, isIdentifierMapper, inSecondPass, propertyBinder, mappings);
                } else if (property.isAnnotationPresent(OneToOne.class)) {
                    OneToOne ann = property.getAnnotation(OneToOne.class);
                    if (property.isAnnotationPresent(javax.persistence.Column.class) || property.isAnnotationPresent(Columns.class)) {
                        throw new AnnotationException("@Column(s) not allowed on a @OneToOne property: " + BinderHelper.getPath(propertyHolder, inferredData));
                    }
                    boolean trueOneToOne = property.isAnnotationPresent(PrimaryKeyJoinColumn.class) || property.isAnnotationPresent(PrimaryKeyJoinColumns.class);
                    Cascade hibernateCascade = property.getAnnotation(Cascade.class);
                    NotFound notFound = property.getAnnotation(NotFound.class);
                    boolean bl2 = notFound != null && notFound.action().equals((Object)NotFoundAction.IGNORE);
                    OnDelete onDeleteAnn = property.getAnnotation(OnDelete.class);
                    boolean onDeleteCascade = onDeleteAnn != null && OnDeleteAction.CASCADE.equals((Object)onDeleteAnn.action());
                    JoinTable assocTable = propertyHolder.getJoinTable(property);
                    if (assocTable != null) {
                        Join join = propertyHolder.addJoin(assocTable, false);
                        for (Ejb3JoinColumn joinColumn : joinColumns) {
                            joinColumn.setSecondaryTableName(join.getTable().getName());
                        }
                    }
                    boolean mandatory = !ann.optional() || forcePersist;
                    AnnotationBinder.bindOneToOne(AnnotationBinder.getCascadeStrategy(ann.cascade(), hibernateCascade, ann.orphanRemoval(), forcePersist), joinColumns, !mandatory, AnnotationBinder.getFetchMode(ann.fetch()), bl2, onDeleteCascade, ToOneBinder.getTargetEntity(inferredData, mappings), propertyHolder, inferredData, ann.mappedBy(), trueOneToOne, isIdentifierMapper, inSecondPass, propertyBinder, mappings);
                } else if (property.isAnnotationPresent(Any.class)) {
                    if (property.isAnnotationPresent(javax.persistence.Column.class) || property.isAnnotationPresent(Columns.class)) {
                        throw new AnnotationException("@Column(s) not allowed on a @Any property: " + BinderHelper.getPath(propertyHolder, inferredData));
                    }
                    Cascade hibernateCascade = property.getAnnotation(Cascade.class);
                    OnDelete onDeleteAnn = property.getAnnotation(OnDelete.class);
                    boolean onDeleteCascade = onDeleteAnn != null && OnDeleteAction.CASCADE.equals((Object)onDeleteAnn.action());
                    JoinTable assocTable = propertyHolder.getJoinTable(property);
                    if (assocTable != null) {
                        Join join = propertyHolder.addJoin(assocTable, false);
                        for (Ejb3JoinColumn joinColumn : joinColumns) {
                            joinColumn.setSecondaryTableName(join.getTable().getName());
                        }
                    }
                    AnnotationBinder.bindAny(AnnotationBinder.getCascadeStrategy(null, hibernateCascade, false, forcePersist), joinColumns, onDeleteCascade, nullability, propertyHolder, inferredData, entityBinder, isIdentifierMapper, mappings);
                } else if (property.isAnnotationPresent(OneToMany.class) || property.isAnnotationPresent(ManyToMany.class) || property.isAnnotationPresent(ElementCollection.class) || property.isAnnotationPresent(ManyToAny.class)) {
                    Ejb3Column[] elementColumns;
                    PropertyData virtualProperty;
                    OneToMany oneToManyAnn = property.getAnnotation(OneToMany.class);
                    ManyToMany manyToManyAnn = property.getAnnotation(ManyToMany.class);
                    ElementCollection elementCollectionAnn = property.getAnnotation(ElementCollection.class);
                    IndexColumn indexColumn = property.isAnnotationPresent(OrderColumn.class) ? IndexColumn.buildColumnFromAnnotation(property.getAnnotation(OrderColumn.class), propertyHolder, inferredData, entityBinder.getSecondaryTables(), mappings) : IndexColumn.buildColumnFromAnnotation(property.getAnnotation(org.hibernate.annotations.IndexColumn.class), propertyHolder, inferredData, mappings);
                    CollectionBinder collectionBinder = CollectionBinder.getCollectionBinder(propertyHolder.getEntityName(), property, !indexColumn.isImplicit(), property.isAnnotationPresent(MapKeyType.class), mappings);
                    collectionBinder.setIndexColumn(indexColumn);
                    collectionBinder.setMapKey(property.getAnnotation(MapKey.class));
                    collectionBinder.setPropertyName(inferredData.getPropertyName());
                    BatchSize batchAnn = property.getAnnotation(BatchSize.class);
                    collectionBinder.setBatchSize(batchAnn);
                    OrderBy ejb3OrderByAnn = property.getAnnotation(OrderBy.class);
                    org.hibernate.annotations.OrderBy orderByAnn = property.getAnnotation(org.hibernate.annotations.OrderBy.class);
                    collectionBinder.setEjb3OrderBy(ejb3OrderByAnn);
                    collectionBinder.setSqlOrderBy(orderByAnn);
                    Sort sortAnn = property.getAnnotation(Sort.class);
                    collectionBinder.setSort(sortAnn);
                    Cache cachAnn = property.getAnnotation(Cache.class);
                    collectionBinder.setCache(cachAnn);
                    collectionBinder.setPropertyHolder(propertyHolder);
                    Cascade hibernateCascade = property.getAnnotation(Cascade.class);
                    NotFound notFound = property.getAnnotation(NotFound.class);
                    boolean ignoreNotFound = notFound != null && notFound.action().equals((Object)NotFoundAction.IGNORE);
                    collectionBinder.setIgnoreNotFound(ignoreNotFound);
                    collectionBinder.setCollectionType(inferredData.getProperty().getElementClass());
                    collectionBinder.setMappings(mappings);
                    collectionBinder.setAccessType(inferredData.getDefaultAccess());
                    boolean isJPA2ForValueMapping = property.isAnnotationPresent(ElementCollection.class);
                    PropertyData propertyData = virtualProperty = isJPA2ForValueMapping ? inferredData : new WrappedInferredData(inferredData, "element");
                    if (property.isAnnotationPresent(javax.persistence.Column.class) || property.isAnnotationPresent(Formula.class)) {
                        javax.persistence.Column ann = property.getAnnotation(javax.persistence.Column.class);
                        Formula formulaAnn = property.getAnnotation(Formula.class);
                        elementColumns = Ejb3Column.buildColumnFromAnnotation(new javax.persistence.Column[]{ann}, formulaAnn, nullability, propertyHolder, virtualProperty, entityBinder.getSecondaryTables(), mappings);
                    } else if (property.isAnnotationPresent(Columns.class)) {
                        Columns anns = property.getAnnotation(Columns.class);
                        elementColumns = Ejb3Column.buildColumnFromAnnotation(anns.columns(), null, nullability, propertyHolder, virtualProperty, entityBinder.getSecondaryTables(), mappings);
                    } else {
                        elementColumns = Ejb3Column.buildColumnFromAnnotation(null, null, nullability, propertyHolder, virtualProperty, entityBinder.getSecondaryTables(), mappings);
                    }
                    javax.persistence.Column[] keyColumns = null;
                    Boolean isJPA2 = null;
                    if (property.isAnnotationPresent(MapKeyColumn.class)) {
                        isJPA2 = Boolean.TRUE;
                        keyColumns = new javax.persistence.Column[]{new MapKeyColumnDelegator(property.getAnnotation(MapKeyColumn.class))};
                    }
                    if (isJPA2 == null) {
                        isJPA2 = Boolean.TRUE;
                    }
                    keyColumns = keyColumns != null && keyColumns.length > 0 ? keyColumns : null;
                    WrappedInferredData mapKeyVirtualProperty = new WrappedInferredData(inferredData, "mapkey");
                    Ejb3Column[] mapColumns = Ejb3Column.buildColumnFromAnnotation(keyColumns, null, Nullability.FORCED_NOT_NULL, propertyHolder, isJPA2 != false ? inferredData : mapKeyVirtualProperty, isJPA2 != false ? "_KEY" : null, entityBinder.getSecondaryTables(), mappings);
                    collectionBinder.setMapKeyColumns(mapColumns);
                    JoinColumn[] joinKeyColumns = null;
                    isJPA2 = null;
                    if (property.isAnnotationPresent(MapKeyJoinColumns.class)) {
                        isJPA2 = Boolean.TRUE;
                        MapKeyJoinColumn[] mapKeyJoinColumns = property.getAnnotation(MapKeyJoinColumns.class).value();
                        joinKeyColumns = new JoinColumn[mapKeyJoinColumns.length];
                        int index = 0;
                        for (MapKeyJoinColumn joinColumn : mapKeyJoinColumns) {
                            joinKeyColumns[index] = new MapKeyJoinColumnDelegator(joinColumn);
                            ++index;
                        }
                        if (property.isAnnotationPresent(MapKeyJoinColumn.class)) {
                            throw new AnnotationException("@MapKeyJoinColumn and @MapKeyJoinColumns used on the same property: " + BinderHelper.getPath(propertyHolder, inferredData));
                        }
                    } else if (property.isAnnotationPresent(MapKeyJoinColumn.class)) {
                        isJPA2 = Boolean.TRUE;
                        joinKeyColumns = new JoinColumn[]{new MapKeyJoinColumnDelegator(property.getAnnotation(MapKeyJoinColumn.class))};
                    }
                    if (isJPA2 == null) {
                        isJPA2 = Boolean.TRUE;
                    }
                    mapKeyVirtualProperty = new WrappedInferredData(inferredData, "mapkey");
                    Ejb3JoinColumn[] mapJoinColumns = Ejb3JoinColumn.buildJoinColumnsWithDefaultColumnSuffix(joinKeyColumns, null, entityBinder.getSecondaryTables(), propertyHolder, isJPA2 != false ? inferredData.getPropertyName() : mapKeyVirtualProperty.getPropertyName(), isJPA2 != false ? "_KEY" : null, mappings);
                    collectionBinder.setMapKeyManyToManyColumns(mapJoinColumns);
                    collectionBinder.setEmbedded(property.isAnnotationPresent(Embedded.class));
                    collectionBinder.setElementColumns(elementColumns);
                    collectionBinder.setProperty(property);
                    if (oneToManyAnn != null && manyToManyAnn != null) {
                        throw new AnnotationException("@OneToMany and @ManyToMany on the same property is not allowed: " + propertyHolder.getEntityName() + "." + inferredData.getPropertyName());
                    }
                    String mappedBy = null;
                    if (oneToManyAnn != null) {
                        for (Ejb3JoinColumn column : joinColumns) {
                            if (!column.isSecondary()) continue;
                            throw new NotYetImplementedException("Collections having FK in secondary table");
                        }
                        collectionBinder.setFkJoinColumns(joinColumns);
                        mappedBy = oneToManyAnn.mappedBy();
                        collectionBinder.setTargetEntity(mappings.getReflectionManager().toXClass(oneToManyAnn.targetEntity()));
                        collectionBinder.setCascadeStrategy(AnnotationBinder.getCascadeStrategy(oneToManyAnn.cascade(), hibernateCascade, oneToManyAnn.orphanRemoval(), false));
                        collectionBinder.setOneToMany(true);
                    } else if (elementCollectionAnn != null) {
                        for (Ejb3JoinColumn column : joinColumns) {
                            if (!column.isSecondary()) continue;
                            throw new NotYetImplementedException("Collections having FK in secondary table");
                        }
                        collectionBinder.setFkJoinColumns(joinColumns);
                        mappedBy = "";
                        Class targetElement = elementCollectionAnn.targetClass();
                        collectionBinder.setTargetEntity(mappings.getReflectionManager().toXClass(targetElement));
                        collectionBinder.setOneToMany(true);
                    } else if (manyToManyAnn != null) {
                        mappedBy = manyToManyAnn.mappedBy();
                        collectionBinder.setTargetEntity(mappings.getReflectionManager().toXClass(manyToManyAnn.targetEntity()));
                        collectionBinder.setCascadeStrategy(AnnotationBinder.getCascadeStrategy(manyToManyAnn.cascade(), hibernateCascade, false, false));
                        collectionBinder.setOneToMany(false);
                    } else if (property.isAnnotationPresent(ManyToAny.class)) {
                        mappedBy = "";
                        collectionBinder.setTargetEntity(mappings.getReflectionManager().toXClass(Void.TYPE));
                        collectionBinder.setCascadeStrategy(AnnotationBinder.getCascadeStrategy(null, hibernateCascade, false, false));
                        collectionBinder.setOneToMany(false);
                    }
                    collectionBinder.setMappedBy(mappedBy);
                    AnnotationBinder.bindJoinedTableAssociation(property, mappings, entityBinder, collectionBinder, propertyHolder, inferredData, mappedBy);
                    OnDelete onDeleteAnn = property.getAnnotation(OnDelete.class);
                    boolean onDeleteCascade = onDeleteAnn != null && OnDeleteAction.CASCADE.equals((Object)onDeleteAnn.action());
                    collectionBinder.setCascadeDeleteEnabled(onDeleteCascade);
                    if (isIdentifierMapper) {
                        collectionBinder.setInsertable(false);
                        collectionBinder.setUpdatable(false);
                    }
                    if (property.isAnnotationPresent(CollectionId.class)) {
                        HashMap localGenerators = (HashMap)classGenerators.clone();
                        localGenerators.putAll(AnnotationBinder.buildLocalGenerators(property, mappings));
                        collectionBinder.setLocalGenerators(localGenerators);
                    }
                    collectionBinder.setInheritanceStatePerClass(inheritanceStatePerClass);
                    collectionBinder.setDeclaringClass(inferredData.getDeclaringClass());
                    collectionBinder.bind();
                } else if (!isId || !entityBinder.isIgnoreIdAnnotations()) {
                    PropertyData overridingProperty;
                    boolean isComponent = false;
                    boolean isOverridden = false;
                    if ((isId || propertyHolder.isOrWithinEmbeddedId() || propertyHolder.isInIdClass()) && (overridingProperty = BinderHelper.getPropertyOverriddenByMapperOrMapsId(isId, propertyHolder, property.getName(), mappings)) != null) {
                        isOverridden = true;
                        InheritanceState state = inheritanceStatePerClass.get(overridingProperty.getClassOrElement());
                        if (state != null) {
                            isComponent = isComponent || state.hasIdClassOrEmbeddedId() != false;
                        }
                        columns = columnsBuilder.overrideColumnFromMapperOrMapsIdProperty(isId);
                    }
                    boolean bl3 = isComponent = isComponent || property.isAnnotationPresent(Embedded.class) || property.isAnnotationPresent(EmbeddedId.class) || returnedClass.isAnnotationPresent(Embeddable.class);
                    if (isComponent) {
                        String referencedEntityName = null;
                        if (isOverridden) {
                            PropertyData mapsIdProperty = BinderHelper.getPropertyOverriddenByMapperOrMapsId(isId, propertyHolder, property.getName(), mappings);
                            referencedEntityName = mapsIdProperty.getClassOrElementName();
                        }
                        AccessType propertyAccessor = entityBinder.getPropertyAccessor(property);
                        propertyBinder = AnnotationBinder.bindComponent(inferredData, propertyHolder, propertyAccessor, entityBinder, isIdentifierMapper, mappings, isComponentEmbedded, isId, inheritanceStatePerClass, referencedEntityName, isOverridden ? (Ejb3JoinColumn[])columns : null);
                    } else {
                        boolean optional = true;
                        boolean lazy = false;
                        if (property.isAnnotationPresent(Basic.class)) {
                            Basic basic = property.getAnnotation(Basic.class);
                            optional = basic.optional();
                            boolean bl4 = lazy = basic.fetch() == FetchType.LAZY;
                        }
                        if (isId || !optional && nullability != Nullability.FORCED_NULL) {
                            for (Ejb3Column col : columns) {
                                col.forceNotNull();
                            }
                        }
                        propertyBinder.setLazy(lazy);
                        propertyBinder.setColumns(columns);
                        if (isOverridden) {
                            PropertyData propertyData = BinderHelper.getPropertyOverriddenByMapperOrMapsId(isId, propertyHolder, property.getName(), mappings);
                            propertyBinder.setReferencedEntityName(propertyData.getClassOrElementName());
                        }
                        propertyBinder.makePropertyValueAndBind();
                    }
                    if (isOverridden) {
                        PropertyData mapsIdProperty = BinderHelper.getPropertyOverriddenByMapperOrMapsId(isId, propertyHolder, property.getName(), mappings);
                        HashMap localGenerators = (HashMap)classGenerators.clone();
                        IdGenerator idGenerator = new IdGenerator();
                        idGenerator.setIdentifierGeneratorStrategy("assigned");
                        idGenerator.setName("Hibernate-local--foreign generator");
                        idGenerator.setIdentifierGeneratorStrategy("foreign");
                        idGenerator.addParam("property", mapsIdProperty.getPropertyName());
                        localGenerators.put(idGenerator.getName(), idGenerator);
                        BinderHelper.makeIdGenerator((SimpleValue)propertyBinder.getValue(), idGenerator.getIdentifierGeneratorStrategy(), idGenerator.getName(), mappings, localGenerators);
                    }
                    if (isId) {
                        SimpleValue value = (SimpleValue)propertyBinder.getValue();
                        if (!isOverridden) {
                            AnnotationBinder.processId(propertyHolder, inferredData, value, classGenerators, isIdentifierMapper, mappings);
                        }
                    }
                }
            }
            Index index = property.getAnnotation(Index.class);
            if (index != null) {
                if (joinColumns != null) {
                    for (Ejb3JoinColumn column : joinColumns) {
                        column.addIndex(index, inSecondPass);
                    }
                } else if (columns != null) {
                    for (Ejb3Column column : columns) {
                        column.addIndex(index, inSecondPass);
                    }
                }
            }
            if ((naturalIdAnn = property.getAnnotation(NaturalId.class)) == null) break block77;
            if (joinColumns != null) {
                for (Ejb3JoinColumn ejb3JoinColumn : joinColumns) {
                    ejb3JoinColumn.addUniqueKey("_UniqueKey", inSecondPass);
                }
            } else {
                for (Ejb3Column ejb3Column : columns) {
                    ejb3Column.addUniqueKey("_UniqueKey", inSecondPass);
                }
            }
        }
    }

    private static void setVersionInformation(XProperty property, PropertyBinder propertyBinder) {
        propertyBinder.getSimpleValueBinder().setVersion(true);
        if (property.isAnnotationPresent(Source.class)) {
            Source source = property.getAnnotation(Source.class);
            propertyBinder.getSimpleValueBinder().setTimestampVersionType(source.value().typeName());
        }
    }

    private static void processId(PropertyHolder propertyHolder, PropertyData inferredData, SimpleValue idValue, HashMap<String, IdGenerator> classGenerators, boolean isIdentifierMapper, Mappings mappings) {
        String generatorName;
        if (isIdentifierMapper) {
            throw new AnnotationException("@IdClass class should not have @Id nor @EmbeddedId properties: " + BinderHelper.getPath(propertyHolder, inferredData));
        }
        XClass returnedClass = inferredData.getClassOrElement();
        XProperty property = inferredData.getProperty();
        HashMap localGenerators = (HashMap)classGenerators.clone();
        localGenerators.putAll(AnnotationBinder.buildLocalGenerators(property, mappings));
        boolean isComponent = returnedClass.isAnnotationPresent(Embeddable.class) || property.isAnnotationPresent(EmbeddedId.class);
        GeneratedValue generatedValue = property.getAnnotation(GeneratedValue.class);
        String generatorType = generatedValue != null ? AnnotationBinder.generatorType(generatedValue.strategy(), mappings) : "assigned";
        String string = generatorName = generatedValue != null ? generatedValue.generator() : "";
        if (isComponent) {
            generatorType = "assigned";
        }
        BinderHelper.makeIdGenerator(idValue, generatorType, generatorName, mappings, localGenerators);
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Bind {0} on {1}", (Object)(isComponent ? "@EmbeddedId" : "@Id"), (Object)inferredData.getPropertyName());
        }
    }

    private static void bindJoinedTableAssociation(XProperty property, Mappings mappings, EntityBinder entityBinder, CollectionBinder collectionBinder, PropertyHolder propertyHolder, PropertyData inferredData, String mappedBy) {
        JoinColumn[] annInverseJoins;
        JoinColumn[] annJoins;
        TableBinder associationTableBinder = new TableBinder();
        JoinTable assocTable = propertyHolder.getJoinTable(property);
        CollectionTable collectionTable = property.getAnnotation(CollectionTable.class);
        if (assocTable != null || collectionTable != null) {
            JoinColumn[] inverseJoins;
            JoinColumn[] joins;
            UniqueConstraint[] uniqueConstraints;
            String tableName;
            String schema;
            String catalog;
            if (collectionTable != null) {
                catalog = collectionTable.catalog();
                schema = collectionTable.schema();
                tableName = collectionTable.name();
                uniqueConstraints = collectionTable.uniqueConstraints();
                joins = collectionTable.joinColumns();
                inverseJoins = null;
            } else {
                catalog = assocTable.catalog();
                schema = assocTable.schema();
                tableName = assocTable.name();
                uniqueConstraints = assocTable.uniqueConstraints();
                joins = assocTable.joinColumns();
                inverseJoins = assocTable.inverseJoinColumns();
            }
            collectionBinder.setExplicitAssociationTable(true);
            if (!BinderHelper.isEmptyAnnotationValue(schema)) {
                associationTableBinder.setSchema(schema);
            }
            if (!BinderHelper.isEmptyAnnotationValue(catalog)) {
                associationTableBinder.setCatalog(catalog);
            }
            if (!BinderHelper.isEmptyAnnotationValue(tableName)) {
                associationTableBinder.setName(tableName);
            }
            associationTableBinder.setUniqueConstraints(uniqueConstraints);
            annJoins = joins.length == 0 ? null : joins;
            annInverseJoins = inverseJoins == null || inverseJoins.length == 0 ? null : inverseJoins;
        } else {
            annJoins = null;
            annInverseJoins = null;
        }
        Ejb3JoinColumn[] joinColumns = Ejb3JoinColumn.buildJoinTableJoinColumns(annJoins, entityBinder.getSecondaryTables(), propertyHolder, inferredData.getPropertyName(), mappedBy, mappings);
        Ejb3JoinColumn[] inverseJoinColumns = Ejb3JoinColumn.buildJoinTableJoinColumns(annInverseJoins, entityBinder.getSecondaryTables(), propertyHolder, inferredData.getPropertyName(), mappedBy, mappings);
        associationTableBinder.setMappings(mappings);
        collectionBinder.setTableBinder(associationTableBinder);
        collectionBinder.setJoinColumns(joinColumns);
        collectionBinder.setInverseJoinColumns(inverseJoinColumns);
    }

    private static PropertyBinder bindComponent(PropertyData inferredData, PropertyHolder propertyHolder, AccessType propertyAccessor, EntityBinder entityBinder, boolean isIdentifierMapper, Mappings mappings, boolean isComponentEmbedded, boolean isId, Map<XClass, InheritanceState> inheritanceStatePerClass, String referencedEntityName, Ejb3JoinColumn[] columns) {
        Component comp;
        if (referencedEntityName != null) {
            comp = AnnotationBinder.createComponent(propertyHolder, inferredData, isComponentEmbedded, isIdentifierMapper, mappings);
            CopyIdentifierComponentSecondPass sp = new CopyIdentifierComponentSecondPass(comp, referencedEntityName, columns, mappings);
            mappings.addSecondPass(sp);
        } else {
            comp = AnnotationBinder.fillComponent(propertyHolder, inferredData, propertyAccessor, !isId, entityBinder, isComponentEmbedded, isIdentifierMapper, false, mappings, inheritanceStatePerClass);
        }
        if (isId) {
            comp.setKey(true);
            if (propertyHolder.getPersistentClass().getIdentifier() != null) {
                throw new AnnotationException(comp.getComponentClassName() + " must not have @Id properties when used as an @EmbeddedId: " + BinderHelper.getPath(propertyHolder, inferredData));
            }
            if (referencedEntityName == null && comp.getPropertySpan() == 0) {
                throw new AnnotationException(comp.getComponentClassName() + " has no persistent id property: " + BinderHelper.getPath(propertyHolder, inferredData));
            }
        }
        XProperty property = inferredData.getProperty();
        AnnotationBinder.setupComponentTuplizer(property, comp);
        PropertyBinder binder = new PropertyBinder();
        binder.setName(inferredData.getPropertyName());
        binder.setValue(comp);
        binder.setProperty(inferredData.getProperty());
        binder.setAccessType(inferredData.getDefaultAccess());
        binder.setEmbedded(isComponentEmbedded);
        binder.setHolder(propertyHolder);
        binder.setId(isId);
        binder.setEntityBinder(entityBinder);
        binder.setInheritanceStatePerClass(inheritanceStatePerClass);
        binder.setMappings(mappings);
        binder.makePropertyAndBind();
        return binder;
    }

    public static Component fillComponent(PropertyHolder propertyHolder, PropertyData inferredData, AccessType propertyAccessor, boolean isNullable, EntityBinder entityBinder, boolean isComponentEmbedded, boolean isIdentifierMapper, boolean inSecondPass, Mappings mappings, Map<XClass, InheritanceState> inheritanceStatePerClass) {
        return AnnotationBinder.fillComponent(propertyHolder, inferredData, null, propertyAccessor, isNullable, entityBinder, isComponentEmbedded, isIdentifierMapper, inSecondPass, mappings, inheritanceStatePerClass);
    }

    public static Component fillComponent(PropertyHolder propertyHolder, PropertyData inferredData, PropertyData baseInferredData, AccessType propertyAccessor, boolean isNullable, EntityBinder entityBinder, boolean isComponentEmbedded, boolean isIdentifierMapper, boolean inSecondPass, Mappings mappings, Map<XClass, InheritanceState> inheritanceStatePerClass) {
        PropertyContainer propContainer;
        Component comp = AnnotationBinder.createComponent(propertyHolder, inferredData, isComponentEmbedded, isIdentifierMapper, mappings);
        String subpath = BinderHelper.getPath(propertyHolder, inferredData);
        LOG.tracev("Binding component with path: {0}", (Object)subpath);
        PropertyHolder subHolder = PropertyHolderBuilder.buildPropertyHolder(comp, subpath, inferredData, propertyHolder, mappings);
        XClass xClassProcessed = inferredData.getPropertyClass();
        ArrayList<PropertyData> classElements = new ArrayList<PropertyData>();
        XClass returnedClassOrElement = inferredData.getClassOrElement();
        ArrayList<PropertyData> baseClassElements = null;
        HashMap<String, PropertyData> orderedBaseClassElements = new HashMap<String, PropertyData>();
        if (baseInferredData != null) {
            baseClassElements = new ArrayList<PropertyData>();
            XClass baseReturnedClassOrElement = baseInferredData.getClassOrElement();
            AnnotationBinder.bindTypeDefs(baseReturnedClassOrElement, mappings);
            propContainer = new PropertyContainer(baseReturnedClassOrElement, xClassProcessed);
            AnnotationBinder.addElementsOfClass(baseClassElements, propertyAccessor, propContainer, mappings);
            for (PropertyData element : baseClassElements) {
                orderedBaseClassElements.put(element.getPropertyName(), element);
            }
        }
        AnnotationBinder.bindTypeDefs(returnedClassOrElement, mappings);
        propContainer = new PropertyContainer(returnedClassOrElement, xClassProcessed);
        AnnotationBinder.addElementsOfClass(classElements, propertyAccessor, propContainer, mappings);
        for (XClass superClass = xClassProcessed.getSuperclass(); superClass != null && superClass.isAnnotationPresent(MappedSuperclass.class); superClass = superClass.getSuperclass()) {
            propContainer = new PropertyContainer(superClass, xClassProcessed);
            AnnotationBinder.addElementsOfClass(classElements, propertyAccessor, propContainer, mappings);
        }
        if (baseClassElements != null && !AnnotationBinder.hasAnnotationsOnIdClass(xClassProcessed)) {
            for (int i = 0; i < classElements.size(); ++i) {
                PropertyData idClassPropertyData = (PropertyData)classElements.get(i);
                PropertyData entityPropertyData = (PropertyData)orderedBaseClassElements.get(idClassPropertyData.getPropertyName());
                if (propertyHolder.isInIdClass()) {
                    boolean isOfDifferentType;
                    if (entityPropertyData == null) {
                        throw new AnnotationException("Property of @IdClass not found in entity " + baseInferredData.getPropertyClass().getName() + ": " + idClassPropertyData.getPropertyName());
                    }
                    boolean hasXToOneAnnotation = entityPropertyData.getProperty().isAnnotationPresent(ManyToOne.class) || entityPropertyData.getProperty().isAnnotationPresent(OneToOne.class);
                    boolean bl = isOfDifferentType = !entityPropertyData.getClassOrElement().equals(idClassPropertyData.getClassOrElement());
                    if (hasXToOneAnnotation && isOfDifferentType) continue;
                    classElements.set(i, entityPropertyData);
                    continue;
                }
                classElements.set(i, entityPropertyData);
            }
        }
        for (PropertyData propertyAnnotatedElement : classElements) {
            AnnotationBinder.processElementAnnotations(subHolder, isNullable ? Nullability.NO_CONSTRAINT : Nullability.FORCED_NOT_NULL, propertyAnnotatedElement, new HashMap<String, IdGenerator>(), entityBinder, isIdentifierMapper, isComponentEmbedded, inSecondPass, mappings, inheritanceStatePerClass);
            XProperty property = propertyAnnotatedElement.getProperty();
            if (!property.isAnnotationPresent(GeneratedValue.class) || !property.isAnnotationPresent(Id.class)) continue;
            HashMap<String, IdGenerator> localGenerators = new HashMap<String, IdGenerator>();
            localGenerators.putAll(AnnotationBinder.buildLocalGenerators(property, mappings));
            GeneratedValue generatedValue = property.getAnnotation(GeneratedValue.class);
            String generatorType = generatedValue != null ? AnnotationBinder.generatorType(generatedValue.strategy(), mappings) : "assigned";
            String generator = generatedValue != null ? generatedValue.generator() : "";
            BinderHelper.makeIdGenerator((SimpleValue)comp.getProperty(property.getName()).getValue(), generatorType, generator, mappings, localGenerators);
        }
        return comp;
    }

    public static Component createComponent(PropertyHolder propertyHolder, PropertyData inferredData, boolean isComponentEmbedded, boolean isIdentifierMapper, Mappings mappings) {
        Component comp = new Component(mappings, propertyHolder.getPersistentClass());
        comp.setEmbedded(isComponentEmbedded);
        comp.setTable(propertyHolder.getTable());
        if (isIdentifierMapper || isComponentEmbedded && inferredData.getPropertyName() == null) {
            comp.setComponentClassName(comp.getOwner().getClassName());
        } else {
            comp.setComponentClassName(inferredData.getClassOrElementName());
        }
        comp.setNodeName(inferredData.getPropertyName());
        return comp;
    }

    private static void bindIdClass(String generatorType, String generatorName, PropertyData inferredData, PropertyData baseInferredData, Ejb3Column[] columns, PropertyHolder propertyHolder, boolean isComposite, AccessType propertyAccessor, EntityBinder entityBinder, boolean isEmbedded, boolean isIdentifierMapper, Mappings mappings, Map<XClass, InheritanceState> inheritanceStatePerClass) {
        SimpleValue id;
        PersistentClass persistentClass = propertyHolder.getPersistentClass();
        if (!(persistentClass instanceof RootClass)) {
            throw new AnnotationException("Unable to define/override @Id(s) on a subclass: " + propertyHolder.getEntityName());
        }
        RootClass rootClass = (RootClass)persistentClass;
        String persistentClassName = rootClass.getClassName();
        String propertyName = inferredData.getPropertyName();
        HashMap<String, IdGenerator> localGenerators = new HashMap<String, IdGenerator>();
        if (isComposite) {
            Component componentId = id = AnnotationBinder.fillComponent(propertyHolder, inferredData, baseInferredData, propertyAccessor, false, entityBinder, isEmbedded, isIdentifierMapper, false, mappings, inheritanceStatePerClass);
            componentId.setKey(true);
            if (rootClass.getIdentifier() != null) {
                throw new AnnotationException(componentId.getComponentClassName() + " must not have @Id properties when used as an @EmbeddedId");
            }
            if (componentId.getPropertySpan() == 0) {
                throw new AnnotationException(componentId.getComponentClassName() + " has no persistent id property");
            }
            XProperty property = inferredData.getProperty();
            AnnotationBinder.setupComponentTuplizer(property, componentId);
        } else {
            for (Ejb3Column column : columns) {
                column.forceNotNull();
            }
            SimpleValueBinder value = new SimpleValueBinder();
            value.setPropertyName(propertyName);
            value.setReturnedClassName(inferredData.getTypeName());
            value.setColumns(columns);
            value.setPersistentClassName(persistentClassName);
            value.setMappings(mappings);
            value.setType(inferredData.getProperty(), inferredData.getClassOrElement(), persistentClassName);
            value.setAccessType(propertyAccessor);
            id = value.make();
        }
        rootClass.setIdentifier(id);
        BinderHelper.makeIdGenerator(id, generatorType, generatorName, mappings, localGenerators);
        if (isEmbedded) {
            rootClass.setEmbeddedIdentifier(inferredData.getPropertyClass() == null);
        } else {
            PropertyBinder binder = new PropertyBinder();
            binder.setName(propertyName);
            binder.setValue(id);
            binder.setAccessType(inferredData.getDefaultAccess());
            binder.setProperty(inferredData.getProperty());
            Property prop = binder.makeProperty();
            rootClass.setIdentifierProperty(prop);
            org.hibernate.mapping.MappedSuperclass superclass = BinderHelper.getMappedSuperclassOrNull(inferredData.getDeclaringClass(), inheritanceStatePerClass, mappings);
            if (superclass != null) {
                superclass.setDeclaredIdentifierProperty(prop);
            } else {
                rootClass.setDeclaredIdentifierProperty(prop);
            }
        }
    }

    private static PropertyData getUniqueIdPropertyFromBaseClass(PropertyData inferredData, PropertyData baseInferredData, AccessType propertyAccessor, Mappings mappings) {
        ArrayList<PropertyData> baseClassElements = new ArrayList<PropertyData>();
        XClass baseReturnedClassOrElement = baseInferredData.getClassOrElement();
        PropertyContainer propContainer = new PropertyContainer(baseReturnedClassOrElement, inferredData.getPropertyClass());
        AnnotationBinder.addElementsOfClass(baseClassElements, propertyAccessor, propContainer, mappings);
        return (PropertyData)baseClassElements.get(0);
    }

    private static void setupComponentTuplizer(XProperty property, Component component) {
        if (property == null) {
            return;
        }
        if (property.isAnnotationPresent(Tuplizers.class)) {
            for (Tuplizer tuplizer : property.getAnnotation(Tuplizers.class).value()) {
                EntityMode mode = EntityMode.parse(tuplizer.entityMode());
                component.addTuplizer(mode, tuplizer.impl().getName());
            }
        }
        if (property.isAnnotationPresent(Tuplizer.class)) {
            Tuplizer tuplizer = property.getAnnotation(Tuplizer.class);
            EntityMode mode = EntityMode.parse(tuplizer.entityMode());
            component.addTuplizer(mode, tuplizer.impl().getName());
        }
    }

    private static void bindManyToOne(String cascadeStrategy, Ejb3JoinColumn[] columns, boolean optional, boolean ignoreNotFound, boolean cascadeOnDelete, XClass targetEntity, PropertyHolder propertyHolder, PropertyData inferredData, boolean unique, boolean isIdentifierMapper, boolean inSecondPass, PropertyBinder propertyBinder, Mappings mappings) {
        String fkName;
        org.hibernate.mapping.ManyToOne value = new org.hibernate.mapping.ManyToOne(mappings, columns[0].getTable());
        if (unique) {
            value.markAsLogicalOneToOne();
        }
        value.setReferencedEntityName(ToOneBinder.getReferenceEntityName(inferredData, targetEntity, mappings));
        XProperty property = inferredData.getProperty();
        AnnotationBinder.defineFetchingStrategy(value, property);
        value.setIgnoreNotFound(ignoreNotFound);
        value.setCascadeDeleteEnabled(cascadeOnDelete);
        if (!optional) {
            for (Ejb3JoinColumn column : columns) {
                column.setNullable(false);
            }
        }
        if (property.isAnnotationPresent(MapsId.class)) {
            for (Ejb3JoinColumn column : columns) {
                column.setInsertable(false);
                column.setUpdatable(false);
            }
        }
        boolean hasSpecjManyToOne = false;
        if (mappings.isSpecjProprietarySyntaxEnabled()) {
            String columnName = "";
            for (XProperty prop : inferredData.getDeclaringClass().getDeclaredProperties(AccessType.FIELD.getType())) {
                if (prop.isAnnotationPresent(Id.class) && prop.isAnnotationPresent(javax.persistence.Column.class)) {
                    columnName = prop.getAnnotation(javax.persistence.Column.class).name();
                }
                JoinColumn joinColumn = property.getAnnotation(JoinColumn.class);
                if (!property.isAnnotationPresent(ManyToOne.class) || joinColumn == null || BinderHelper.isEmptyAnnotationValue(joinColumn.name()) || !joinColumn.name().equals(columnName) || property.isAnnotationPresent(MapsId.class)) continue;
                hasSpecjManyToOne = true;
                for (Ejb3JoinColumn column : columns) {
                    column.setInsertable(false);
                    column.setUpdatable(false);
                }
            }
        }
        value.setTypeName(inferredData.getClassOrElementName());
        String propertyName = inferredData.getPropertyName();
        value.setTypeUsingReflection(propertyHolder.getClassName(), propertyName);
        ForeignKey fk = property.getAnnotation(ForeignKey.class);
        String string = fkName = fk != null ? fk.name() : "";
        if (!BinderHelper.isEmptyAnnotationValue(fkName)) {
            value.setForeignKeyName(fkName);
        }
        String path = propertyHolder.getPath() + "." + propertyName;
        ToOneFkSecondPass secondPass = new ToOneFkSecondPass(value, columns, !optional && unique, propertyHolder.getEntityOwnerClassName(), path, mappings);
        if (inSecondPass) {
            secondPass.doSecondPass(mappings.getClasses());
        } else {
            mappings.addSecondPass(secondPass);
        }
        Ejb3Column.checkPropertyConsistency(columns, propertyHolder.getEntityName() + propertyName);
        propertyBinder.setName(propertyName);
        propertyBinder.setValue(value);
        if (isIdentifierMapper) {
            propertyBinder.setInsertable(false);
            propertyBinder.setUpdatable(false);
        } else if (hasSpecjManyToOne) {
            propertyBinder.setInsertable(false);
            propertyBinder.setUpdatable(false);
        } else {
            propertyBinder.setInsertable(columns[0].isInsertable());
            propertyBinder.setUpdatable(columns[0].isUpdatable());
        }
        propertyBinder.setColumns(columns);
        propertyBinder.setAccessType(inferredData.getDefaultAccess());
        propertyBinder.setCascade(cascadeStrategy);
        propertyBinder.setProperty(property);
        propertyBinder.setXToMany(true);
        propertyBinder.makePropertyAndBind();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected static void defineFetchingStrategy(ToOne toOne, XProperty property) {
        FetchType fetchType;
        LazyToOne lazy = property.getAnnotation(LazyToOne.class);
        Fetch fetch = property.getAnnotation(Fetch.class);
        ManyToOne manyToOne = property.getAnnotation(ManyToOne.class);
        OneToOne oneToOne = property.getAnnotation(OneToOne.class);
        if (manyToOne != null) {
            fetchType = manyToOne.fetch();
        } else {
            if (oneToOne == null) throw new AssertionFailure("Define fetch strategy on a property not annotated with @OneToMany nor @OneToOne");
            fetchType = oneToOne.fetch();
        }
        if (lazy != null) {
            toOne.setLazy(lazy.value() != LazyToOneOption.FALSE);
            toOne.setUnwrapProxy(lazy.value() == LazyToOneOption.NO_PROXY);
        } else {
            toOne.setLazy(fetchType == FetchType.LAZY);
            toOne.setUnwrapProxy(false);
        }
        if (fetch == null) {
            toOne.setFetchMode(AnnotationBinder.getFetchMode(fetchType));
            return;
        }
        if (fetch.value() == org.hibernate.annotations.FetchMode.JOIN) {
            toOne.setFetchMode(FetchMode.JOIN);
            toOne.setLazy(false);
            toOne.setUnwrapProxy(false);
            return;
        }
        if (fetch.value() == org.hibernate.annotations.FetchMode.SELECT) {
            toOne.setFetchMode(FetchMode.SELECT);
            return;
        }
        if (fetch.value() != org.hibernate.annotations.FetchMode.SUBSELECT) throw new AssertionFailure("Unknown FetchMode: " + (Object)((Object)fetch.value()));
        throw new AnnotationException("Use of FetchMode.SUBSELECT not allowed on ToOne associations");
    }

    private static void bindOneToOne(String cascadeStrategy, Ejb3JoinColumn[] joinColumns, boolean optional, FetchMode fetchMode, boolean ignoreNotFound, boolean cascadeOnDelete, XClass targetEntity, PropertyHolder propertyHolder, PropertyData inferredData, String mappedBy, boolean trueOneToOne, boolean isIdentifierMapper, boolean inSecondPass, PropertyBinder propertyBinder, Mappings mappings) {
        String propertyName = inferredData.getPropertyName();
        LOG.tracev("Fetching {0} with {1}", (Object)propertyName, (Object)fetchMode);
        boolean mapToPK = true;
        if (!trueOneToOne) {
            KeyValue identifier = propertyHolder.getIdentifier();
            if (identifier == null) {
                mapToPK = false;
            } else {
                Iterator idColumns = identifier.getColumnIterator();
                ArrayList<String> idColumnNames = new ArrayList<String>();
                if (identifier.getColumnSpan() != joinColumns.length) {
                    mapToPK = false;
                } else {
                    while (idColumns.hasNext()) {
                        Column currentColumn = (Column)idColumns.next();
                        idColumnNames.add(currentColumn.getName());
                    }
                    for (Ejb3JoinColumn col : joinColumns) {
                        if (idColumnNames.contains(col.getMappingColumn().getName())) continue;
                        mapToPK = false;
                        break;
                    }
                }
            }
        }
        if (trueOneToOne || mapToPK || !BinderHelper.isEmptyAnnotationValue(mappedBy)) {
            OneToOneSecondPass secondPass = new OneToOneSecondPass(mappedBy, propertyHolder.getEntityName(), propertyName, propertyHolder, inferredData, targetEntity, ignoreNotFound, cascadeOnDelete, optional, cascadeStrategy, joinColumns, mappings);
            if (inSecondPass) {
                secondPass.doSecondPass(mappings.getClasses());
            } else {
                mappings.addSecondPass(secondPass, BinderHelper.isEmptyAnnotationValue(mappedBy));
            }
        } else {
            AnnotationBinder.bindManyToOne(cascadeStrategy, joinColumns, optional, ignoreNotFound, cascadeOnDelete, targetEntity, propertyHolder, inferredData, true, isIdentifierMapper, inSecondPass, propertyBinder, mappings);
        }
    }

    private static void bindAny(String cascadeStrategy, Ejb3JoinColumn[] columns, boolean cascadeOnDelete, Nullability nullability, PropertyHolder propertyHolder, PropertyData inferredData, EntityBinder entityBinder, boolean isIdentifierMapper, Mappings mappings) {
        Any anyAnn = inferredData.getProperty().getAnnotation(Any.class);
        if (anyAnn == null) {
            throw new AssertionFailure("Missing @Any annotation: " + BinderHelper.getPath(propertyHolder, inferredData));
        }
        org.hibernate.mapping.Any value = BinderHelper.buildAnyValue(anyAnn.metaDef(), columns, anyAnn.metaColumn(), inferredData, cascadeOnDelete, nullability, propertyHolder, entityBinder, anyAnn.optional(), mappings);
        PropertyBinder binder = new PropertyBinder();
        binder.setName(inferredData.getPropertyName());
        binder.setValue(value);
        binder.setLazy(anyAnn.fetch() == FetchType.LAZY);
        if (isIdentifierMapper) {
            binder.setInsertable(false);
            binder.setUpdatable(false);
        } else {
            binder.setInsertable(columns[0].isInsertable());
            binder.setUpdatable(columns[0].isUpdatable());
        }
        binder.setAccessType(inferredData.getDefaultAccess());
        binder.setCascade(cascadeStrategy);
        Property prop = binder.makeProperty();
        propertyHolder.addProperty(prop, columns, inferredData.getDeclaringClass());
    }

    private static String generatorType(GenerationType generatorEnum, Mappings mappings) {
        boolean useNewGeneratorMappings = mappings.useNewGeneratorMappings();
        switch (generatorEnum) {
            case IDENTITY: {
                return "identity";
            }
            case AUTO: {
                return useNewGeneratorMappings ? SequenceStyleGenerator.class.getName() : "native";
            }
            case TABLE: {
                return useNewGeneratorMappings ? TableGenerator.class.getName() : MultipleHiLoPerTableGenerator.class.getName();
            }
            case SEQUENCE: {
                return useNewGeneratorMappings ? SequenceStyleGenerator.class.getName() : "seqhilo";
            }
        }
        throw new AssertionFailure("Unknown GeneratorType: " + (Object)((Object)generatorEnum));
    }

    private static EnumSet<CascadeType> convertToHibernateCascadeType(javax.persistence.CascadeType[] ejbCascades) {
        EnumSet<CascadeType> hibernateCascadeSet = EnumSet.noneOf(CascadeType.class);
        if (ejbCascades != null && ejbCascades.length > 0) {
            block8: for (javax.persistence.CascadeType cascade : ejbCascades) {
                switch (cascade) {
                    case ALL: {
                        hibernateCascadeSet.add(CascadeType.ALL);
                        continue block8;
                    }
                    case PERSIST: {
                        hibernateCascadeSet.add(CascadeType.PERSIST);
                        continue block8;
                    }
                    case MERGE: {
                        hibernateCascadeSet.add(CascadeType.MERGE);
                        continue block8;
                    }
                    case REMOVE: {
                        hibernateCascadeSet.add(CascadeType.REMOVE);
                        continue block8;
                    }
                    case REFRESH: {
                        hibernateCascadeSet.add(CascadeType.REFRESH);
                        continue block8;
                    }
                    case DETACH: {
                        hibernateCascadeSet.add(CascadeType.DETACH);
                    }
                }
            }
        }
        return hibernateCascadeSet;
    }

    private static String getCascadeStrategy(javax.persistence.CascadeType[] ejbCascades, Cascade hibernateCascadeAnnotation, boolean orphanRemoval, boolean forcePersist) {
        CascadeType[] hibernateCascades;
        EnumSet<CascadeType> hibernateCascadeSet = AnnotationBinder.convertToHibernateCascadeType(ejbCascades);
        CascadeType[] cascadeTypeArray = hibernateCascades = hibernateCascadeAnnotation == null ? null : hibernateCascadeAnnotation.value();
        if (hibernateCascades != null && hibernateCascades.length > 0) {
            hibernateCascadeSet.addAll(Arrays.asList(hibernateCascades));
        }
        if (orphanRemoval) {
            hibernateCascadeSet.add(CascadeType.DELETE_ORPHAN);
            hibernateCascadeSet.add(CascadeType.REMOVE);
        }
        if (forcePersist) {
            hibernateCascadeSet.add(CascadeType.PERSIST);
        }
        StringBuilder cascade = new StringBuilder();
        for (CascadeType aHibernateCascadeSet : hibernateCascadeSet) {
            switch (aHibernateCascadeSet) {
                case ALL: {
                    cascade.append(",").append("all");
                    break;
                }
                case SAVE_UPDATE: {
                    cascade.append(",").append("save-update");
                    break;
                }
                case PERSIST: {
                    cascade.append(",").append("persist");
                    break;
                }
                case MERGE: {
                    cascade.append(",").append("merge");
                    break;
                }
                case LOCK: {
                    cascade.append(",").append("lock");
                    break;
                }
                case REFRESH: {
                    cascade.append(",").append("refresh");
                    break;
                }
                case REPLICATE: {
                    cascade.append(",").append("replicate");
                    break;
                }
                case EVICT: 
                case DETACH: {
                    cascade.append(",").append("evict");
                    break;
                }
                case DELETE: {
                    cascade.append(",").append("delete");
                    break;
                }
                case DELETE_ORPHAN: {
                    cascade.append(",").append("delete-orphan");
                    break;
                }
                case REMOVE: {
                    cascade.append(",").append("delete");
                }
            }
        }
        return cascade.length() > 0 ? cascade.substring(1) : "none";
    }

    public static FetchMode getFetchMode(FetchType fetch) {
        if (fetch == FetchType.EAGER) {
            return FetchMode.JOIN;
        }
        return FetchMode.SELECT;
    }

    private static HashMap<String, IdGenerator> buildLocalGenerators(XAnnotatedElement annElt, Mappings mappings) {
        IdGenerator idGen;
        HashMap<String, IdGenerator> generators = new HashMap<String, IdGenerator>();
        javax.persistence.TableGenerator tabGen = annElt.getAnnotation(javax.persistence.TableGenerator.class);
        SequenceGenerator seqGen = annElt.getAnnotation(SequenceGenerator.class);
        GenericGenerator genGen = annElt.getAnnotation(GenericGenerator.class);
        if (tabGen != null) {
            idGen = AnnotationBinder.buildIdGenerator(tabGen, mappings);
            generators.put(idGen.getName(), idGen);
        }
        if (seqGen != null) {
            idGen = AnnotationBinder.buildIdGenerator(seqGen, mappings);
            generators.put(idGen.getName(), idGen);
        }
        if (genGen != null) {
            idGen = AnnotationBinder.buildIdGenerator(genGen, mappings);
            generators.put(idGen.getName(), idGen);
        }
        return generators;
    }

    public static boolean isDefault(XClass clazz, Mappings mappings) {
        return mappings.getReflectionManager().equals(clazz, Void.TYPE);
    }

    public static Map<XClass, InheritanceState> buildInheritanceStates(List<XClass> orderedClasses, Mappings mappings) {
        ReflectionManager reflectionManager = mappings.getReflectionManager();
        HashMap<XClass, InheritanceState> inheritanceStatePerClass = new HashMap<XClass, InheritanceState>(orderedClasses.size());
        for (XClass clazz : orderedClasses) {
            InheritanceState superclassState = InheritanceState.getSuperclassInheritanceState(clazz, inheritanceStatePerClass);
            InheritanceState state = new InheritanceState(clazz, inheritanceStatePerClass, mappings);
            if (superclassState != null) {
                boolean nonDefault;
                superclassState.setHasSiblings(true);
                InheritanceState superEntityState = InheritanceState.getInheritanceStateOfSuperEntity(clazz, inheritanceStatePerClass);
                state.setHasParents(superEntityState != null);
                boolean bl = nonDefault = state.getType() != null && !InheritanceType.SINGLE_TABLE.equals((Object)state.getType());
                if (superclassState.getType() != null) {
                    boolean mixingStrategy;
                    boolean bl2 = mixingStrategy = state.getType() != null && !state.getType().equals((Object)superclassState.getType());
                    if (nonDefault && mixingStrategy) {
                        LOG.invalidSubStrategy(clazz.getName());
                    }
                    state.setType(superclassState.getType());
                }
            }
            inheritanceStatePerClass.put(clazz, state);
        }
        return inheritanceStatePerClass;
    }

    private static boolean hasAnnotationsOnIdClass(XClass idClass) {
        List<XProperty> properties = idClass.getDeclaredProperties("field");
        for (XProperty property : properties) {
            if (!property.isAnnotationPresent(javax.persistence.Column.class) && !property.isAnnotationPresent(OneToMany.class) && !property.isAnnotationPresent(ManyToOne.class) && !property.isAnnotationPresent(Id.class) && !property.isAnnotationPresent(GeneratedValue.class) && !property.isAnnotationPresent(OneToOne.class) && !property.isAnnotationPresent(ManyToMany.class)) continue;
            return true;
        }
        List<XMethod> methods = idClass.getDeclaredMethods();
        for (XMethod method : methods) {
            if (!method.isAnnotationPresent(javax.persistence.Column.class) && !method.isAnnotationPresent(OneToMany.class) && !method.isAnnotationPresent(ManyToOne.class) && !method.isAnnotationPresent(Id.class) && !method.isAnnotationPresent(GeneratedValue.class) && !method.isAnnotationPresent(OneToOne.class) && !method.isAnnotationPresent(ManyToMany.class)) continue;
            return true;
        }
        return false;
    }

    private static class LocalCacheAnnotationImpl
    implements Cache {
        private final String region;
        private final CacheConcurrencyStrategy usage;

        private LocalCacheAnnotationImpl(String region, CacheConcurrencyStrategy usage) {
            this.region = region;
            this.usage = usage;
        }

        @Override
        public CacheConcurrencyStrategy usage() {
            return this.usage;
        }

        @Override
        public String region() {
            return this.region;
        }

        @Override
        public String include() {
            return "all";
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return Cache.class;
        }
    }
}

