/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.internal.ast.exec;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.hql.internal.ast.HqlSqlWalker;
import org.hibernate.hql.internal.ast.exec.AbstractStatementExecutor;
import org.hibernate.hql.internal.ast.tree.DeleteStatement;
import org.hibernate.hql.internal.ast.tree.FromElement;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.param.ParameterSpecification;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.sql.Delete;
import org.jboss.logging.Logger;

public class MultiTableDeleteExecutor
extends AbstractStatementExecutor {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, MultiTableDeleteExecutor.class.getName());
    private final Queryable persister;
    private final String idInsertSelect;
    private final String[] deletes;

    public MultiTableDeleteExecutor(HqlSqlWalker walker) {
        super(walker, null);
        if (!walker.getSessionFactoryHelper().getFactory().getDialect().supportsTemporaryTables()) {
            throw new HibernateException("cannot doAfterTransactionCompletion multi-table deletes using dialect not supporting temp tables");
        }
        DeleteStatement deleteStatement = (DeleteStatement)walker.getAST();
        FromElement fromElement = deleteStatement.getFromClause().getFromElement();
        String bulkTargetAlias = fromElement.getTableAlias();
        this.persister = fromElement.getQueryable();
        this.idInsertSelect = this.generateIdInsertSelect(this.persister, bulkTargetAlias, deleteStatement.getWhereClause());
        LOG.tracev("Generated ID-INSERT-SELECT SQL (multi-table delete) : {0}", (Object)this.idInsertSelect);
        String[] tableNames = this.persister.getConstraintOrderedTableNameClosure();
        String[][] columnNames = this.persister.getContraintOrderedTableKeyColumnClosure();
        String idSubselect = this.generateIdSubselect(this.persister);
        this.deletes = new String[tableNames.length];
        for (int i = tableNames.length - 1; i >= 0; --i) {
            Delete delete = new Delete().setTableName(tableNames[i]).setWhere("(" + StringHelper.join(", ", columnNames[i]) + ") IN (" + idSubselect + ")");
            if (this.getFactory().getSettings().isCommentsEnabled()) {
                delete.setComment("bulk delete");
            }
            this.deletes[i] = delete.toStatementString();
        }
    }

    @Override
    public String[] getSqlStatements() {
        return this.deletes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute(QueryParameters parameters, SessionImplementor session) throws HibernateException {
        this.coordinateSharedCacheCleanup(session);
        this.createTemporaryTableIfNecessary(this.persister, session);
        try {
            Statement ps = null;
            int resultCount = 0;
            try {
                try {
                    ps = session.getTransactionCoordinator().getJdbcCoordinator().getStatementPreparer().prepareStatement(this.idInsertSelect, false);
                    Iterator paramSpecifications = this.getIdSelectParameterSpecifications().iterator();
                    int pos = 1;
                    while (paramSpecifications.hasNext()) {
                        ParameterSpecification paramSpec = (ParameterSpecification)paramSpecifications.next();
                        pos += paramSpec.bind((PreparedStatement)ps, parameters, session, pos);
                    }
                    resultCount = ps.executeUpdate();
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (SQLException e) {
                throw this.getFactory().getSQLExceptionHelper().convert(e, "could not insert/select ids for bulk delete", this.idInsertSelect);
            }
            for (int i = 0; i < this.deletes.length; ++i) {
                try {
                    try {
                        ps = session.getTransactionCoordinator().getJdbcCoordinator().getStatementPreparer().prepareStatement(this.deletes[i], false);
                        ps.executeUpdate();
                        continue;
                    }
                    finally {
                        if (ps != null) {
                            ps.close();
                        }
                    }
                }
                catch (SQLException e) {
                    throw this.getFactory().getSQLExceptionHelper().convert(e, "error performing bulk delete", this.deletes[i]);
                }
            }
            int n = resultCount;
            return n;
        }
        finally {
            this.dropTemporaryTableIfNecessary(this.persister, session);
        }
    }

    @Override
    protected Queryable[] getAffectedQueryables() {
        return new Queryable[]{this.persister};
    }
}

