/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property.basic;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import net.jcip.annotations.Immutable;
import org.modeshape.common.text.TextDecoder;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.property.Binary;
import org.modeshape.graph.property.DateTime;
import org.modeshape.graph.property.IoException;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PropertyType;
import org.modeshape.graph.property.Reference;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.property.ValueFormatException;
import org.modeshape.graph.property.basic.AbstractValueFactory;

@Immutable
public class DecimalValueFactory
extends AbstractValueFactory<BigDecimal> {
    public DecimalValueFactory(TextDecoder decoder, ValueFactory<String> stringValueFactory) {
        super(PropertyType.DECIMAL, decoder, stringValueFactory);
    }

    @Override
    public BigDecimal create(String value) {
        if (value == null) {
            return null;
        }
        try {
            return new BigDecimal(value.trim());
        }
        catch (NumberFormatException err) {
            throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.errorConvertingType.text(String.class.getSimpleName(), BigDecimal.class.getSimpleName(), value), err);
        }
    }

    @Override
    public BigDecimal create(String value, TextDecoder decoder) {
        return this.create(this.getDecoder(decoder).decode(value.trim()));
    }

    @Override
    public BigDecimal create(int value) {
        return BigDecimal.valueOf(value);
    }

    @Override
    public BigDecimal create(long value) {
        return BigDecimal.valueOf(value);
    }

    @Override
    public BigDecimal create(boolean value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(this.getPropertyType().getName(), Boolean.class.getSimpleName(), value));
    }

    @Override
    public BigDecimal create(float value) {
        return BigDecimal.valueOf(value);
    }

    @Override
    public BigDecimal create(double value) {
        return BigDecimal.valueOf(value);
    }

    @Override
    public BigDecimal create(BigDecimal value) {
        return value;
    }

    @Override
    public BigDecimal create(Calendar value) {
        if (value == null) {
            return null;
        }
        return this.create(value.getTimeInMillis());
    }

    @Override
    public BigDecimal create(Date value) {
        if (value == null) {
            return null;
        }
        return this.create(value.getTime());
    }

    @Override
    public BigDecimal create(DateTime value) throws ValueFormatException {
        if (value == null) {
            return null;
        }
        return this.create(value.getMilliseconds());
    }

    @Override
    public BigDecimal create(Name value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(this.getPropertyType().getName(), Name.class.getSimpleName(), value));
    }

    @Override
    public BigDecimal create(Path value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(this.getPropertyType().getName(), Path.class.getSimpleName(), value));
    }

    @Override
    public BigDecimal create(Path.Segment value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(this.getPropertyType().getName(), Path.Segment.class.getSimpleName(), value));
    }

    @Override
    public BigDecimal create(Reference value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(this.getPropertyType().getName(), Reference.class.getSimpleName(), value));
    }

    @Override
    public BigDecimal create(URI value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(this.getPropertyType().getName(), URI.class.getSimpleName(), value));
    }

    @Override
    public BigDecimal create(UUID value) throws IoException {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(this.getPropertyType().getName(), UUID.class.getSimpleName(), value));
    }

    @Override
    public BigDecimal create(byte[] value) {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public BigDecimal create(Binary value) throws ValueFormatException, IoException {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public BigDecimal create(InputStream stream, long approximateLength) throws IoException {
        return this.create(this.getStringValueFactory().create(stream, approximateLength));
    }

    @Override
    public BigDecimal create(Reader reader, long approximateLength) throws IoException {
        return this.create(this.getStringValueFactory().create(reader, approximateLength));
    }

    protected BigDecimal[] createEmptyArray(int length) {
        return new BigDecimal[length];
    }
}

