/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.request;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import net.jcip.annotations.NotThreadSafe;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.Location;
import org.modeshape.graph.NodeConflictBehavior;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.request.CloneBranchRequest;
import org.modeshape.graph.request.CloneWorkspaceRequest;
import org.modeshape.graph.request.CompositeRequest;
import org.modeshape.graph.request.CopyBranchRequest;
import org.modeshape.graph.request.CreateNodeRequest;
import org.modeshape.graph.request.CreateWorkspaceRequest;
import org.modeshape.graph.request.DeleteBranchRequest;
import org.modeshape.graph.request.DestroyWorkspaceRequest;
import org.modeshape.graph.request.GetWorkspacesRequest;
import org.modeshape.graph.request.MoveBranchRequest;
import org.modeshape.graph.request.ReadAllChildrenRequest;
import org.modeshape.graph.request.ReadAllPropertiesRequest;
import org.modeshape.graph.request.ReadBlockOfChildrenRequest;
import org.modeshape.graph.request.ReadBranchRequest;
import org.modeshape.graph.request.ReadNextBlockOfChildrenRequest;
import org.modeshape.graph.request.ReadNodeRequest;
import org.modeshape.graph.request.ReadPropertyRequest;
import org.modeshape.graph.request.RemovePropertyRequest;
import org.modeshape.graph.request.RenameNodeRequest;
import org.modeshape.graph.request.Request;
import org.modeshape.graph.request.SetPropertyRequest;
import org.modeshape.graph.request.UpdatePropertiesRequest;
import org.modeshape.graph.request.VerifyNodeExistsRequest;
import org.modeshape.graph.request.VerifyWorkspaceRequest;

@NotThreadSafe
public class BatchRequestBuilder {
    private LinkedList<Request> requests;
    private NodeChange pendingRequest;

    public BatchRequestBuilder() {
        this.requests = new LinkedList();
    }

    public BatchRequestBuilder(LinkedList<Request> requests) {
        this.requests = requests != null ? requests : new LinkedList();
    }

    public boolean hasRequests() {
        return this.pendingRequest != null || !this.requests.isEmpty();
    }

    public void finishPendingRequest() {
        if (this.pendingRequest != null) {
            this.add(this.pendingRequest.toRequest());
            this.pendingRequest = null;
        }
    }

    public Request pop() {
        int number = this.requests.size();
        if (this.pendingRequest != null) {
            Request newRequest = this.pendingRequest.toRequest();
            if (number == 0) {
                return newRequest;
            }
            this.addPending();
            ++number;
        } else {
            if (number == 0) {
                return null;
            }
            if (number == 1) {
                Request result = this.requests.getFirst();
                this.requests.clear();
                return result;
            }
        }
        assert (number >= 2);
        Request result = CompositeRequest.with(this.requests);
        this.requests = new LinkedList();
        return result;
    }

    protected final BatchRequestBuilder add(Request request) {
        this.addPending();
        this.requests.add(request);
        return this;
    }

    protected final BatchRequestBuilder addPending() {
        if (this.pendingRequest != null) {
            this.requests.add(this.pendingRequest.toRequest());
            this.pendingRequest = null;
        }
        return this;
    }

    public BatchRequestBuilder getWorkspaces() {
        return this.add(new GetWorkspacesRequest());
    }

    public BatchRequestBuilder verifyWorkspace(String workspaceName) {
        return this.add(new VerifyWorkspaceRequest(workspaceName));
    }

    public BatchRequestBuilder createWorkspace(String desiredNameOfNewWorkspace, CreateWorkspaceRequest.CreateConflictBehavior createConflictBehavior) {
        return this.add(new CreateWorkspaceRequest(desiredNameOfNewWorkspace, createConflictBehavior));
    }

    public BatchRequestBuilder cloneWorkspace(String nameOfWorkspaceToBeCloned, String desiredNameOfTargetWorkspace, CreateWorkspaceRequest.CreateConflictBehavior createConflictBehavior, CloneWorkspaceRequest.CloneConflictBehavior cloneConflictBehavior) {
        return this.add(new CloneWorkspaceRequest(nameOfWorkspaceToBeCloned, desiredNameOfTargetWorkspace, createConflictBehavior, cloneConflictBehavior));
    }

    public BatchRequestBuilder destroyWorkspace(String workspaceName) {
        return this.add(new DestroyWorkspaceRequest(workspaceName));
    }

    public BatchRequestBuilder verifyNodeExists(Location at, String workspaceName) {
        return this.add(new VerifyNodeExistsRequest(at, workspaceName));
    }

    public BatchRequestBuilder readNode(Location at, String workspaceName) {
        return this.add(new ReadNodeRequest(at, workspaceName));
    }

    public BatchRequestBuilder readAllChildren(Location of, String workspaceName) {
        return this.add(new ReadAllChildrenRequest(of, workspaceName));
    }

    public BatchRequestBuilder readAllProperties(Location of, String workspaceName) {
        return this.add(new ReadAllPropertiesRequest(of, workspaceName));
    }

    public BatchRequestBuilder readProperty(Location of, String workspaceName, Name propertyName) {
        return this.add(new ReadPropertyRequest(of, workspaceName, propertyName));
    }

    public BatchRequestBuilder readBranch(Location at, String workspaceName) {
        return this.add(new ReadBranchRequest(at, workspaceName));
    }

    public BatchRequestBuilder readBranch(Location at, String workspaceName, int maxDepth) {
        return this.add(new ReadBranchRequest(at, workspaceName, maxDepth));
    }

    public BatchRequestBuilder readBlockOfChildren(Location of, String workspaceName, int startingIndex, int count) {
        return this.add(new ReadBlockOfChildrenRequest(of, workspaceName, startingIndex, count));
    }

    public BatchRequestBuilder readNextBlockOfChildren(Location startingAfter, String workspaceName, int count) {
        return this.add(new ReadNextBlockOfChildrenRequest(startingAfter, workspaceName, count));
    }

    public BatchRequestBuilder createNode(Location parentLocation, String workspaceName, Name childName, Iterator<Property> properties) {
        return this.add(new CreateNodeRequest(parentLocation, workspaceName, childName, CreateNodeRequest.DEFAULT_CONFLICT_BEHAVIOR, properties));
    }

    public BatchRequestBuilder createNode(Location parentLocation, String workspaceName, Name childName, Iterator<Property> properties, NodeConflictBehavior conflictBehavior) {
        if (conflictBehavior == null) {
            conflictBehavior = CreateNodeRequest.DEFAULT_CONFLICT_BEHAVIOR;
        }
        return this.add(new CreateNodeRequest(parentLocation, workspaceName, childName, conflictBehavior, properties));
    }

    public BatchRequestBuilder createNode(Location parentLocation, String workspaceName, Name childName, Property[] properties) {
        return this.add(new CreateNodeRequest(parentLocation, workspaceName, childName, CreateNodeRequest.DEFAULT_CONFLICT_BEHAVIOR, properties));
    }

    public BatchRequestBuilder createNode(Location parentLocation, String workspaceName, Name childName, Property[] properties, NodeConflictBehavior conflictBehavior) {
        if (conflictBehavior == null) {
            conflictBehavior = CreateNodeRequest.DEFAULT_CONFLICT_BEHAVIOR;
        }
        return this.add(new CreateNodeRequest(parentLocation, workspaceName, childName, conflictBehavior, properties));
    }

    public BatchRequestBuilder setProperty(Location on, String workspaceName, Property property) {
        if (this.pendingRequest != null) {
            if (this.pendingRequest.location.isSame(on)) {
                this.pendingRequest.pendingProperties.put(property.getName(), property);
                return this;
            }
            this.addPending();
        }
        this.pendingRequest = new NodeChange(on, workspaceName);
        this.pendingRequest.pendingProperties.put(property.getName(), property);
        return this;
    }

    public BatchRequestBuilder setProperties(Location on, String workspaceName, Property ... properties) {
        if (this.pendingRequest != null) {
            if (this.pendingRequest.location.isSame(on)) {
                for (Property property : properties) {
                    this.pendingRequest.pendingProperties.put(property.getName(), property);
                }
                return this;
            }
            this.addPending();
        }
        this.pendingRequest = new NodeChange(on, workspaceName);
        for (Property property : properties) {
            if (property == null) continue;
            this.pendingRequest.pendingProperties.put(property.getName(), property);
        }
        return this;
    }

    public BatchRequestBuilder removeProperty(Location on, String workspaceName, Name propertyName) {
        if (this.pendingRequest != null) {
            if (this.pendingRequest.location.isSame(on)) {
                this.pendingRequest.pendingProperties.put(propertyName, null);
                return this;
            }
            this.addPending();
        }
        this.pendingRequest = new NodeChange(on, workspaceName);
        this.pendingRequest.pendingProperties.put(propertyName, null);
        return this;
    }

    public BatchRequestBuilder removeProperties(Location on, String workspaceName, Name ... propertyNames) {
        if (this.pendingRequest != null) {
            if (this.pendingRequest.location.isSame(on)) {
                for (Name propertyName : propertyNames) {
                    this.pendingRequest.pendingProperties.put(propertyName, null);
                }
                return this;
            }
            this.addPending();
        }
        this.pendingRequest = new NodeChange(on, workspaceName);
        for (Name propertyName : propertyNames) {
            this.pendingRequest.pendingProperties.put(propertyName, null);
        }
        return this;
    }

    public BatchRequestBuilder renameNode(Location at, String workspaceName, Name newName) {
        return this.add(new RenameNodeRequest(at, workspaceName, newName));
    }

    public BatchRequestBuilder copyBranch(Location from, String fromWorkspace, Location into, String intoWorkspace, Name nameForCopy) {
        return this.add(new CopyBranchRequest(from, fromWorkspace, into, intoWorkspace, nameForCopy, CopyBranchRequest.DEFAULT_NODE_CONFLICT_BEHAVIOR));
    }

    public BatchRequestBuilder copyBranch(Location from, String fromWorkspace, Location into, String intoWorkspace, Name nameForCopy, NodeConflictBehavior conflictBehavior) {
        if (conflictBehavior == null) {
            conflictBehavior = CopyBranchRequest.DEFAULT_NODE_CONFLICT_BEHAVIOR;
        }
        return this.add(new CopyBranchRequest(from, fromWorkspace, into, intoWorkspace, nameForCopy, conflictBehavior));
    }

    public BatchRequestBuilder cloneBranch(Location from, String fromWorkspace, Location into, String intoWorkspace, Name nameForClone, Path.Segment exactSegmentForClone, boolean removeExisting) {
        return this.add(new CloneBranchRequest(from, fromWorkspace, into, intoWorkspace, nameForClone, exactSegmentForClone, removeExisting));
    }

    public BatchRequestBuilder moveBranch(Location from, Location into, String workspaceName) {
        return this.add(new MoveBranchRequest(from, into, workspaceName, MoveBranchRequest.DEFAULT_CONFLICT_BEHAVIOR));
    }

    public BatchRequestBuilder moveBranch(Location from, Location into, String workspaceName, Name newNameForNode) {
        return this.add(new MoveBranchRequest(from, into, null, workspaceName, newNameForNode, MoveBranchRequest.DEFAULT_CONFLICT_BEHAVIOR));
    }

    public BatchRequestBuilder moveBranch(Location from, Location into, Location before, String workspaceName, Name newNameForNode) {
        return this.add(new MoveBranchRequest(from, into, before, workspaceName, newNameForNode, MoveBranchRequest.DEFAULT_CONFLICT_BEHAVIOR));
    }

    public BatchRequestBuilder moveBranch(Location from, Location into, String workspaceName, NodeConflictBehavior conflictBehavior) {
        if (conflictBehavior == null) {
            conflictBehavior = MoveBranchRequest.DEFAULT_CONFLICT_BEHAVIOR;
        }
        return this.add(new MoveBranchRequest(from, into, workspaceName, conflictBehavior));
    }

    public BatchRequestBuilder deleteBranch(Location at, String workspaceName) {
        return this.add(new DeleteBranchRequest(at, workspaceName));
    }

    public BatchRequestBuilder submit(Request request) {
        CheckArg.isNotNull(request, "request");
        return this.add(request);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Request request : this.requests) {
            sb.append(request.toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    protected class NodeChange {
        protected final Location location;
        protected final String workspaceName;
        protected final Map<Name, Property> pendingProperties = new HashMap<Name, Property>();

        protected NodeChange(Location location, String workspaceName) {
            this.location = location;
            this.workspaceName = workspaceName;
        }

        protected Request toRequest() {
            if (this.pendingProperties.size() == 1) {
                Map.Entry<Name, Property> entry = this.pendingProperties.entrySet().iterator().next();
                Property property = entry.getValue();
                if (property == null) {
                    return new RemovePropertyRequest(this.location, this.workspaceName, entry.getKey());
                }
                return new SetPropertyRequest(this.location, this.workspaceName, property);
            }
            return new UpdatePropertiesRequest(this.location, this.workspaceName, this.pendingProperties);
        }
    }
}

