DELIMITER $$

DROP PROCEDURE IF EXISTS CreateForEmployeeFamilyDetail $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE CreateForEmployeeFamilyDetail()

BEGIN
  
  -- Add the email table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='employee_family_detail_history' )) THEN
    
	-- CREATE STATEMENT 
	CREATE TABLE `employee_family_detail_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `employeeId` bigint(20) DEFAULT NULL,
  `personId` bigint(20) DEFAULT NULL,
  `relationship` varchar(20) DEFAULT NULL,
  `salutationId` bigint(20) DEFAULT NULL,
  `whetherDeleted` bit(1) NOT NULL DEFAULT b'0',
  `firstName` varchar(255) DEFAULT NULL,
  `middleName` varchar(255) DEFAULT NULL,
  `lastName` varchar(255) DEFAULT NULL,
  `printName` varchar(255) DEFAULT NULL,
  `birthDate` date DEFAULT NULL,
  `genderId` bigint(20) DEFAULT NULL,
  `emailId` varchar(100) DEFAULT NULL,
  `alternateEmailId` varchar(100) DEFAULT NULL,
  `maritalStatus` varchar(20) DEFAULT NULL,
  `personalIncome` decimal(18,2) DEFAULT NULL,
  `bloodGroup` varchar(20) DEFAULT NULL,
  `vehicleLicenseNo` varchar(50) DEFAULT NULL,
  `awardRecived` varchar(100) DEFAULT NULL,
  `whetherUserOfOrganization` bit(1) DEFAULT NULL,
  `isMobUseForCommunication` bit(1) DEFAULT b'1',
  `mobileCountryCode` varchar(10) DEFAULT NULL,
  `mobileNumber` varchar(15) DEFAULT NULL,
  `isAlternateMobUseForCommunication` bit(1) DEFAULT b'1',
  `alternateMobileCountryCode` varchar(15) DEFAULT NULL,
  `alternateMobileNo` varchar(15) DEFAULT NULL,
  `isPhoneUseForCommunication` bit(1) DEFAULT b'1',
  `phoneCountryCode` varchar(10) DEFAULT NULL,
  `phoneAreaCode` varchar(11) DEFAULT NULL,
  `phoneNo` varchar(15) DEFAULT NULL,
  `highestEducation` varchar(150) DEFAULT NULL,
  `yearOfExam` date DEFAULT NULL,
  `occupation` varchar(100) DEFAULT NULL,
  `companyName` varchar(255) DEFAULT NULL,
  `designation` varchar(45) DEFAULT NULL,
  `yearOfExperience` float DEFAULT NULL,
  `isEmergencyContact` bit(1) DEFAULT b'1',
  `photoUrl` varchar(255) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


  END IF;

END $$

-- Execute the stored procedure
CALL CreateForEmployeeFamilyDetail $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS CreateForEmployeeFamilyDetail $$
 
DELIMITER ;