DELIMITER $$

DROP PROCEDURE IF EXISTS V20200629203850__CreateAuditEconomicInformation $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V20200629203850__CreateAuditEconomicInformation()
BEGIN
  
  -- Add the email table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='economic_information_history' )) THEN
    
	CREATE TABLE `economic_information_history` (
	  `id` bigint(20) NOT NULL AUTO_INCREMENT,
	  `REV` int(11) NOT NULL,
	  `REVTYPE` tinyint(4) DEFAULT NULL,
	  `person_Id` bigint(20) DEFAULT NULL,
	  `applicant_person_id` bigint(20) DEFAULT NULL,
	  `parent_qualification1` VARCHAR(50) DEFAULT NULL,
	  `parent_qualification2` VARCHAR(50) DEFAULT NULL,
	  `school_fee_per_year` VARCHAR(50) DEFAULT NULL,
	  `is_scholarship` VARCHAR(50) DEFAULT NULL,
	  `received_child_benefit` VARCHAR(50) DEFAULT NULL,
	  `social_pension` VARCHAR(50) DEFAULT NULL,
	  `pay_study` VARCHAR(50) DEFAULT NULL,
	  `NSFAS_holder` BIT(1) DEFAULT NULL,
	  `parent_annual_income` VARCHAR(50) DEFAULT NULL,
	  `parent_occupation` VARCHAR(50) DEFAULT NULL,
	  `employer` VARCHAR(50) DEFAULT NULL,
	  `lastUpdatedBy` bigint(20) NOT NULL,
	  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
	  PRIMARY KEY (`id`,`REV`)
	);
	
  END IF ;

END $$

-- Execute the stored procedure
CALL V20200629203850__CreateAuditEconomicInformation $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V20200629203850__CreateAuditEconomicInformation $$
 
DELIMITER ;
