DELIMITER $$

DROP PROCEDURE IF EXISTS V20210120154931__Create_WMSFileInfoAudit $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V20210120154931__Create_WMSFileInfoAudit()
BEGIN
  
  -- Add the email table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='wms_file_info_history' )) THEN
    
    CREATE TABLE `wms_file_info_history` (
      `id` bigint(20) NOT NULL,
      `REV` int(11) NOT NULL,
      `REVTYPE` tinyint(4) DEFAULT NULL,
      `filePath` varchar(255) NULL DEFAULT NULL,
      `sentDate` timestamp NULL DEFAULT NULL,
      `sentToWMSStatus` bit(1) NULL DEFAULT NULL,
      `typeOfFile` varchar(50) NULL DEFAULT NULL,
      PRIMARY KEY (`id`,`REV`)
    );
    
  END IF ;

END $$

-- Execute the stored procedure
CALL V20210120154931__Create_WMSFileInfoAudit $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V20210120154931__Create_WMSFileInfoAudit $$
 
DELIMITER ;