DELIMITER $$
DROP PROCEDURE IF EXISTS V20250520190429__Alter_ProgramWithdrawlMultipleReasonHis $$
CREATE PROCEDURE V20250520190429__Alter_ProgramWithdrawlMultipleReasonHis()
BEGIN

IF NOT EXISTS (
    SELECT * 
    FROM information_schema.COLUMNS 
    WHERE TABLE_SCHEMA = DATABASE() 
      AND TABLE_NAME = 'program_withdrawl_request_multiple_reason_history' 
      AND COLUMN_NAME = 'programWithdrawalReasonCsmId'
) THEN
    ALTER TABLE program_withdrawl_request_multiple_reason_history
    ADD COLUMN programWithdrawalReasonCsmId BIGINT DEFAULT NULL;
END IF;

SET SQL_SAFE_UPDATES=0;
UPDATE program_withdrawl_request_multiple_reason_history AS pwrmr
JOIN program_withdrawl_request_multiple_reason_history AS pwrmrself
ON pwrmrself.programWithdrawlRequestDetailId = pwrmr.programWithdrawlRequestDetailId
SET pwrmr.programWithdrawalReasonCsmId = pwrmrself.programWithdrawlReasonId;
SET SQL_SAFE_UPDATES=1;

END $$
CALL V20250520190429__Alter_ProgramWithdrawlMultipleReasonHis() $$
DROP PROCEDURE IF EXISTS V20250520190429__Alter_ProgramWithdrawlMultipleReasonHis $$
DELIMITER ;