DELIMITER $$
DROP PROCEDURE IF EXISTS V20250625152311__Alter_ExamTransferCreditUpdateHistory $$
CREATE PROCEDURE V20250625152311__Alter_ExamTransferCreditUpdateHistory()
BEGIN

IF EXISTS (
    SELECT * 
    FROM information_schema.COLUMNS 
    WHERE TABLE_NAME = 'exam_transfer_credit_history' 
      AND table_schema=DATABASE()
      AND COLUMN_NAME = 'currentGrade'
  ) THEN
    ALTER TABLE exam_transfer_credit_history 
      CHANGE currentGrade marksGrade VARCHAR(30) DEFAULT NULL after examTransferType;
  END IF;

  -- Rename 'currentMarks' to 'gradePoint' if it exists
  IF EXISTS (
    SELECT * 
    FROM information_schema.COLUMNS 
    WHERE TABLE_NAME = 'exam_transfer_credit_history' 
      AND table_schema=DATABASE()
      AND COLUMN_NAME = 'currentMarks'
  ) THEN
    ALTER TABLE exam_transfer_credit_history 
      CHANGE currentMarks gradePoint DOUBLE DEFAULT NULL after examTransferType;
  END IF;

  -- Add 'courseGradeType' if it doesn't already exist
  IF NOT EXISTS (
    SELECT * 
    FROM information_schema.COLUMNS 
    WHERE TABLE_NAME = 'exam_transfer_credit_history' 
      AND table_schema=DATABASE()
      AND COLUMN_NAME = 'courseGradeType'
  ) THEN
    ALTER TABLE exam_transfer_credit_history 
      ADD COLUMN courseGradeType VARCHAR(50) DEFAULT NULL after examTransferType;
  END IF;
  
END $$
CALL V20250625152311__Alter_ExamTransferCreditUpdateHistory() $$
DROP PROCEDURE IF EXISTS V20250625152311__Alter_ExamTransferCreditUpdateHistory $$
DELIMITER ;