ALTER TABLE `documents`
	CHANGE COLUMN `documentName` `name` VARCHAR(255) NULL DEFAULT NULL,
	ADD COLUMN `path` VARCHAR(255) NULL DEFAULT NULL,
	ADD COLUMN `status` VARCHAR(50) NULL DEFAULT NULL,
	ADD COLUMN `submissionDate` TIMESTAMP NULL DEFAULT NULL,
	ADD COLUMN `createdBy` BIGINT(20) NULL DEFAULT NULL,
	DROP COLUMN `documentType`;


CREATE TABLE `extended_documents` (
	`inspectionDate` DATE NULL DEFAULT NULL,
	`isElectronic` TINYINT(1) NULL DEFAULT NULL,
	`isInspectionDone` TINYINT(1) NULL DEFAULT NULL,
	`isInspectionRequired` TINYINT(1) NULL DEFAULT NULL,
	`isReturnable` TINYINT(1) NULL DEFAULT NULL,
	`modeOfReturn` VARCHAR(255) NULL DEFAULT NULL,
	`modeOfSubmission` VARCHAR(255) NULL DEFAULT NULL,
	`returnedDate` DATETIME NULL DEFAULT NULL,
	`returnedToName` VARCHAR(255) NULL DEFAULT NULL,
	`validTillDate` DATETIME NULL DEFAULT NULL,
	`documentId` BIGINT(20) NOT NULL,
	`inspectionDoneBy` BIGINT(20) NULL DEFAULT NULL,
	`responsibleUserId` BIGINT(20) NULL DEFAULT NULL,
	`returnedBy` BIGINT(20) NULL DEFAULT NULL,
	`returnedToUserId` BIGINT(20) NULL DEFAULT NULL,
	PRIMARY KEY (`documentId`)
);

CREATE TABLE `student_documents` (
	`documentId` BIGINT(20) NOT NULL,
	`studentId` BIGINT(20) NOT NULL,
	PRIMARY KEY (`documentId`)
);
	
CREATE TABLE `faculty_documents` (
	`documentId` BIGINT(20) NOT NULL,
	`facultyId` BIGINT(20) NOT NULL,
	PRIMARY KEY (`documentId`)
);

DROP TABLE IF EXISTS `service_request_documents`;
CREATE TABLE `service_request_documents` (
	`documentId` BIGINT(20) NOT NULL,
	`serviceRequestId` BIGINT(20) NOT NULL,
	PRIMARY KEY (`documentId`)
);



--------------

ALTER TABLE documents ADD CONSTRAINT FK_users_createdBy 
    FOREIGN KEY (createdBy)
    REFERENCES users(id);
	
ALTER TABLE extended_documents ADD CONSTRAINT FK_users_returnedToUserId 
    FOREIGN KEY (returnedToUserId)
    REFERENCES users(id);
ALTER TABLE extended_documents ADD CONSTRAINT FK_users_responsibleUserId 
    FOREIGN KEY (responsibleUserId)
    REFERENCES users(id);
ALTER TABLE extended_documents ADD CONSTRAINT FK_users_returnedBy 
    FOREIGN KEY (returnedBy)
    REFERENCES users(id);
ALTER TABLE extended_documents ADD CONSTRAINT FK_users_inspectionDoneBy 
    FOREIGN KEY (inspectionDoneBy)
    REFERENCES users(id);
ALTER TABLE extended_documents ADD CONSTRAINT FK_users_documentId 
    FOREIGN KEY (documentId)
    REFERENCES documents(id);	

ALTER TABLE student_documents ADD CONSTRAINT FK_students_studentId 
    FOREIGN KEY (studentId)
    REFERENCES students(personId);
ALTER TABLE student_documents ADD CONSTRAINT FK_extended_documents_documentId 
    FOREIGN KEY (documentId)
    REFERENCES extended_documents(documentId);	

ALTER TABLE faculty_documents ADD CONSTRAINT FK_faculties_facultyId 
    FOREIGN KEY (facultyId)
    REFERENCES faculties(personId);
ALTER TABLE faculty_documents ADD CONSTRAINT FK_faculty_documents_extended_documents 
	FOREIGN KEY (documentId) 
	REFERENCES extended_documents (documentId);	

ALTER TABLE service_request_documents ADD CONSTRAINT FK_service_requests_id 
    FOREIGN KEY (serviceRequestId)
    REFERENCES service_requests(id);
ALTER TABLE service_request_documents ADD CONSTRAINT FK_service_request_documents_documentId 
    FOREIGN KEY (documentId)
    REFERENCES extended_documents(documentId);	
	