ALTER TABLE `bill_header` 
ADD COLUMN `defaultIAU` BIGINT(20) NULL DEFAULT NULL AFTER `scholarshipId`,
ADD INDEX `RefIAU12534_idx` (`defaultIAU` ASC);
ALTER TABLE `bill_header` 
ADD CONSTRAINT `RefIAU12534`
  FOREIGN KEY (`defaultIAU`)
  REFERENCES `organization_units` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;

ALTER TABLE `receipt_header` 
ADD COLUMN `defaultIAU` BIGINT(20) NULL DEFAULT NULL AFTER `scholarshipId`,
ADD INDEX `RefIAU4232_idx` (`defaultIAU` ASC);
ALTER TABLE `receipt_header` 
ADD CONSTRAINT `RefIAU4232`
  FOREIGN KEY (`defaultIAU`)
  REFERENCES `organization_units` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;


ALTER TABLE `payment_header` 
ADD COLUMN `defaultIAU` BIGINT(20) NULL DEFAULT NULL AFTER `paymentCash`,
ADD INDEX `RefIAU432_idx` (`defaultIAU` ASC);
ALTER TABLE `payment_header` 
ADD CONSTRAINT `RefIAU432`
  FOREIGN KEY (`defaultIAU`)
  REFERENCES `organization_units` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;

ALTER TABLE `users` 
ADD COLUMN `accountingKey` VARCHAR(255) NULL DEFAULT NULL AFTER `categoryField5`;

CREATE TABLE `bill_voucher` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `billId` BIGINT(20) NOT NULL,
  `voucherId` BIGINT(20) NOT NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `RefUser1254_idx` (`lastUpdatedBy` ASC),
  INDEX `RefBillHeader553_idx` (`billId` ASC),
  INDEX `RefVoucher4245_idx` (`voucherId` ASC),
  CONSTRAINT `RefUser1254`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `RefBillHeader553`
    FOREIGN KEY (`billId`)
    REFERENCES `bill_header` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `RefVoucher4245`
    FOREIGN KEY (`voucherId`)
    REFERENCES `voucher` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);


CREATE TABLE `receipt_voucher` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `receiptHeaderId` BIGINT(20) NOT NULL,
  `voucherId` BIGINT(20) NOT NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `RefUsres552_idx` (`lastUpdatedBy` ASC),
  INDEX `RefReceiptHeader52_idx` (`receiptHeaderId` ASC),
  INDEX `RefVoucher673_idx` (`voucherId` ASC),
  CONSTRAINT `RefUsres552`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `RefReceiptHeader52`
    FOREIGN KEY (`receiptHeaderId`)
    REFERENCES `receipt_header` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `RefVoucher673`
    FOREIGN KEY (`voucherId`)
    REFERENCES `voucher` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);


CREATE TABLE `payment_voucher` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `paymentHeaderId` BIGINT(20) NOT NULL,
  `voucherId` BIGINT(20) NOT NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `RefPaymentHeader542_idx` (`paymentHeaderId` ASC),
  INDEX `RefUsres452_idx` (`lastUpdatedBy` ASC),
  INDEX `RefVoucher1234_idx` (`voucherId` ASC),
  CONSTRAINT `RefUsres452`
  FOREIGN KEY (`lastUpdatedBy`)
  REFERENCES `users` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION,
  CONSTRAINT `RefPaymentHeader542`
  FOREIGN KEY (`paymentHeaderId`)
  REFERENCES `payment_header` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION,
  CONSTRAINT `RefVoucher1234`
  FOREIGN KEY (`voucherId`)
  REFERENCES `voucher` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION);