
-- Script to get applicant father name
INSERT INTO `dydt_data_line_item` (`dataProviderId`, `dataSourceCode`, `executionOrder`, `whetherDataSource`, `whetherPrimaryDataSource`, `sqlSelectQueryDef`, `whereClauseBindingDef`, `resultColumnsDef`, `sqlWhereQueryDef`, `whetherMultiRecord`) VALUES ('3', 'APPLICANT_FATHER_NAME', '11', '1', '0', 'select apf.printName as father_name from applicant_person_relationships as apr\ninner join applicant_person as ap on apr.applicantPersonId = ap.id\ninner join applicant_person as apf on apr.relatedApplicantPersonId = apf.id', 'PRM_APPLICANT_PERSON_ID', 'father_name', 'WHERE ap.id = PRM_APPLICANT_PERSON_ID and apr.relationship=\'FATHER\'', '0');

SET @fatheNameId=(SELECT MAX(id) FROM dydt_data_line_item);

INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`, 
`dataProviderLineItemId`) VALUES ('father_name', 'Father Name', @fatheNameId); 

-- Script to get offer letter expiry date
INSERT INTO `dydt_data_line_item` (`dataProviderId`, `dataSourceCode`, `executionOrder`, `whetherDataSource`, `whetherPrimaryDataSource`, 
`sqlSelectQueryDef`, `whereClauseBindingDef`, `resultColumnsDef`, `sqlWhereQueryDef`, `whetherMultiRecord`) VALUES ('3', 'OFFER_LETTER_EXPIRY_DATE', '12', '1', '0', 'select DATE_FORMAT(DATE_ADD(curdate(), interval pp.offerLetterAcceptDaysLimit day) ,\'%d-%m-%Y\') as offer_exp_date\nfrom prog_slctn_process_admisn_conf as pp\nleft join program_selection_process as psp on pp.programSelectionProcessId=psp.id\nleft join application_program as ap on ap.progBatchSeatConfigId = psp.programBatchSeatConfigId ', 'PRM_APPLICATION_PROGRAM_ID', 'offer_exp_date', 'WHERE ap.id=PRM_APPLICATION_PROGRAM_ID', '0');

SET @offerLetterExpDate=(SELECT MAX(id) FROM dydt_data_line_item);

INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`, `dataProviderLineItemId`)  
 VALUES ('offer_exp_date', 'Offer Letter Expiry Date', @offerLetterExpDate);  

/* script to get batch start date, end date, batch duration */

INSERT INTO `dydt_data_line_item` (`dataProviderId`, `dataSourceCode`, `executionOrder`, `whetherDataSource`, `whetherPrimaryDataSource`, `sqlSelectQueryDef`, `whereClauseBindingDef`, `resultColumnsDef`, `sqlWhereQueryDef`, `whetherMultiRecord`) 
VALUES ('3', 'BATCH_DETAILS', '13', '1', '0', 'select round(datediff(b.tillDate,b.startDate) / 365) as batch_year, \nDATE_FORMAT(b.startDate ,\'%d-%m-%Y\') as batch_start_date,\nif(b.batchPartTime=1, \'Part Time\', \'Full Time\') as batch_study_mode \nfrom application_program as ap\ninner join prog_batch_seat_config as pbsc on ap.progBatchSeatConfigId = pbsc.id\ninner join batches as b on pbsc.programBatchId = b.id', 'PRM_APPLICATION_PROGRAM_ID', 'batch_year, batch_start_date, batch_study_mode', 'WHERE ap.id=PRM_APPLICATION_PROGRAM_ID', '0');

SET @batchyear=(SELECT MAX(id) FROM dydt_data_line_item);

INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`, `dataProviderLineItemId`) VALUES ('batch_year', 'Batch Duration in Year', @batchyear);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`, `dataProviderLineItemId`) VALUES ('batch_start_date', 'Batch Start Date', @batchyear);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`, `dataProviderLineItemId`) VALUES ('batch_study_mode', 'Batch Study Mode', @batchyear);

