CREATE TABLE `trans_service_route` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `routeId` bigint(20) NOT NULL,
  `serviceName` varchar(255) NOT NULL,
  `responsiblePersonId` bigint(20) DEFAULT NULL,
  `responsiblePersonName` varchar(100) DEFAULT NULL,
  `startLocation` bigint(20) DEFAULT NULL,
  `startTime` timestamp NULL DEFAULT NULL,
  `endLocation` bigint(20) DEFAULT NULL,
  `reachTime` timestamp NULL DEFAULT NULL,
  `distance` double(10,2) DEFAULT NULL,
  `whetherActive` bit(1) DEFAULT NULL,
  `routeBillType` varchar(45) DEFAULT NULL,
  `feePlanId` bigint(20) DEFAULT NULL,
  `droolsAgenda` varchar(255) DEFAULT NULL,
  `droolsRuleRemarks` text,
  `timeRecordForStops` bit(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `RefRoute23_idx` (`routeId`),
  KEY `RefResponsiblePerson34_idx` (`responsiblePersonId`),
  KEY `RefStartLocation_idx` (`startLocation`),
  KEY `RefEndLocation23_idx` (`endLocation`),
  KEY `RefFeePlan_idx` (`feePlanId`),
  KEY `RefRouteServiceUpdatedBy_idx` (`lastUpdatedBy`),
  CONSTRAINT `RefEndLocation23` FOREIGN KEY (`endLocation`) REFERENCES `trans_route_location` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `RefFeePlan` FOREIGN KEY (`feePlanId`) REFERENCES `fee_plan` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `RefResponsiblePerson34` FOREIGN KEY (`responsiblePersonId`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `RefRoute23` FOREIGN KEY (`routeId`) REFERENCES `trans_route` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `RefRouteServiceUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `RefStartLocation34` FOREIGN KEY (`startLocation`) REFERENCES `trans_route_location` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `trans_service_route_date_exceptions` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `serviceRouteId` bigint(20) NOT NULL,
  `exceptionDate` date DEFAULT NULL,
  `originalStatus` varchar(45) DEFAULT NULL,
  `revisedStatus` varchar(45) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `RefServiceRoute439_idx` (`serviceRouteId`),
  KEY `RefExceptionUpBy_idx` (`lastUpdatedBy`),
  CONSTRAINT `RefExceptionUpBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `RefServiceRoute439` FOREIGN KEY (`serviceRouteId`) REFERENCES `trans_service_route` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `trans_service_route_runondays` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `serviceRouteId` bigint(20) NOT NULL,
  `weekDay` varchar(15) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `RefRouteService786_idx` (`serviceRouteId`),
  KEY `RefRunOnDayUpBy_idx` (`lastUpdatedBy`),
  CONSTRAINT `RefRouteService786` FOREIGN KEY (`serviceRouteId`) REFERENCES `trans_service_route` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `RefRunOnDayUpBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `trans_service_route_stops` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `serviceRouteId` bigint(20) NOT NULL,
  `stopLocationId` bigint(20) DEFAULT NULL,
  `distance` double(10,2) DEFAULT NULL,
  `sequence` int(11) DEFAULT NULL,
  `arrivalTime` timestamp NULL DEFAULT NULL,
  `departureTime` timestamp NULL DEFAULT NULL,
  `routeStopType` varchar(45) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `RefRouteService_idx` (`serviceRouteId`),
  KEY `RefStopLocation_idx` (`stopLocationId`),
  KEY `RefStopUpBy_idx` (`lastUpdatedBy`),
  CONSTRAINT `RefRouteService` FOREIGN KEY (`serviceRouteId`) REFERENCES `trans_service_route` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `RefStopLocation` FOREIGN KEY (`stopLocationId`) REFERENCES `trans_route_location` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `RefStopUpBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `trans_service_route_users` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `serviceRouteId` bigint(20) NOT NULL,
  `userId` bigint(20) DEFAULT NULL,
  `userName` varchar(255) DEFAULT NULL,
  `dateAdded` date DEFAULT NULL,
  `addtionEffectiveFrom` date DEFAULT NULL,
  `dateRemoved` date DEFAULT NULL,
  `removalEffectiveForm` date DEFAULT NULL,
  `usageStatus` varchar(45) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `RefRouteService436_idx` (`serviceRouteId`),
  KEY `RefuserId35_idx` (`userId`),
  KEY `RefRouteServiceUsrUpBy_idx` (`lastUpdatedBy`),
  CONSTRAINT `RefRouteService436` FOREIGN KEY (`serviceRouteId`) REFERENCES `trans_service_route` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `RefRouteServiceUsrUpBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `RefuserId35` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `trans_service_route_vehicles` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `serviceRouteId` bigint(20) NOT NULL,
  `vehicleId` bigint(20) NOT NULL,
  `whetherActive` bit(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `RefRRouteService43_idx` (`serviceRouteId`),
  KEY `RefServiceVehicle32_idx` (`vehicleId`),
  KEY `RefServiceVehicleUpBy_idx` (`lastUpdatedBy`),
  CONSTRAINT `RefServiceVehicleUpBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `RefRouteService43` FOREIGN KEY (`serviceRouteId`) REFERENCES `trans_service_route` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `RefServiceVehicle32` FOREIGN KEY (`vehicleId`) REFERENCES `trans_vehicle` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;