
CREATE 
     OR REPLACE ALGORITHM = UNDEFINED 
    DEFINER = `root`@`localhost` 
    SQL SECURITY DEFINER
VIEW `student_period_report` AS
    select 
        `admission`.`id` AS `admissionId`,
        `admission`.`studentId` AS `studentId`,
        `evaluation_period_rank`.`id` AS `periodRankId`,
        `admission`.`code` AS `admissionCode`,
        `programs`.`id` AS `programId`,
        `programs`.`programName` AS `programName`,
        `batches`.`id` AS `batchId`,
        `batches`.`batchName` AS `batchName`,
        `prog_batch_period_config`.`id` AS `periodId`,
        `prog_batch_period_config`.`programPeriodName` AS `periodName`,
        `sections`.`id` AS `sectionId`,
        `sections`.`sectionCode` AS `sectionName`,
        `marksheet_job_sub_level`.`marksheetJobSubLevelName` AS `marksheetType`,
        count(distinct `student_course_enrollment`.`courseVarientId`) AS `totalNoOfCourse`,
        count(distinct (case
                when (`student_course_enrollment`.`whetherOptional` = 0) then `student_course_enrollment`.`courseVarientId`
            end)) AS `mandatoryCourseCount`,
        count(distinct (case
                when (`student_course_enrollment`.`whetherOptional` = 1) then `student_course_enrollment`.`courseVarientId`
            end)) AS `optionalCourseCount`,
        (case
            when
                isnull(`evaluation_period_rank`.`obtainedMarks`)
            then
                (case
                    when (`marksheet_job_details`.`isPublishMarksheet` = 1) then `evaluation_period_rank`.`sgpa`
                end)
            else (case
                when (`marksheet_job_details`.`isPublishMarksheet` = 1) then `evaluation_period_rank`.`obtainedMarks`
            end)
        end) AS `SGPAORMarks`,
        (case
            when (`marksheet_job_details`.`isPublishMarksheet` = 1) then `evaluation_period_rank`.`status`
        end) AS `ResultStatus`,
        (case
            when (`marksheet_job_details`.`isPublishMarksheet` = 1) then `marksheet_job_details`.`marksheetPath`
        end) AS `marksheetPath`
    from
        ((((((((((`program_batch_students`
        left join `admission` ON ((`program_batch_students`.`admissionId` = `admission`.`id`)))
        left join `prog_batch_period_config` ON ((`program_batch_students`.`progBatchPeriodConfigId` = `prog_batch_period_config`.`id`)))
        left join `batches` ON ((`program_batch_students`.`programBatchId` = `batches`.`id`)))
        left join `programs` ON ((`batches`.`programId` = `programs`.`id`)))
        left join `evaluation_period_rank` ON (((`evaluation_period_rank`.`admissionId` = `admission`.`id`)
            and (`evaluation_period_rank`.`periodId` = `prog_batch_period_config`.`id`))))
        left join `student_course_enrollment` ON ((`student_course_enrollment`.`admissionId` = `admission`.`id`)))
        left join `sections` ON ((`student_course_enrollment`.`sectionId` = `sections`.`id`)))
        left join `marksheet_job_details` ON ((`marksheet_job_details`.`admissionId` = `admission`.`id`)))
        left join `marksheet_job_sub_level` ON ((`marksheet_job_details`.`marksheetJobSubLevelId` = `marksheet_job_sub_level`.`id`)))
        left join `marksheet_job` ON (((`marksheet_job_sub_level`.`marksheetJobId` = `marksheet_job`.`id`)
            and (`marksheet_job`.`periodId` = `prog_batch_period_config`.`id`))))
    group by `marksheet_job_sub_level`.`id` , `admission`.`id`;
