SET FOREIGN_KEY_CHECKS = 0;

TRUNCATE `course_read_distribution`;
TRUNCATE `course_reading_links`;
TRUNCATE `course_reading_topics`;
TRUNCATE `course_reading_variant`;
TRUNCATE `course_reading_period_details`;
TRUNCATE `course_reading_cd`;
TRUNCATE `course_reading_documents`;

DROP TABLE IF EXISTS `course_reading`;

CREATE TABLE `course_reading` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `linkPath` TEXT,
  `academicYear` INT(11) DEFAULT NULL,
  `courseId` BIGINT(20) DEFAULT NULL,
  `distributionModeId` BIGINT(20) DEFAULT NULL,
  `invtItemMasterId` BIGINT(20) NOT NULL,
  `whetherCompulsory` BIT(1) NOT NULL,
  `topicType` VARCHAR(35) DEFAULT NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` DATETIME NOT NULL,
  PRIMARY KEY (`id`),
  KEY `Refcourses159` (`courseId`),
  KEY `Refusers1251` (`lastUpdatedBy`),
  KEY `Refdistribution_mode1864` (`distributionModeId`),
  KEY `invtItemMasterId_FK` (`invtItemMasterId`),
  CONSTRAINT `invtItemMasterId_FK` FOREIGN KEY (`invtItemMasterId`) REFERENCES `invt_item_master` (`id`),
  CONSTRAINT `Refcourses159` FOREIGN KEY (`courseId`) REFERENCES `courses` (`id`),
  CONSTRAINT `Refdistribution_mode1864` FOREIGN KEY (`distributionModeId`) REFERENCES `distribution_mode` (`id`),
  CONSTRAINT `Refusers1251` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=INNODB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8;

drop table if exists invt_distribution_item_list;
drop table if exists invt_student_distribution_detail;
drop table if exists invt_student_distribution;
drop table if exists invt_distribution_list;

SET FOREIGN_KEY_CHECKS = 1;
-- invt_distribution_list

CREATE TABLE `invt_distribution_list`( `id` BIGINT(20) NOT NULL, `listName` VARCHAR(200) NOT NULL, `programId` BIGINT(20), `batchId` BIGINT(20), `periodId` BIGINT(20), `lastUpdate` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP, `lastUpdatedBy` BIGINT(20), PRIMARY KEY (`id`), CONSTRAINT `invt_dist_list_programId_FK` FOREIGN KEY (`programId`) REFERENCES `programs`(`id`), CONSTRAINT `invt_dist_list_batchId_FK` FOREIGN KEY (`batchId`) REFERENCES `batches`(`id`), CONSTRAINT `invt_dist_list_periodId_FK` FOREIGN KEY (`periodId`) REFERENCES `prog_batch_period_config`(`id`), CONSTRAINT `invt_dist_list_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`) ) ENGINE=INNODB CHARSET=utf8 COLLATE=utf8_general_ci; 


-- invt_distribution_item_list
CREATE TABLE `invt_distribution_item_list`( `id` BIGINT(20) NOT NULL, `invtDistListId` BIGINT(20), `courseReadingId` BIGINT(20), `courseReadingVariantId` BIGINT(20), `lastUpdate` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP, `lastUpdatedBy` BIGINT(20), PRIMARY KEY (`id`), CONSTRAINT `invt_distribution_item_list_invtDistListId_FK` FOREIGN KEY (`invtDistListId`) REFERENCES `invt_distribution_list`(`id`), CONSTRAINT `invt_distribution_item_list_courseReadingId_FK` FOREIGN KEY (`courseReadingId`) REFERENCES `course_reading`(`id`), CONSTRAINT `invt_distribution_item_list_courseReadingVariantId_FK` FOREIGN KEY (`courseReadingVariantId`) REFERENCES `course_reading_variant`(`id`), CONSTRAINT `invt_distribution_item_list_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`) ) ENGINE=INNODB CHARSET=utf8 COLLATE=utf8_general_ci; 

-- invt_student_distribution

CREATE TABLE `invt_student_distribution`( `id` BIGINT(20) NOT NULL, `studentId` BIGINT(20), `packetNo` VARCHAR(200), `consignmentNo` VARCHAR(200), `sentBy` BIGINT(20), `serviceProvider` VARCHAR(200), `sentDate` TIMESTAMP, `remarks` TEXT, `studentAddress` TEXT, `packetStatus` VARCHAR(50), `inventoryDistributionListId` BIGINT(20), `returnedDate` TIMESTAMP, `deliveredDate` TIMESTAMP, `POD` VARCHAR(200), `lastUpdate` TIMESTAMP DEFAULT CURRENT_TIMESTAMP, `lastUpdatedBy` BIGINT(20), PRIMARY KEY (`id`), CONSTRAINT `invt_student_distribution_studentId_FK` FOREIGN KEY (`studentId`) REFERENCES `users`(`id`), CONSTRAINT `invt_student_distribution_sentBy_FK` FOREIGN KEY (`sentBy`) REFERENCES `users`(`id`), CONSTRAINT `invt_student_distribution_inventoryDistributionListId_FK` FOREIGN KEY (`inventoryDistributionListId`) REFERENCES `invt_distribution_list`(`id`), CONSTRAINT `invt_student_distribution_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`) ) ENGINE=INNODB CHARSET=utf8 COLLATE=utf8_general_ci;  

-- invt_student_distribution_detail

CREATE TABLE `invt_student_distribution_detail`( `id` BIGINT(20) NOT NULL, `inventoryStudentDistributionId` BIGINT(20), `courseReadingVariantId` BIGINT(20), `lastUpdate` TIMESTAMP DEFAULT CURRENT_TIMESTAMP, `lastUpdatedBy` BIGINT(20), PRIMARY KEY (`id`), CONSTRAINT `student_dist_detail_inventoryStudentDistributionId_FK` FOREIGN KEY (`inventoryStudentDistributionId`) REFERENCES `invt_student_distribution`(`id`), CONSTRAINT `invt_student_distribution_detail_courseReadingVariantId_FK` FOREIGN KEY (`courseReadingVariantId`) REFERENCES `course_reading_variant`(`id`), CONSTRAINT `invt_student_distribution_detail_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`) ) ENGINE=INNODB CHARSET=utf8 COLLATE=utf8_general_ci;  

set foreign_key_checks = 0;

ALTER TABLE `invt_student_distribution`
CHANGE COLUMN `id` `id` BIGINT(20) NOT NULL AUTO_INCREMENT;

ALTER TABLE `invt_student_distribution_detail`
CHANGE COLUMN `id` `id` BIGINT(20) NOT NULL AUTO_INCREMENT;

ALTER TABLE `invt_distribution_list` CHANGE `id` `id` BIGINT(20) NOT NULL AUTO_INCREMENT; 
ALTER TABLE `invt_distribution_item_list` CHANGE `id` `id` BIGINT(20) NOT NULL AUTO_INCREMENT; 

set foreign_key_checks = 1;