
CREATE TABLE `drool_rules` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `droolCode` varchar(255) NOT NULL,
  `droolPrintName` varchar(255) NOT NULL,
  `droolFor` varchar(255) NOT NULL,
  `description` varchar(512) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

insert into picklist_enum(enumType, code, enumValue)
values('DROOL_FOR_TYPE','EXAM','Examinations' ),
('DROOL_FOR_TYPE','FEE','Fees' );


SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
INSERT INTO `standard_master` (`id`,`tableName`, `masterName`, `moduleName`, `whetherChild`, `whetherParent`, `lastUpdatedBy`, `lastUpdate`) VALUES (@standardMasterMaxId + 1,'drool_rules', 'DROOL_RULES', 'Examinations', 0, 0, '1', '2015-11-24 11:32:40');


SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO `standard_master_items` (`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) VALUES (@ItemsMaxId+1, 'droolCode', 'DROOL_CODE', @standardMasterMaxId + 1, 'Varchar', '1', 0, 0, 0, 0, '1', '2015-11-25 15:23:01');
INSERT INTO `standard_master_items` (`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) VALUES (@ItemsMaxId+2, 'droolPrintName', 'DROOL_PRINT_NAME', @standardMasterMaxId + 1, 'Varchar', '2', 0, 0, 0, 0, '1', '2015-11-25 15:23:01');
INSERT INTO `standard_master_items` (`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `emunType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) VALUES (@ItemsMaxId+3, 'droolFor', 'DROOL_FOR', @standardMasterMaxId + 1, 'Enum', 'DROOL_FOR_TYPE', '3', 0, 0, 0, 0, '1', '2015-11-25 15:23:01');
INSERT INTO `standard_master_items` (`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) VALUES (@ItemsMaxId+4, 'description', 'DESCRIPTION', @standardMasterMaxId + 1, 'Varchar', '4', 0, 0, 0, 0, '1', '2015-11-25 15:23:01');


insert into drool_rules values
(1,'BODY_WEIGHT_RESULT_CALCULATION','Body Weight Rule','EXAM',NULL,1,now()),
(2,'BODY_HEIGHT_RESULT_CALCULATION','Body Height Rule','EXAM',NULL,1,now()),
(3,'STANDING_LONG_JUMP_RESULT_CALCULATION','Long Jump Result Rule','EXAM',NULL,1,now()),
(4,'PACER_20M_RESULT_CALCULATION','Pacer Result Calculation','EXAM',NULL,1,now()),
(5,'CURL_UPS_RESULT_CALCULATION','Curl Ups Result Rule','EXAM',NULL,1,now()),
(6,'TRUNK_LIFT_RESULT_CALCULATION','Trunk Lift Result Rule','EXAM',NULL,1,now()),
(7,'SIT_AND_REACH_RESULT_CALCULATION','Sit And Reach Result Rule','EXAM',NULL,1,now()),
(8,'ZIPPER_RESULT_CALCULATION','Zipper Result Rule','EXAM',NULL,1,now());

