CREATE TABLE `research_type` (
`id` BIGINT(20) NOT NULL AUTO_INCREMENT COMMENT '',
`itemCode` VARCHAR(255) NOT NULL COMMENT '',
`itemValue` VARCHAR(255) NOT NULL COMMENT '',
`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '',
`lastUpdatedBy` BIGINT(20) NOT NULL COMMENT '',
INDEX `RefUsers7001_idx` (`lastUpdatedBy` ASC) COMMENT '',
PRIMARY KEY (`id`) COMMENT '',
CONSTRAINT `RefUsers7001`
FOREIGN KEY (`lastUpdatedBy`)
REFERENCES `users` (`id`)
ON DELETE NO ACTION
ON UPDATE NO ACTION);

CREATE TABLE `publication_index` (
`id` BIGINT(20) NOT NULL AUTO_INCREMENT COMMENT '',
`itemCode` VARCHAR(255) NOT NULL COMMENT '',
`itemValue` VARCHAR(255) NOT NULL COMMENT '',
`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '',
`lastUpdatedBy` BIGINT(20) NOT NULL COMMENT '',
INDEX `RefUsers7002idx` (`lastUpdatedBy` ASC) COMMENT '',
PRIMARY KEY (`id`) COMMENT '',
CONSTRAINT `RefUsers7002`
FOREIGN KEY (`lastUpdatedBy`)
REFERENCES `users` (`id`)
ON DELETE NO ACTION
ON UPDATE NO ACTION);

CREATE TABLE `publication_year` (
`id` BIGINT(20) NOT NULL AUTO_INCREMENT COMMENT '',
`itemCode` VARCHAR(255) NOT NULL COMMENT '',
`itemValue` VARCHAR(255) NOT NULL COMMENT '',
`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '',
`lastUpdatedBy` BIGINT(20) NOT NULL COMMENT '',
INDEX `RefUsers7003_idx` (`lastUpdatedBy` ASC) COMMENT '',
PRIMARY KEY (`id`) COMMENT '',
CONSTRAINT `RefUsers7003`
FOREIGN KEY (`lastUpdatedBy`)
REFERENCES `users` (`id`)
ON DELETE NO ACTION
ON UPDATE NO ACTION);

CREATE TABLE `conference_journal_type` (
`id` BIGINT(20) NOT NULL AUTO_INCREMENT COMMENT '',
`itemCode` VARCHAR(255) NOT NULL COMMENT '',
`itemValue` VARCHAR(255) NOT NULL COMMENT '',
`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '',
`lastUpdatedBy` BIGINT(20) NOT NULL COMMENT '',
INDEX `RefUsers7004_idx` (`lastUpdatedBy` ASC) COMMENT '',
PRIMARY KEY (`id`) COMMENT '',
CONSTRAINT `RefUsers7004`
FOREIGN KEY (`lastUpdatedBy`)
REFERENCES `users` (`id`)
ON DELETE NO ACTION
ON UPDATE NO ACTION);

CREATE TABLE `seminar_type` (
`id` BIGINT(20) NOT NULL AUTO_INCREMENT COMMENT '',
`itemCode` VARCHAR(255) NOT NULL COMMENT '',
`itemValue` VARCHAR(255) NOT NULL COMMENT '',
`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '',
`lastUpdatedBy` BIGINT(20) NOT NULL COMMENT '',
INDEX `RefUsers7005_idx` (`lastUpdatedBy` ASC) COMMENT '',
PRIMARY KEY (`id`) COMMENT '',
CONSTRAINT `RefUsers7005`
FOREIGN KEY (`lastUpdatedBy`)
REFERENCES `users` (`id`)
ON DELETE NO ACTION
ON UPDATE NO ACTION);

CREATE TABLE `training_type` (
`id` BIGINT(20) NOT NULL AUTO_INCREMENT COMMENT '',
`itemCode` VARCHAR(255) NOT NULL COMMENT '',
`itemValue` VARCHAR(255) NOT NULL COMMENT '',
`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '',
`lastUpdatedBy` BIGINT(20) NOT NULL COMMENT '',
INDEX `RefUsers7006_idx` (`lastUpdatedBy` ASC) COMMENT '',
PRIMARY KEY (`id`) COMMENT '',
CONSTRAINT `RefUsers7006`
FOREIGN KEY (`lastUpdatedBy`)
REFERENCES `users` (`id`)
ON DELETE NO ACTION
ON UPDATE NO ACTION);

INSERT INTO standard_master(`childMaster`,`tableName`, `masterName`,`moduleName`, `filterCode`,`whetherChild`, `whetherParent`,`lastUpdatedBy`, `lastUpdate`)
VALUES (null,'research_type', 'RESEARCH_TYPE', 'Student Profile','COMMON_MASTER', 0, 0, '1', SYSDATE());
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
INSERT INTO standard_master_items(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `fkTable`, `fkFieldName`,`fkDisplayField`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
VALUES
('code','ITEM_CODE',@standardMasterMaxId,'Varchar','1',0,NULL,NULL,NULL,0,0,1,'1',SYSDATE()),
('value','ITEM_VALUE',@standardMasterMaxId,'Varchar','2',0,NULL,NULL,NULL,0,0,1,'1',SYSDATE());

INSERT INTO standard_master(`childMaster`,`tableName`, `masterName`,`moduleName`, `filterCode`,`whetherChild`, `whetherParent`,`lastUpdatedBy`, `lastUpdate`)
VALUES (null,'publication_index', 'PUBLICATION_INDEX', 'Student Profile','COMMON_MASTER', 0, 0, '1', SYSDATE());
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
INSERT INTO standard_master_items(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `fkTable`, `fkFieldName`,`fkDisplayField`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
VALUES
('code','ITEM_CODE',@standardMasterMaxId,'Varchar','1',0,NULL,NULL,NULL,0,0,1,'1',SYSDATE()),
('value','ITEM_VALUE',@standardMasterMaxId,'Varchar','2',0,NULL,NULL,NULL,0,0,1,'1',SYSDATE());

INSERT INTO standard_master(`childMaster`,`tableName`, `masterName`,`moduleName`, `filterCode`,`whetherChild`, `whetherParent`,`lastUpdatedBy`, `lastUpdate`)
VALUES (null,'publication_year', 'PUBLICATION_YEAR', 'Student Profile','COMMON_MASTER', 0, 0, '1', SYSDATE());
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
INSERT INTO standard_master_items(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `fkTable`, `fkFieldName`,`fkDisplayField`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
VALUES
('code','ITEM_CODE',@standardMasterMaxId,'Varchar','1',0,NULL,NULL,NULL,0,0,1,'1',SYSDATE()),
('value','ITEM_VALUE',@standardMasterMaxId,'Varchar','2',0,NULL,NULL,NULL,0,0,1,'1',SYSDATE());

INSERT INTO standard_master(`childMaster`,`tableName`, `masterName`,`moduleName`, `filterCode`,`whetherChild`, `whetherParent`,`lastUpdatedBy`, `lastUpdate`)
VALUES (null,'conference_journal_type', 'CONFERENCE_JOURNAL_TYPE', 'Student Profile','COMMON_MASTER', 0, 0, '1', SYSDATE());
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
INSERT INTO standard_master_items(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `fkTable`, `fkFieldName`,`fkDisplayField`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
VALUES
('code','ITEM_CODE',@standardMasterMaxId,'Varchar','1',0,NULL,NULL,NULL,0,0,1,'1',SYSDATE()),
('value','ITEM_VALUE',@standardMasterMaxId,'Varchar','2',0,NULL,NULL,NULL,0,0,1,'1',SYSDATE());

INSERT INTO standard_master(`childMaster`,`tableName`, `masterName`,`moduleName`, `filterCode`,`whetherChild`, `whetherParent`,`lastUpdatedBy`, `lastUpdate`)
VALUES (null,'seminar_type', 'SEMINAR_TYPE', 'Student Profile','COMMON_MASTER', 0, 0, '1', SYSDATE());
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
INSERT INTO standard_master_items(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `fkTable`, `fkFieldName`,`fkDisplayField`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
VALUES
('code','ITEM_CODE',@standardMasterMaxId,'Varchar','1',0,NULL,NULL,NULL,0,0,1,'1',SYSDATE()),
('value','ITEM_VALUE',@standardMasterMaxId,'Varchar','2',0,NULL,NULL,NULL,0,0,1,'1',SYSDATE());

INSERT INTO standard_master(`childMaster`,`tableName`, `masterName`,`moduleName`, `filterCode`,`whetherChild`, `whetherParent`,`lastUpdatedBy`, `lastUpdate`)
VALUES (null,'training_type', 'TRAINING_TYPE', 'Student Profile','COMMON_MASTER', 0, 0, '1', SYSDATE());
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
INSERT INTO standard_master_items(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `fkTable`, `fkFieldName`,`fkDisplayField`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
VALUES
('code','ITEM_CODE',@standardMasterMaxId,'Varchar','1',0,NULL,NULL,NULL,0,0,1,'1',SYSDATE()),
('value','ITEM_VALUE',@standardMasterMaxId,'Varchar','2',0,NULL,NULL,NULL,0,0,1,'1',SYSDATE());
