
DROP PROCEDURE IF EXISTS examResultHistoryData;

DELIMITER $$
CREATE PROCEDURE examResultHistoryData()
	BEGIN
               DECLARE examinationResultId BIGINT(20);
               declare evantId BIGINT(20);
               DECLARE admissionId BIGINT(20);
               declare courseVariantId BIGINT(20);
               DECLARE sectionId BIGINT(20);
               declare totalMarksGiven DOUBLE(20,2);
               declare graceMarksGiven DOUBLE(20,2);
               declare penultyMarksGiven DOUBLE(20,2);
               declare netMarksGiven DOUBLE(20,2);
               declare finalMarks DOUBLE(20,2);
               declare effectiveMarks DOUBLE(20,2);
               declare gradePoints DOUBLE(20,2);
               declare finalGrade VARCHAR(45);
               declare finalDescription VARCHAR(255);
               declare status1 VARCHAR(45);
               declare rank INT(11);
               declare examResultStatus VARCHAR(45);
               declare lastUpdatedBy BIGINT(20);
               declare lastUpdate TIMESTAMP;

declare examination_result_no_more_rows boolean default false;
declare course_variant_no_more_rows boolean default false;
 
-- create temporary table if not exists templog_createmarksheetjob (msg varchar(512));

START TRANSACTION;

 BLOCK1: begin

	DECLARE examResultIds CURSOR FOR
	select examination_result.id from examination_result 
    where examination_result.examResultStatus = 'RESULT_ENTERED'
    and examination_result.id not in (select examination_result_history.examinationResultId
    from examination_result_history);
           
 declare continue handler for not found  set examination_result_no_more_rows := true;
	OPEN examResultIds;
		examResultIds: LOOP
		fetch examResultIds into examinationResultId;
    if examination_result_no_more_rows then 
             set examination_result_no_more_rows := false;
        close examResultIds;
        leave examResultIds;
     end if;
   select examination_result.id, examination_result.evaluationDetailSequenceId,
   examination_result.admissionId, examination_result.courseVariantId,
   examination_result.sectionId, examination_result.totalMarksGiven,
   examination_result.graceMarksGiven, examination_result.penultyMarksGiven,
   examination_result.netMarksGiven, examination_result.finalMarks,
   examination_result.effectiveMarks, examination_result.finalGrade,
   examination_result.finalDescription, examination_result.gradePoints,
   examination_result.rank,examination_result.status,examination_result.examResultStatus,
   examination_result.lastUpdatedBy,examination_result.lastUpdate
   into examinationResultId, evantId, admissionId, courseVariantId, sectionId, totalMarksGiven, graceMarksGiven,
  penultyMarksGiven, netMarksGiven, finalMarks, effectiveMarks, finalGrade, 
  finalDescription, gradePoints, rank, status1, examResultStatus, lastUpdatedBy,lastUpdate
   from examination_result 
    where examination_result.id = examinationResultId;
  
  INSERT INTO `examination_result_history` (`examinationResultId`, `evaluationDetailSequenceId`,
  `admissionId`, `courseVariantId`, `sectionId`, `totalMarksGiven`, `graceMarksGiven`,
  `penultyMarksGiven`, `netMarksGiven`, `finalMarks`, `effectiveMarks`, `finalGrade`, 
  `finalDescription`, `gradePoints`, `rank`, `status`, `examResultStatus`, `lastUpdatedBy`,`lastUpdate`)
  VALUES (examinationResultId, evantId, admissionId, courseVariantId, sectionId, totalMarksGiven, graceMarksGiven,
  penultyMarksGiven, netMarksGiven, finalMarks, effectiveMarks, finalGrade, 
  finalDescription, gradePoints, rank, status1, examResultStatus, lastUpdatedBy,lastUpdate);
 
COMMIT;
			END LOOP examResultIds;

	END BLOCK1;
      
END$$
DELIMITER ;

call examResultHistoryData();
