CREATE TABLE `online_payment_master` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `status` varchar(255) DEFAULT NULL,
  `receiptAmount` double(20,2) DEFAULT NULL,
  `transactionDate` date DEFAULT NULL,
  `receiptId` bigint(20) DEFAULT NULL,
  `whetherSettled` bit(1) DEFAULT b'0',
  `receiptFor` varchar(255) DEFAULT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `txnid` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `online_payment` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `billFeePlanRuleStageId` bigint(20) DEFAULT NULL,
  `billId` bigint(20) DEFAULT NULL,
  `adjustedAmount` double(20,2) DEFAULT NULL,
  `balanceAmount` double(20,2) DEFAULT NULL,
  `studentId` bigint(20) DEFAULT NULL,
  `applicantId` bigint(20) DEFAULT NULL,
  `lastUpdate` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `onlinePaymentMasterId` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_online_payment_to_online_payment_master1_idx` (`onlinePaymentMasterId`),
  CONSTRAINT `fk_online_payment_to_online_payment_master1` FOREIGN KEY (`onlinePaymentMasterId`) REFERENCES `online_payment_master` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;