CREATE TABLE `eval_group_program_batches` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `evaluationGroupId` bigint(20) DEFAULT NULL,
  `programId` bigint(20) DEFAULT NULL,
  `batchId` bigint(20) DEFAULT NULL,
  `isPrimaryBatch` bit(1) DEFAULT b'0',
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eval_group_program_batches_unique_map` (`evaluationGroupId`,`programId`,`batchId`),
  KEY `eval_group_program_batches_fk1` (`evaluationGroupId`),
  KEY `eval_group_program_batches_fk2` (`lastUpdatedBy`),
  KEY `eval_group_program_batches_fk3` (`programId`),
  KEY `eval_group_program_batches_fk4` (`batchId`),
  CONSTRAINT `eval_group_program_batches_fk1` FOREIGN KEY (`evaluationGroupId`) REFERENCES `evaluation_group` (`id`),
  CONSTRAINT `eval_group_program_batches_fk2` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
  CONSTRAINT `eval_group_program_batches_fk3` FOREIGN KEY (`programId`) REFERENCES `programs` (`id`),
  CONSTRAINT `eval_group_program_batches_fk4` FOREIGN KEY (`batchId`) REFERENCES `batches` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;