SET @OLD_SQL_SAFE_UPDATES = @@SQL_SAFE_UPDATES;
SET SQL_SAFE_UPDATES =0;
ALTER TABLE `exam_result_event_students` 
ADD COLUMN `periodId` BIGINT(20) NULL DEFAULT NULL AFTER `sectionId`,
ADD INDEX `fk_exam_result_event_students_periodId_idx` (`periodId` ASC);
ALTER TABLE `exam_result_event_students` 
ADD CONSTRAINT `fk_exam_result_event_students_periodId_idx`
  FOREIGN KEY (`periodId`)
  REFERENCES `prog_batch_period_config` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;
  
update exam_result_event_students 
left join sections on exam_result_event_students.sectionId = sections.id
set exam_result_event_students.periodId=sections.periodId;


ALTER TABLE `examination_result_history` 
ADD COLUMN `periodId` BIGINT(20) NULL DEFAULT NULL AFTER `sectionId`,
ADD INDEX `fk_examination_result_history_periodId_idx` (`periodId` ASC);
ALTER TABLE `examination_result_history` 
ADD CONSTRAINT `fk_examination_result_history_periodId_idx`
  FOREIGN KEY (`periodId`)
  REFERENCES `prog_batch_period_config` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;
  
  
update examination_result_history 
left join sections on examination_result_history.sectionId = sections.id
set examination_result_history.periodId=sections.periodId;


ALTER TABLE `evaluation_type_course` 
ADD COLUMN `periodId` BIGINT(20) NULL DEFAULT NULL AFTER `sectionId`,
ADD INDEX `fk_evaluation_type_course_periodId_idx` (`periodId` ASC);
ALTER TABLE `evaluation_type_course` 
ADD CONSTRAINT `fk_evaluation_type_course_periodId_idx`
  FOREIGN KEY (`periodId`)
  REFERENCES `prog_batch_period_config` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;
  
  
update evaluation_type_course 
left join sections on evaluation_type_course.sectionId = sections.id
set evaluation_type_course.periodId=sections.periodId;


ALTER TABLE `examination_result` 
ADD COLUMN `periodId` BIGINT(20) NULL DEFAULT NULL AFTER `sectionId`,
ADD INDEX `fk_examination_result_periodId_idx` (`periodId` ASC);
ALTER TABLE `examination_result` 
ADD CONSTRAINT `fk_examination_result_periodId_idx`
  FOREIGN KEY (`periodId`)
  REFERENCES `prog_batch_period_config` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;
  
  
update examination_result 
left join sections on examination_result.sectionId = sections.id
set examination_result.periodId=sections.periodId;


ALTER TABLE `evaluation_sequence_rank` 
ADD COLUMN `periodId` BIGINT(20) NULL DEFAULT NULL AFTER `sectionId`,
ADD INDEX `fk_evaluation_sequence_rank_periodId_idx` (`periodId` ASC);
ALTER TABLE `evaluation_sequence_rank` 
ADD CONSTRAINT `fk_evaluation_sequence_rank_periodId_idx`
  FOREIGN KEY (`periodId`)
  REFERENCES `prog_batch_period_config` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;
  

update evaluation_sequence_rank 
left join sections on evaluation_sequence_rank.sectionId = sections.id
set evaluation_sequence_rank.periodId=sections.periodId;


  ALTER TABLE `evaluation_plan_level_two_rank` 
ADD COLUMN `periodId` BIGINT(20) NULL DEFAULT NULL AFTER `sectionId`,
ADD INDEX `fk_evaluation_plan_level_two_rank_periodId_idx` (`periodId` ASC);
ALTER TABLE `evaluation_plan_level_two_rank` 
ADD CONSTRAINT `fk_evaluation_plan_level_two_rank_periodId_idx`
  FOREIGN KEY (`periodId`)
  REFERENCES `prog_batch_period_config` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;

update evaluation_plan_level_two_rank 
left join sections on evaluation_plan_level_two_rank.sectionId = sections.id
set evaluation_plan_level_two_rank.periodId=sections.periodId;
  
  
  ALTER TABLE `evaluation_plan_level_one_rank` 
ADD COLUMN `periodId` BIGINT(20) NULL DEFAULT NULL AFTER `sectionId`,
ADD INDEX `fk_evaluation_plan_level_one_rank_periodId_idx` (`periodId` ASC);
ALTER TABLE `evaluation_plan_level_one_rank` 
ADD CONSTRAINT `fk_evaluation_plan_level_one_rank_periodId_idx`
  FOREIGN KEY (`periodId`)
  REFERENCES `prog_batch_period_config` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;

update evaluation_plan_level_one_rank 
left join sections on evaluation_plan_level_one_rank.sectionId = sections.id
set evaluation_plan_level_one_rank.periodId=sections.periodId;
  
  
  ALTER TABLE `evaluation_plan_rank` 
ADD COLUMN `periodId` BIGINT(20) NULL DEFAULT NULL AFTER `sectionId`,
ADD INDEX `fk_evaluation_plan_rank_periodId_idx` (`periodId` ASC);
ALTER TABLE `evaluation_plan_rank` 
ADD CONSTRAINT `fk_evaluation_plan_rank_periodId_idx`
  FOREIGN KEY (`periodId`)
  REFERENCES `prog_batch_period_config` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;

update evaluation_plan_rank 
left join sections on evaluation_plan_rank.sectionId = sections.id
set evaluation_plan_rank.periodId=sections.periodId;
  
  
ALTER TABLE `evaluation_student_remark` 
ADD COLUMN `courseVariantId` BIGINT(20) NULL DEFAULT NULL AFTER `admissionId`,
ADD COLUMN `sectionId` BIGINT(20) NULL DEFAULT NULL AFTER `courseVariantId`,
ADD COLUMN `periodId` BIGINT(20) NULL DEFAULT NULL AFTER `sectionId`,
DROP INDEX `fk__idx` ,
ADD INDEX `fk_evaluation_student_remark_evalPlanId_idx` (`evaluationPlanId` ASC),
ADD INDEX `fk_evaluation_student_remark_courseVariantId_idx` (`courseVariantId` ASC),
ADD INDEX `fk_evaluation_student_remark_sectionId_idx` (`sectionId` ASC),
ADD INDEX `fk_evaluation_student_remark_periodId_idx` (`periodId` ASC);
ALTER TABLE `evaluation_student_remark` 
ADD CONSTRAINT `fk_evaluation_student_remark_courseVariantId`
  FOREIGN KEY (`courseVariantId`)
  REFERENCES `course_variants` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT,
ADD CONSTRAINT `fk_evaluation_student_remark_sectionId`
  FOREIGN KEY (`sectionId`)
  REFERENCES `sections` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT,
ADD CONSTRAINT `fk_evaluation_student_remark_periodId`
  FOREIGN KEY (`periodId`)
  REFERENCES `prog_batch_period_config` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;

UPDATE evaluation_student_remark 
left join evaluation_plan on evaluation_student_remark.evaluationPlanId = evaluation_plan.id
left join evaluation_plan_level_one on evaluation_plan_level_one.evaluationPlanId=evaluation_plan.id
left join evaluation_plan_level_two on evaluation_plan_level_two.evalPlanLevelOneId=evaluation_plan_level_one.id
left join evaluation_sequence on evaluation_sequence.evalPlanLevelTwoId=evaluation_plan_level_two.id
left join eval_seq_detail on eval_seq_detail.evalSequenceId=evaluation_sequence.id
left join examination_result on examination_result.evaluationDetailSequenceId=eval_seq_detail.id
set evaluation_student_remark.courseVariantId = examination_result.courseVariantId,
evaluation_student_remark.periodId = examination_result.periodId,
evaluation_student_remark.sectionId = examination_result.sectionId
where examination_result.admissionId=evaluation_student_remark.admissionId
and (evaluation_plan_level_one.id = evaluation_student_remark.evalPlanLevelOneId 
or evaluation_student_remark.evalPlanLevelOneId is null)
and (evaluation_plan_level_two.id = evaluation_student_remark.evalPlanLevelTwoId 
or evaluation_student_remark.evalPlanLevelTwoId is null)
and (evaluation_sequence.id = evaluation_student_remark.evalSequenceId 
or evaluation_student_remark.evalSequenceId is null);
  
  
  
  ALTER TABLE `eval_group_sequences` 
ADD COLUMN `periodId` BIGINT(20) NULL DEFAULT NULL AFTER `sectionId`,
ADD INDEX `fk_eval_group_sequences_periodId_idx` (`periodId` ASC);
ALTER TABLE `eval_group_sequences` 
ADD CONSTRAINT `fk_eval_group_sequences_periodId_idx`
  FOREIGN KEY (`periodId`)
  REFERENCES `prog_batch_period_config` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;

update eval_group_sequences 
left join sections on eval_group_sequences.sectionId = sections.id
set eval_group_sequences.periodId=sections.periodId;
  
  ALTER TABLE `eval_group_center` 
ADD COLUMN `periodId` BIGINT(20) NULL DEFAULT NULL AFTER `sectionId`,
ADD INDEX `fk_eval_group_center_periodId_idx` (`periodId` ASC);
ALTER TABLE `eval_group_center` 
ADD CONSTRAINT `fk_eval_group_center_periodId_idx`
  FOREIGN KEY (`periodId`)
  REFERENCES `prog_batch_period_config` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;

update eval_group_center 
left join sections on eval_group_center.sectionId = sections.id
set eval_group_center.periodId=sections.periodId;
  
  ALTER TABLE `eval_group_sch_date` 
ADD COLUMN `periodId` BIGINT(20) NULL DEFAULT NULL AFTER `sectionId`,
ADD INDEX `fk_eval_group_sch_date_periodId_idx` (`periodId` ASC);
ALTER TABLE `eval_group_sch_date` 
ADD CONSTRAINT `fk_eval_group_sch_date_periodId_idx`
  FOREIGN KEY (`periodId`)
  REFERENCES `prog_batch_period_config` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;

update eval_group_sch_date 
left join sections on eval_group_sch_date.sectionId = sections.id
set eval_group_sch_date.periodId=sections.periodId;
  
  
  
  ALTER TABLE `group_schedule_batch` 
ADD COLUMN `periodId` BIGINT(20) NULL DEFAULT NULL AFTER `sectionId`,
ADD INDEX `fk_group_schedule_batch_periodId_idx` (`periodId` ASC);
ALTER TABLE `group_schedule_batch` 
ADD CONSTRAINT `fk_group_schedule_batch_periodId_idx`
  FOREIGN KEY (`periodId`)
  REFERENCES `prog_batch_period_config` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;

update group_schedule_batch 
left join sections on group_schedule_batch.sectionId = sections.id
set group_schedule_batch.periodId=sections.periodId;
  
  
  ALTER TABLE `group_batch_seat_type` 
ADD COLUMN `periodId` BIGINT(20) NULL DEFAULT NULL AFTER `sectionId`,
ADD INDEX `fk_group_batch_seat_type_periodId_idx` (`periodId` ASC);
ALTER TABLE `group_batch_seat_type` 
ADD CONSTRAINT `fk_group_batch_seat_type_periodId_idx`
  FOREIGN KEY (`periodId`)
  REFERENCES `prog_batch_period_config` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;

update group_batch_seat_type 
left join sections on group_batch_seat_type.sectionId = sections.id
set group_batch_seat_type.periodId=sections.periodId;
  
  
  ALTER TABLE `examiner_allocation` 
ADD COLUMN `periodId` BIGINT(20) NULL DEFAULT NULL AFTER `sectionId`,
ADD INDEX `fk_examiner_allocation_periodId_idx` (`periodId` ASC);
ALTER TABLE `examiner_allocation` 
ADD CONSTRAINT `fk_examiner_allocation_periodId_idx`
  FOREIGN KEY (`periodId`)
  REFERENCES `prog_batch_period_config` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;

update examiner_allocation 
left join sections on examiner_allocation.sectionId = sections.id
set examiner_allocation.periodId=sections.periodId;



ALTER TABLE `evaluation_type_course` 
DROP INDEX `plan_variant_section_unique_type`;
ALTER TABLE `evaluation_type_course` 
ADD UNIQUE INDEX `plan_variant_section_period_unique_type` (`courseVariantId` ASC, `sectionId` ASC, `periodId` ASC) ;

SET SQL_SAFE_UPDATES = @OLD_SQL_SAFE_UPDATES;
