-- mobile institute mapping table
CREATE TABLE IF NOT EXISTS `mobile_institute` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `academyLocationId` bigint(20) DEFAULT NULL,
  `instituteId` varchar(255) DEFAULT NULL,
  `instituteCode` varchar(100) DEFAULT NULL,
  `userId` varchar(255) DEFAULT NULL,
  `apiAction` varchar(20) DEFAULT NULL,
  `status` varchar(20) DEFAULT NULL,
  `errorMessage` TEXT DEFAULT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_mobile_institute_updatedby` (`lastUpdatedBy`),
  CONSTRAINT `fk_mobile_institute_updatedby` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- mobile group mapping table
CREATE TABLE IF NOT EXISTS `mobile_group` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `groupType` varchar(20) DEFAULT NULL,
  `typeId` bigint(20) NOT NULL,
  `instituteId` varchar(255) DEFAULT NULL,
  `groupId` varchar(255) DEFAULT NULL,
  `apiAction` varchar(20) DEFAULT NULL,
  `status` varchar(20) DEFAULT NULL,
  `errorMessage` TEXT DEFAULT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_mobile_group_updatedby` (`lastUpdatedBy`),
  CONSTRAINT `fk_mobile_group_updatedby` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- mobile user mapping table
CREATE TABLE IF NOT EXISTS `mobile_user` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `instituteId` varchar(255) DEFAULT NULL,
  `userId` bigint(20) NOT NULL,
  `mobileUserId` varchar(255) DEFAULT NULL,
  `userType` varchar(20) DEFAULT NULL,
  `apiAction` varchar(20) DEFAULT NULL,
  `status` varchar(20) DEFAULT NULL,
  `errorMessage` TEXT DEFAULT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_mobile_user_updatedby` (`lastUpdatedBy`),
  CONSTRAINT `fk_mobile_user_updatedby` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- mobile attendance mapping table
CREATE TABLE IF NOT EXISTS `mobile_attendance` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `attendanceType` varchar(20) DEFAULT NULL,
  `attendanceId` bigint(20) NOT NULL,
  `mobileAttendanceId` varchar(255) DEFAULT NULL,
  `groupId` bigint(20) NOT NULL,
  `instituteId` varchar(255) DEFAULT NULL,
  `apiAction` varchar(20) DEFAULT NULL,
  `status` varchar(20) DEFAULT NULL,
  `errorMessage` TEXT DEFAULT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_mobile_attendance_groupId` (`groupId`),
  KEY `fk_mobile_attendance_updatedby` (`lastUpdatedBy`),
  CONSTRAINT `fk_mobile_attendance_groupId` FOREIGN KEY (`groupId`) REFERENCES `mobile_group` (`id`),
  CONSTRAINT `fk_mobile_attendance_updatedby` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- mobile user group mapping table
CREATE TABLE IF NOT EXISTS `mobile_group_user` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `mobileGroupId` bigint(20) NOT NULL,
  `mobileUserId` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_mobile_user_group_updatedby` (`lastUpdatedBy`),
  CONSTRAINT `fk_mobile_user_group_updatedby` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- mobile assignment mapping table
CREATE TABLE IF NOT EXISTS `mobile_assignment` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `assignmentId` bigint(20) NOT NULL,
  `mobileAssignmentId` varchar(255) DEFAULT NULL,
  `groupId` bigint(20) NOT NULL,
  `instituteId` varchar(255) DEFAULT NULL,
  `apiAction` varchar(20) DEFAULT NULL,
  `status` varchar(20) DEFAULT NULL,
  `errorMessage` TEXT DEFAULT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_mobile_assignment_groupId` (`groupId`),
  KEY `fk_mobile_assignment_updatedby` (`lastUpdatedBy`),
  CONSTRAINT `fk_mobile_assignment_groupId` FOREIGN KEY (`groupId`) REFERENCES `mobile_group` (`id`),
  CONSTRAINT `fk_mobile_assignment_updatedby` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
