CREATE TABLE `enquiry_reassign` (
  `id` BIGINT(20) NOT NULL,
  `enquiryId` BIGINT(20) NOT NULL,
  `userId` BIGINT(20) NULL,
  `reassignReason` VARCHAR(255) NULL DEFAULT NULL,
  `reassignDate` DATE NULL DEFAULT NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `enquiry_reassign_fk_1_idx` (`enquiryId` ASC),
  INDEX `enquiry_reassign_fk_2_idx` (`userId` ASC),
  INDEX `enquiry_reassign_fk_3_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `enquiry_reassign_fk_1`
    FOREIGN KEY (`enquiryId`)
    REFERENCES `enquiry` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `enquiry_reassign_fk_2`
    FOREIGN KEY (`userId`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `enquiry_reassign_fk_3`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);