CREATE TABLE `optional_period_enrollment` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `periodId` bigint(20) NOT NULL,
  `admissionId` bigint(20) DEFAULT NULL,
  `status` varchar(25) DEFAULT NULL,
  `requestDate` date DEFAULT NULL,
  `programBatchStudentId` bigint(20) DEFAULT NULL,
  `enrollmentDate` date DEFAULT NULL,
  `approverId` BIGINT(20) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `optional_period_enrollment_lastUpdatedBy` (`lastUpdatedBy`),
  KEY `optional_period_enrollment_periodId` (`periodId`),
  KEY `optional_period_enrollment_admissionId` (`admissionId`),
  KEY `optional_period_enrollment_programBatchStudentId_idx` (`programBatchStudentId`),
  CONSTRAINT `optional_period_enrollment_admissionId` FOREIGN KEY (`admissionId`) REFERENCES `admission` (`id`),
  CONSTRAINT `optional_period_enrollment_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
  CONSTRAINT `optional_period_enrollment_periodId` FOREIGN KEY (`periodId`) REFERENCES `prog_batch_period_config` (`id`),
  CONSTRAINT `optional_period_enrollment_approverId` FOREIGN KEY (`approverId`) REFERENCES `users` (`id`),
  CONSTRAINT `optional_period_enrollment_programBatchStudentId` FOREIGN KEY (`programBatchStudentId`) REFERENCES `program_batch_students` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8