CREATE TABLE `committee_meeting_documents` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `documentId` bigint(20) NOT NULL,
  `resourceBookingId` bigint(20) NOT NULL,
  `committeeId` bigint(20) NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_committee_docs_1_idx` (`documentId`),
  KEY `fk_committee_docs_2_idx` (`lastUpdatedBy`),
  KEY `fk_committee_docs_3_idx` (`resourceBookingId`),
  KEY `fk_committee_docs_4_idx` (`committeeId`),
  CONSTRAINT `fk_committee_docs_1` FOREIGN KEY (`documentId`) REFERENCES `documents` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_committee_docs_2` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_committee_docs_3` FOREIGN KEY (`resourceBookingId`) REFERENCES `resource_bookings` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_committee_docs_4` FOREIGN KEY (`committeeId`) REFERENCES `committee` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
