
DELIMITER $$
DROP TRIGGER IF EXISTS `seminar_type_after_insert` $$
DELIMITER ;

DELIMITER //

CREATE TRIGGER seminar_type_after_insert
AFTER INSERT
   ON seminar_type FOR EACH ROW
BEGIN
      -- Insert record into other table
INSERT INTO bulk_document_group (groupName, documentName, documentType, personType, documentId, tableQuery, 
   rootPath, lastUpdate, lastUpdatedBy)
   VALUES ('Past History',NEW.itemValue, 'Seminar Details', 'STUDENT', NEW.id,
   'select T4.path AS value from seminar_type T1 LEFT JOIN person_seminar_details T2 ON T1.id = T2.seminarTypeId 
LEFT JOIN person_seminar_documents T3 ON T3.personSeminarId = T2.id LEFT JOIN documents T4 ON T4.id = T3.documentId 
where T2.personId = $param1 and T1.itemValue = $param2 and T2.whetherDeleted = false',
'document.constant.base.dir',NEW.lastUpdate,NEW.lastUpdatedBy);

INSERT INTO bulk_document_group (groupName, documentName, documentType, personType, documentId, tableQuery, 
   rootPath, lastUpdate, lastUpdatedBy)
   VALUES ('Past History',NEW.itemValue, 'Seminar Details', 'EMPLOYEE', NEW.id,
   'sselect T4.path AS value from seminar_type T1 LEFT JOIN person_seminar_details T2 ON T1.id = T2.seminarTypeId 
LEFT JOIN person_seminar_documents T3 ON T3.personSeminarId = T2.id LEFT JOIN documents T4 ON T4.id = T3.documentId 
where T2.personId = $param1 and T1.itemValue = $param2 and T2.whetherDeleted = false',
'document.constant.base.dir',NEW.lastUpdate,NEW.lastUpdatedBy);

END; //

DELIMITER ;