CREATE TABLE `hr_emp_leave_request_detail` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `empLeaveRequestId` bigint(20) NOT NULL,
  `status` varchar(20) NOT NULL DEFAULT '0' COMMENT '0: Pending , 1 : Approved, 2 : Reject, 3: Canceled',
  `approverLevelId` bigint(20) NOT NULL,
  `comment` varchar(225) DEFAULT NULL COMMENT 'Comment/Remark provided by approver',
  `requestReceivedDate` datetime DEFAULT NULL,
  `actionDate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `empLeaveRequestId` (`empLeaveRequestId`),
  KEY `lastUpdatedBy` (`lastUpdatedBy`),
  CONSTRAINT `hr_emp_leave_request_details_ibfk_1` FOREIGN KEY (`empLeaveRequestId`) REFERENCES `hr_emp_leave_request` (`id`),
  CONSTRAINT `hr_emp_leave_request_details_ibfk_2` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;