ALTER TABLE `application_condition` 
CHANGE COLUMN `condition` `condition` TEXT NULL DEFAULT NULL COMMENT '' ;

CREATE TABLE `application_condition_log` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `applicationId` bigint(20) NOT NULL,
  `condition` text,
  `lastUpdate` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `applicationConditionId` bigint(20) DEFAULT NULL,
  `documentNames` text,
  PRIMARY KEY (`id`),
  KEY `fk_application_condition_log_application_idx` (`applicationId`),
  KEY `fk_application_condition_log_application_condition_idx` (`applicationConditionId`),
  CONSTRAINT `fk_application_condition_log_application` FOREIGN KEY (`applicationId`) REFERENCES `application` (`id`),
  CONSTRAINT `fk_application_condition_log_application_condition` FOREIGN KEY (`applicationConditionId`) REFERENCES `application_condition` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `application_condition_doc_log` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `applicationConditionLogId` bigint(20) DEFAULT NULL,
  `documentId` bigint(20) DEFAULT NULL,
  `lastUpdate` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_application_condition_doc_log_application_condition_log_idx` (`applicationConditionLogId`),
  KEY `fk_application_condition_doc_log_document_idx_idx` (`documentId`),
  CONSTRAINT `fk_application_condition_doc_log_application_condition_log_idx` FOREIGN KEY (`applicationConditionLogId`) REFERENCES `application_condition_log` (`id`),
  CONSTRAINT `fk_application_condition_doc_log_document_idx` FOREIGN KEY (`documentId`) REFERENCES `application_required_documents` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;