SET SQL_SAFE_UPDATES = 0;
CREATE TABLE `applicant_hostel_requirement` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `whetherHostelApplicable` TINYINT(1) NULL DEFAULT '0',
  `dietaryRequirements` VARCHAR(255) NULL DEFAULT NULL,
  `foodAllergies` VARCHAR(255) NULL DEFAULT NULL,
  `sleepingDisorder` VARCHAR(255) NULL DEFAULT NULL,
  `anyMedicalNeedsOrSomething` VARCHAR(255) NULL DEFAULT NULL,
  `applicantPersonId` BIGINT(20) NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NULL DEFAULT NULL,
  `version` bigint(20) NULL DEFAULT 0,
  `whetherDeleted` bit(1) NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  CONSTRAINT `hostel_applicant_person_id`
    FOREIGN KEY (`applicantPersonId`)
    REFERENCES `applicant_person` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION) ;
    
INSERT INTO `applicant_hostel_requirement` (`whetherHostelApplicable`, `dietaryRequirements`, `foodAllergies`,`sleepingDisorder`,`anyMedicalNeedsOrSomething`,`applicantPersonId`)
select a.whetherHostelApplicable, ap.dietaryRequirements, ap.foodAllergies, ap.sleepingDisorder, ap.anyMedicalNeedsOrSomething,ap.id as applicantPersonId
from
application a inner join applicant_person ap
on ap.id = a.applicantPersonId
where whetherHostelApplicable is not null and whetherHostelApplicable = 1;

ALTER TABLE application
  DROP COLUMN whetherHostelApplicable;

ALTER TABLE applicant_person
  DROP COLUMN dietaryRequirements,
  DROP COLUMN foodAllergies,
  DROP COLUMN sleepingDisorder,
  DROP COLUMN anyMedicalNeedsOrSomething;

SET SQL_SAFE_UPDATES = 1;