DELIMITER $$

DROP PROCEDURE IF EXISTS insert_record_ui_translation_table_to_world_database $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE insert_record_ui_translation_table_to_world_database()

BEGIN
  
   -- Insert new record in ui_translation table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='TRANSLATIONS' and keyName='ONLY_CANCELLED_SESSIONS')) THEN
    
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','ONLY_CANCELLED_SESSIONS','Only Cancelled Sessions','Only Cancelled Sessions',now(),1);

  END IF;

END $$

-- Execute the stored procedure
CALL insert_record_ui_translation_table_to_world_database() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS insert_record_ui_translation_table_to_world_database $$
 
DELIMITER ;