DELIMITER $$

DROP PROCEDURE IF EXISTS insert_record_ui_translation_table_to_world_database $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE insert_record_ui_translation_table_to_world_database()

BEGIN
  
   -- Insert new record in ui_translation table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='TRANSLATIONS' and keyName='SESSION_CANCELLATION')) THEN
    
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('TRANSLATIONS','SESSION_CANCELLATION','Session Cancellation','Session Cancellation',now(),1);
 END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='TRANSLATIONS' and keyName='ARE_YOU_SURE_YOU_WANT_TO_CANCEL_THE_SELECTED_SESSIONS_IF_YES_ENTER_REASON_BELOW_IF_NO_SIMPLY_CLICK_CANCEL')) THEN
    
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('TRANSLATIONS','ARE_YOU_SURE_YOU_WANT_TO_CANCEL_THE_SELECTED_SESSIONS_IF_YES_ENTER_REASON_BELOW_IF_NO_SIMPLY_CLICK_CANCEL','Are you sure you want to cancel the selected sessions? If yes, enter reason below. If no, simply click cancel:','Are you sure you want to cancel the selected sessions? If yes, enter reason below. If no, simply click cancel:',now(),1);

  END IF;
  
IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='TRANSLATIONS' and keyName='CANCELLATION_REASON')) THEN
    
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('TRANSLATIONS','CANCELLATION_REASON','Cancellation Reason','Cancellation Reason',now(),1);

  END IF;  

END $$

-- Execute the stored procedure
CALL insert_record_ui_translation_table_to_world_database() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS insert_record_ui_translation_table_to_world_database $$
 
DELIMITER ;