DELIMITER $$

DROP PROCEDURE IF EXISTS V202001071101__Alter_OwnerIdWithAcademyLocationId $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V202001071101__Alter_OwnerIdWithAcademyLocationId()

BEGIN
  
  -- Add the email_address column to the email table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='dydt_owner_conf' 
  AND column_name in('academyLocationId','programId','batchId','seatTypeId'))) THEN
  
   ALTER TABLE `dydt_owner_conf` 
    ADD COLUMN `academyLocationId` bigint(20)  NULL DEFAULT NULL AFTER `whetherActive`,
    ADD COLUMN `programId` bigint(20) NULL DEFAULT NULL,
    ADD COLUMN `batchId` bigint(20) NULL DEFAULT NULL,
    ADD COLUMN `seatTypeId` bigint(20) NULL DEFAULT NULL;

  END IF;

END $$

-- Execute the stored procedure
CALL V202001071101__Alter_OwnerIdWithAcademyLocationId() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V202001071101__Alter_OwnerIdWithAcademyLocationId $$
 
DELIMITER ;