DELIMITER $$

DROP PROCEDURE IF EXISTS V202001081243__alterCurrencyExchangeRateAndHistory $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V202001081243__alterCurrencyExchangeRateAndHistory()

BEGIN

	IF EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='currency_exchange_rate_history' 
 		AND column_name='currentDate')) THEN
	ALTER TABLE `currency_exchange_rate_history` 
	CHANGE COLUMN `currentDate` `currentDate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ,
	CHANGE COLUMN `lastUpdate` `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP ;
	END IF;


	
  -- Add the column to the table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='currency_exchange_rate_history' 
  AND column_name='currencyExchangeId')) THEN
  
	ALTER TABLE `currency_exchange_rate_history` 
	ADD COLUMN `currencyExchangeId` BIGINT(20) NULL DEFAULT NULL AFTER `lastUpdatedBy`,
	ADD INDEX `fk_currency_exchange_rate_history_to_currency_exchange_idx` (`currencyExchangeId` ASC);
	ALTER TABLE `currency_exchange_rate_history` 
	ADD CONSTRAINT `fk_currency_exchange_rate_history_to_currency_exchange`
  	FOREIGN KEY (`currencyExchangeId`)
  	REFERENCES `currency_exchange_rate` (`id`)
  	ON DELETE RESTRICT
  	ON UPDATE RESTRICT;
     END IF;
     


IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='currency_exchange_rate' 
  AND column_name='validFrom')) THEN
	ALTER TABLE `currency_exchange_rate` 
	ADD COLUMN `validFrom` TIMESTAMP NULL DEFAULT NULL AFTER `status`;

  END IF;

END $$

-- Execute the stored procedure
CALL V202001081243__alterCurrencyExchangeRateAndHistory() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V202001081243__alterCurrencyExchangeRateAndHistory $$
 
DELIMITER ;