DELIMITER $$

DROP PROCEDURE IF EXISTS V202001091903__Create_MultipleCurrencyUITranslation $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V202001091903__Create_MultipleCurrencyUITranslation()

BEGIN
  
   -- Insert new record in ui_translation table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName='TRANSLATIONS' and keyName='SETUP_EXCHANGE_RATE')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','SETUP_EXCHANGE_RATE','Setup Exchange Rate','Setup Exchange Rate',now(),1);
  END IF;
  
    IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName='TRANSLATIONS' and keyName='ASSOCIATE_INVOICE_RECEIPT_CURRENCY')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','ASSOCIATE_INVOICE_RECEIPT_CURRENCY','Associate Invoice & Receipt Currency','Associate Invoice & Receipt Currency',now(),1);
  END IF;
  
     IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName='TRANSLATIONS' and keyName='ASSOCIATE_INVOICE_RECEIPT_CURRENCY')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','ASSOCIATE_INVOICE_RECEIPT_CURRENCY','Associate Invoice & Receipt Currency','Associate Invoice & Receipt Currency',now(),1);
  END IF;
  
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName='TRANSLATIONS' and keyName='EXCHANGE_RATE_LIST')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','EXCHANGE_RATE_LIST','Exchange Rate List','Exchange Rate List',now(),1);
  END IF;
  
    IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName='TRANSLATIONS' and keyName='FROM_CURRENCY')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','FROM_CURRENCY','From Currency','From Currency',now(),1);
  END IF;
  
   IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName='TRANSLATIONS' and keyName='TO_CURRENCY')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','TO_CURRENCY','To Currency','To Currency',now(),1);
  END IF;
  
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName='TRANSLATIONS' and keyName='APPLICABLE_FROM')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','APPLICABLE_FROM','Applicable From','Applicable From',now(),1);
  END IF;
  
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName='TRANSLATIONS' and keyName='APPLICABLE_TILL')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','APPLICABLE_TILL','Applicable Till','Applicable Till',now(),1);
  END IF;
  
    IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName='TRANSLATIONS' and keyName='EXCHANGE_RATE_HISTORY')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','EXCHANGE_RATE_HISTORY','Exchange Rate History','Exchange Rate History',now(),1);
  END IF;
  
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName='TRANSLATIONS' and keyName='LIST_OF_CURRENCY_ASSOCIATE_WITH_RECEIPT')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','LIST_OF_CURRENCY_ASSOCIATE_WITH_RECEIPT','List of Currencies Associated with Invoice and Receipt','List of Currencies Associated with Invoice and Receipt',now(),1);
  END IF;
  
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName='TRANSLATIONS' and keyName='INVOICE_CURRENCY')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','INVOICE_CURRENCY','Invoice Currency','Invoice Currency',now(),1);
  END IF;
  
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName='TRANSLATIONS' and keyName='RECEIPT_CURRENCY')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','RECEIPT_CURRENCY','Receipt Currency','Receipt Currency',now(),1);
  END IF;
  
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName='TRANSLATIONS' and keyName='ASSOCIATE_BILLING_AND_RECEIPT_CURRENCY')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','ASSOCIATE_BILLING_AND_RECEIPT_CURRENCY','Associate Billing and Receipt Currency','Associate Billing and Receipt Currency',now(),1);
  END IF;

END $$

-- Execute the stored procedure
CALL V202001091903__Create_MultipleCurrencyUITranslation() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V202001091903__Create_MultipleCurrencyUITranslation $$
 
DELIMITER ;
